/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.browser.test;

import java.awt.Rectangle;
import org.mozilla.browser.MozillaAutomation;
import org.mozilla.browser.test.MozillaTest;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class CoordinatesTest
extends MozillaTest {
    public void testElement2Rects() {
        CoordinatesTest.assertFalse((boolean)MozillaAutomation.blockingLoad(this.moz, "about:license"));
        this.moz.setSize(200, 500);
        Document doc = this.moz.getDocument();
        int frameFlowsNum = 0;
        NodeList nl = doc.getElementsByTagName("a");
        for (int j = 0; j < nl.getLength(); ++j) {
            Element e = (Element)nl.item(j);
            Rectangle[] r = MozillaAutomation.getElementRects(e);
            if (r.length <= 1) continue;
            ++frameFlowsNum;
        }
        CoordinatesTest.assertTrue((frameFlowsNum > 0 ? 1 : 0) != 0);
    }

    public void testPoint2Element() {
        CoordinatesTest.assertFalse((boolean)MozillaAutomation.blockingLoad(this.moz, "about:"));
        Document doc = this.moz.getDocument();
        Element e = MozillaAutomation.getElementFromPoint(doc, 100, 150);
        String name = e.getTagName();
        CoordinatesTest.assertTrue((boolean)"img".equals(name));
    }

    public void testPoint2ElementWithFrames() {
        CoordinatesTest.assertFalse((boolean)MozillaAutomation.blockingLoad(this.moz, CoordinatesTest.resolveURL("frames.html")));
        Document doc = this.moz.getDocument();
        Element e = MozillaAutomation.getElementFromPoint(doc, 100, 100);
        String name = e.getTagName();
        CoordinatesTest.assertTrue((boolean)"img".equals(name));
    }
}

