/*
 * Decompiled with CFR 0.152.
 */
package com.pugh.sockso.resources;

import com.pugh.sockso.Utils;
import com.pugh.sockso.resources.Locale;
import com.pugh.sockso.resources.Resources;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Hashtable;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileLocale
implements Locale {
    private static final Logger log = Logger.getLogger(Locale.class);
    private final Hashtable<String, String> strings = new Hashtable();
    private final String langCode;

    public FileLocale(Resources r, String langCode) {
        this(r, langCode, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileLocale(Resources r, String langCode, Locale defaultLocale) {
        this.langCode = langCode;
        BufferedReader in = null;
        try {
            String localeFile = "locales/sockso." + langCode + ".txt";
            Pattern p = Pattern.compile("^(.*?)=(.*)$");
            String line = "";
            in = new BufferedReader(new InputStreamReader(r.getResourceAsStream(localeFile)));
            while ((line = in.readLine()) != null) {
                Matcher m = p.matcher(line);
                if (!m.matches()) continue;
                this.strings.put(m.group(1), m.group(2));
            }
            if (defaultLocale != null) {
                for (String name : defaultLocale.getNames()) {
                    if (!this.getString(name).equals("")) continue;
                    this.strings.put(name, defaultLocale.getString(name));
                }
            }
            Utils.close(in);
        }
        catch (IOException e) {
            log.error((Object)("Error loading locale: " + e.getMessage()));
        }
        finally {
            Utils.close(in);
        }
    }

    @Override
    public String getLangCode() {
        return this.langCode;
    }

    @Override
    public String getString(String name) {
        String value = this.strings.get(name);
        if (value == null) {
            value = "";
        }
        return value;
    }

    @Override
    public String getString(String name, String[] replacements) {
        String value = this.getString(name);
        for (int i = 0; i < replacements.length; ++i) {
            value = value.replaceAll("%" + (i + 1), replacements[i]);
        }
        return value;
    }

    @Override
    public Set<String> getNames() {
        return this.strings.keySet();
    }
}

