/*
 * Decompiled with CFR 0.152.
 */
package com.pugh.sockso.web.action.browse;

import com.pugh.sockso.Utils;
import com.pugh.sockso.db.Database;
import com.pugh.sockso.music.Artist;
import com.pugh.sockso.templates.web.browse.TByLetter;
import com.pugh.sockso.web.Request;
import com.pugh.sockso.web.action.WebAction;
import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ByLetterer
extends WebAction {
    private static final Logger log = Logger.getLogger(ByLetterer.class);

    @Override
    public void handleRequest() throws IOException, SQLException {
        Request req = this.getRequest();
        String letter = req.getUrlParam(2);
        if (!letter.equals("")) {
            letter = letter.substring(0, 1).toLowerCase();
        }
        this.showByLetter(letter, this.getArtistsByLetter(letter));
    }

    protected void showByLetter(String letter, Vector<Artist> artists) throws IOException, SQLException {
        TByLetter tpl = new TByLetter();
        tpl.setArtists(artists);
        tpl.setLetter(letter);
        this.getResponse().showHtml(tpl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Vector<Artist> getArtistsByLetter(String letter) throws SQLException {
        Vector<Artist> vector;
        ResultSet rs = null;
        PreparedStatement st = null;
        try {
            Database db = this.getDatabase();
            String sql = " select ar.id as id, ar.name as name, count(al.id) as albumCount  from artists ar  left outer join albums al  on al.artist_id = ar.id  where " + (letter.equals("") ? " ascii(lower(ar.name)) < 96  or ascii(lower(ar.name)) > 123 " : " ar.browse_name like ? ") + " group by ar.id, ar.name " + " order by ar.name asc ";
            st = db.prepare(sql);
            if (!letter.equals("")) {
                st.setString(1, letter + "%");
            }
            rs = st.executeQuery();
            Vector<Artist> artists = new Vector<Artist>();
            while (rs.next()) {
                artists.addElement(new Artist(rs.getInt("id"), rs.getString("name"), null, rs.getInt("albumCount"), -1));
            }
            vector = artists;
        }
        catch (Throwable throwable) {
            Utils.close(rs);
            Utils.close(st);
            throw throwable;
        }
        Utils.close(rs);
        Utils.close(st);
        return vector;
    }
}

