/*
 * Decompiled with CFR 0.152.
 */
package snoozesoft.systray4j;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.HashMap;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import snoozesoft.systray4j.SubMenu;
import snoozesoft.systray4j.SysTrayAccess;
import snoozesoft.systray4j.SysTrayManager;
import snoozesoft.systray4j.SysTrayMenu;

class NotAvailable
extends JFrame
implements SysTrayAccess,
MouseListener,
ActionListener {
    private GridBagLayout gridBag;
    private JPanel pnl;
    private HashMap menus;
    private HashMap pops;
    private HashMap icons;
    private int idCounter;
    private String helpMsg;
    private static String linuxHelp = "You are running SysTray for Java on Linux. If you have KDE3 installed,\nthis is a supported platform. However, the native library could not be loaded\nby the JVM. To fix this, make sure the file libsystray4j.so is accessible from\nyour java.library.path.";
    private static String win32Help = "You are running SysTray for Java on Windows, which is a supported platform.\nHowever, the native library could not be loaded by the JVM. To fix this, make sure\nthe file systray4j.dll is accessible from your java.library.path.";
    private static String notAvailHelp = "SysTray for Java is not available on this platform. Currently\nsupported platforms are, Linux with KDE3, and Windows.";

    NotAvailable() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        if (SysTrayManager.isWindows) {
            this.setBounds(screenSize.width - 140, screenSize.height - 110, 110, 70);
        } else {
            this.setBounds(screenSize.width - 170, screenSize.height - 130, 110, 70);
        }
        this.setDefaultCloseOperation(3);
        this.setTitle("SysTray for Java");
        this.menus = new HashMap();
        this.pops = new HashMap();
        this.icons = new HashMap();
        this.idCounter = 1;
        this.gridBag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        this.pnl = new JPanel(this.gridBag);
        c.insets = new Insets(0, 4, 0, 0);
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.anchor = 17;
        JButton btnHelp = new JButton("Help");
        btnHelp.addActionListener(this);
        btnHelp.setActionCommand("-1");
        this.gridBag.setConstraints(btnHelp, c);
        this.pnl.add(btnHelp);
        this.getContentPane().add((Component)this.pnl, "Center");
        this.helpMsg = SysTrayManager.isLinux ? linuxHelp : (SysTrayManager.isWindows ? win32Help : notAvailHelp);
        this.show();
    }

    public boolean isAvailable() {
        return false;
    }

    public void addMainMenu(SysTrayMenu menu, String iconFileName, String toolTip) {
        JPopupMenu pop = new JPopupMenu();
        GridBagConstraints c = new GridBagConstraints();
        c.weighty = 1.0;
        c.insets = new Insets(0, 0, 2, 2);
        c.anchor = 14;
        NAIcon icon = new NAIcon(menu, pop);
        icon.setIcon(new ImageIcon(this.getClass().getResource("rocket.gif")));
        icon.addMouseListener(this);
        icon.setBorder(BorderFactory.createEtchedBorder());
        icon.setToolTipText(toolTip);
        this.gridBag.setConstraints(icon, c);
        this.pnl.add(icon);
        this.pnl.doLayout();
        Integer key = new Integer(this.idCounter);
        this.pops.put(key, pop);
        this.menus.put(key, menu);
        this.icons.put(key, icon);
        menu.id = this.idCounter++;
    }

    public void addSubMenu(SubMenu menu) {
        JMenu pop = new JMenu();
        Integer key = new Integer(this.idCounter);
        this.pops.put(key, pop);
        this.menus.put(key, menu);
        menu.id = this.idCounter++;
    }

    public void setToolTip(int menuId, String tip) {
        NAIcon icon = (NAIcon)this.icons.get(new Integer(menuId));
        icon.setToolTipText(tip);
    }

    public void showIcon(int menuId, boolean show) {
        NAIcon icon = (NAIcon)this.icons.get(new Integer(menuId));
        if (show) {
            GridBagConstraints c = new GridBagConstraints();
            c.weighty = 1.0;
            c.insets = new Insets(0, 0, 2, 2);
            c.anchor = 14;
            this.gridBag.setConstraints(icon, c);
            this.pnl.add(icon);
        } else {
            this.pnl.remove(icon);
        }
        this.pnl.doLayout();
        this.pnl.repaint();
    }

    public void setIcon(int menuId, String iconFileName) {
        System.err.println("systray4j: method not available");
    }

    public void enableItem(int menuId, int itemIndex, boolean enable) {
        JPopupMenu pop = null;
        Object obj = this.pops.get(new Integer(menuId));
        pop = obj instanceof JMenu ? ((JMenu)obj).getPopupMenu() : (JPopupMenu)obj;
        Component c = pop.getComponent(pop.getComponentCount() - itemIndex - 1);
        c.setEnabled(enable);
    }

    public void checkItem(int menuId, int itemIndex, boolean check) {
        JPopupMenu pop = null;
        Object obj = this.pops.get(new Integer(menuId));
        pop = obj instanceof JMenu ? ((JMenu)obj).getPopupMenu() : (JPopupMenu)obj;
        JMenuItem item = (JMenuItem)pop.getComponent(pop.getComponentCount() - itemIndex - 1);
        item.setSelected(check);
    }

    public void setItemLabel(int menuId, int itemIndex, String label) {
        JPopupMenu pop = null;
        Object obj = this.pops.get(new Integer(menuId));
        pop = obj instanceof JMenu ? ((JMenu)obj).getPopupMenu() : (JPopupMenu)obj;
        JMenuItem item = (JMenuItem)pop.getComponent(pop.getComponentCount() - itemIndex - 1);
        item.setText(label);
    }

    public void addItem(int menuId, int itemIndex, String label, boolean checkable, boolean check, boolean enable) {
        Object obj = this.pops.get(new Integer(menuId));
        if (obj instanceof JPopupMenu) {
            JPopupMenu pop = (JPopupMenu)obj;
            int index = pop.getComponentCount() - itemIndex;
            if (label.equals("#SEP")) {
                pop.insert(new JPopupMenu.Separator(), index);
            } else if (label.startsWith("#SUB<")) {
                Integer key = new Integer(label.substring(5, label.indexOf(">")));
                JMenu submenu = (JMenu)this.pops.get(key);
                submenu.setEnabled(enable);
                submenu.setText(label.substring(label.indexOf("><") + 2, label.length() - 1));
                pop.insert(submenu, index);
            } else {
                JMenuItem item = null;
                if (checkable) {
                    item = new JCheckBoxMenuItem(label);
                    item.setSelected(check);
                } else {
                    item = new JMenuItem(label);
                }
                item.setActionCommand(String.valueOf(menuId));
                item.addActionListener(this);
                item.setEnabled(enable);
                pop.insert(item, index);
            }
        } else {
            JMenu pop = (JMenu)obj;
            int index = pop.getItemCount() - itemIndex;
            if (label.equals("#SEP")) {
                pop.insertSeparator(index);
            } else if (label.startsWith("#SUB<")) {
                Integer key = new Integer(label.substring(5, label.indexOf(">")));
                JMenu submenu = (JMenu)this.pops.get(key);
                submenu.setEnabled(enable);
                submenu.setText(label.substring(label.indexOf("><") + 2, label.length() - 1));
                pop.insert(submenu, index);
            } else {
                JMenuItem item = null;
                if (checkable) {
                    item = new JCheckBoxMenuItem(label);
                    item.setSelected(check);
                } else {
                    item = new JMenuItem(label);
                }
                item.setActionCommand(String.valueOf(menuId));
                item.addActionListener(this);
                item.setEnabled(enable);
                pop.insert(item, index);
            }
        }
    }

    public void removeItem(int menuId, int itemIndex) {
        JPopupMenu pop = null;
        Object obj = this.pops.get(new Integer(menuId));
        pop = obj instanceof JMenu ? ((JMenu)obj).getPopupMenu() : (JPopupMenu)obj;
        pop.remove(pop.getComponentCount() - itemIndex - 1);
    }

    public void removeAll(int menuId) {
        JPopupMenu pop = null;
        Object obj = this.pops.get(new Integer(menuId));
        pop = obj instanceof JMenu ? ((JMenu)obj).getPopupMenu() : (JPopupMenu)obj;
        pop.removeAll();
    }

    public void dispose() {
        this.dispose();
    }

    public void mouseClicked(MouseEvent event) {
        NAIcon icon = (NAIcon)event.getSource();
        if (event.getButton() == 1) {
            icon.menu.iconLeftClicked(event.getClickCount() == 2);
        } else if (event.getButton() == 3) {
            Dimension size = icon.pop.getSize();
            icon.pop.show(icon, event.getX(), event.getY());
            size = icon.pop.getSize();
            icon.pop.show(icon, event.getX() - size.width, event.getY() - size.height);
        }
    }

    public void actionPerformed(ActionEvent event) {
        JPopupMenu pop = null;
        Integer key = new Integer(event.getActionCommand());
        Object obj = this.menus.get(key);
        if (obj instanceof SysTrayMenu) {
            SysTrayMenu menu = (SysTrayMenu)obj;
            pop = (JPopupMenu)this.pops.get(key);
            int index = pop.getComponentCount() - pop.getComponentIndex((Component)event.getSource());
            menu.menuItemSelected(index - 1);
        } else if (obj instanceof SubMenu) {
            SubMenu menu = (SubMenu)obj;
            pop = ((JMenu)this.pops.get(key)).getPopupMenu();
            int index = pop.getComponentCount() - pop.getComponentIndex((Component)event.getSource());
            menu.menuItemSelected(index - 1);
        } else {
            String message = this.helpMsg;
            if (SysTrayManager.isWindows || SysTrayManager.isLinux) {
                String path = "java.library.path = ";
                String token = "";
                int lineLength = path.length();
                String sep = System.getProperty("path.separator");
                String pathLong = System.getProperty("java.library.path");
                StringTokenizer tok = new StringTokenizer(pathLong, sep, true);
                while (tok.hasMoreTokens()) {
                    if (token.equals(sep) && lineLength > 50) {
                        path = path + "\n";
                        lineLength = 0;
                    }
                    token = tok.nextToken();
                    path = path + token;
                    lineLength += token.length();
                }
                message = message + "\n\n" + path;
            }
            JOptionPane.showMessageDialog(null, message, "Help", 1);
        }
    }

    public String getHelp() {
        return null;
    }

    public void mouseEntered(MouseEvent event) {
    }

    public void mouseExited(MouseEvent event) {
    }

    public void mousePressed(MouseEvent event) {
    }

    public void mouseReleased(MouseEvent event) {
    }

    private class NAIcon
    extends JLabel {
        SysTrayMenu menu;
        JPopupMenu pop;

        NAIcon(SysTrayMenu menu, JPopupMenu pop) {
            this.menu = menu;
            this.pop = pop;
        }
    }
}

