/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mx.loading;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.jboss.logging.Logger;
import org.jboss.mx.loading.ClassLoaderUtils;

public class ClassPreloadService {
    static Logger log = Logger.getLogger(ClassPreloadService.class);
    private String[] includePattern = new String[0];
    private String[] excludePattern = new String[0];
    private boolean simpleMatch;
    boolean trace;

    public String[] getIncludePatterns() {
        return this.includePattern;
    }

    public void setIncludePatterns(String[] includePattern) {
        this.includePattern = includePattern;
    }

    public String[] getExcludePatterns() {
        return this.excludePattern;
    }

    public void setExcludePatterns(String[] excludePattern) {
        this.excludePattern = excludePattern;
    }

    public boolean isSimpleMatch() {
        return this.simpleMatch;
    }

    public void setSimpleMatch(boolean simpleMatch) {
        this.simpleMatch = simpleMatch;
    }

    public URL[] getRawClassPath() {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        URL[] fullCP = ClassLoaderUtils.getClassLoaderURLs(loader);
        return fullCP;
    }

    public void start() {
        this.trace = log.isTraceEnabled();
        log.debug((Object)("Starting, includes=" + Arrays.asList(this.includePattern) + ", excludes=" + this.excludePattern));
        Pattern[] includes = this.compileIncludes();
        Pattern[] excludes = this.compileExcludes();
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        URL[] rawCP = ClassLoaderUtils.getClassLoaderURLs(loader);
        URL[] cp = this.filterCP(rawCP, includes, excludes);
        int loadedClasses = 0;
        int loadErrors = 0;
        for (int n = 0; n < cp.length; ++n) {
            URL u = cp[n];
            try {
                InputStream is = u.openStream();
                ZipInputStream zis = new ZipInputStream(is);
                ZipEntry ze = zis.getNextEntry();
                while (ze != null) {
                    block8: {
                        String name = ze.getName();
                        if (name.endsWith(".class")) {
                            int length = name.length();
                            String cname = name.replace('/', '.').substring(0, length - 6);
                            try {
                                loader.loadClass(cname);
                                ++loadedClasses;
                                if (this.trace) {
                                    log.trace((Object)("loaded class: " + cname));
                                }
                            }
                            catch (Throwable e) {
                                ++loadErrors;
                                if (!this.trace) break block8;
                                log.trace((Object)("Failed to load class, " + e.getMessage()));
                            }
                        }
                    }
                    ze = zis.getNextEntry();
                }
                zis.close();
                continue;
            }
            catch (IOException ignore) {
                // empty catch block
            }
        }
        log.info((Object)("Loaded " + loadedClasses + " classes, " + loadErrors + " CNFEs"));
    }

    public Pattern[] compileIncludes() {
        ArrayList<Pattern> tmp = new ArrayList<Pattern>();
        int count = this.includePattern != null ? this.includePattern.length : 0;
        for (int n = 0; n < count; ++n) {
            String p = this.includePattern[n];
            Pattern pat = Pattern.compile(p);
            tmp.add(pat);
        }
        Pattern[] includes = new Pattern[tmp.size()];
        tmp.toArray(includes);
        return includes;
    }

    public Pattern[] compileExcludes() {
        ArrayList<Pattern> tmp = new ArrayList<Pattern>();
        int count = this.excludePattern != null ? this.excludePattern.length : 0;
        for (int n = 0; n < count; ++n) {
            String p = this.excludePattern[n];
            Pattern pat = Pattern.compile(p);
            tmp.add(pat);
        }
        Pattern[] includes = new Pattern[tmp.size()];
        tmp.toArray(includes);
        return includes;
    }

    public URL[] filterCP(URL[] rawCP, Pattern[] includes, Pattern[] excludes) {
        if (this.trace) {
            log.trace((Object)("filterCP, rawCP=" + Arrays.asList(rawCP)));
        }
        ArrayList<URL> tmp = new ArrayList<URL>();
        int count = rawCP != null ? rawCP.length : 0;
        for (int m = 0; m < count; ++m) {
            URL pathURL = rawCP[m];
            String path = pathURL.toString();
            boolean excluded = false;
            for (int n = 0; n < excludes.length; ++n) {
                Pattern p = excludes[n];
                Matcher matcher = p.matcher(path);
                if (this.simpleMatch && path.endsWith(p.pattern())) {
                    excluded = true;
                    break;
                }
                if (!matcher.matches()) continue;
                excluded = true;
                break;
            }
            if (excluded) {
                log.debug((Object)("Excluded: " + pathURL));
                continue;
            }
            boolean included = includes.length == 0;
            for (int n = 0; n < includes.length; ++n) {
                Pattern p = includes[n];
                Matcher matcher = p.matcher(path);
                if (this.simpleMatch && path.endsWith(p.pattern())) {
                    tmp.add(pathURL);
                    continue;
                }
                if (!matcher.matches()) continue;
                tmp.add(pathURL);
            }
            if (!included) continue;
            log.debug((Object)("Included: " + pathURL));
            tmp.add(pathURL);
        }
        URL[] cp = new URL[tmp.size()];
        tmp.toArray(cp);
        return cp;
    }
}

