/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop;

import gnu.trove.TLongObjectHashMap;
import java.lang.ref.WeakReference;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javassist.runtime.Inner;
import org.jboss.aop.Advisor;
import org.jboss.aop.AspectManager;
import org.jboss.aop.CallerConstructorInfo;
import org.jboss.aop.CallerMethodInfo;
import org.jboss.aop.ConByConInfo;
import org.jboss.aop.ConByMethodInfo;
import org.jboss.aop.FieldInfo;
import org.jboss.aop.InstanceAdvised;
import org.jboss.aop.InstanceAdvisor;
import org.jboss.aop.InterceptorChainObserver;
import org.jboss.aop.MethodByConInfo;
import org.jboss.aop.MethodByMethodInfo;
import org.jboss.aop.MethodInfo;
import org.jboss.aop.SecurityActions;
import org.jboss.aop.advice.AdviceBinding;
import org.jboss.aop.advice.AspectDefinition;
import org.jboss.aop.advice.ClassifiedBindingAndPointcutCollection;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.instrument.ConstructorExecutionTransformer;
import org.jboss.aop.instrument.FieldAccessTransformer;
import org.jboss.aop.instrument.MethodExecutionTransformer;
import org.jboss.aop.introduction.InterfaceIntroduction;
import org.jboss.aop.joinpoint.ConstructorCalledByConstructorInvocation;
import org.jboss.aop.joinpoint.ConstructorCalledByConstructorJoinpoint;
import org.jboss.aop.joinpoint.ConstructorCalledByMethodInvocation;
import org.jboss.aop.joinpoint.ConstructorCalledByMethodJoinpoint;
import org.jboss.aop.joinpoint.ConstructorInvocation;
import org.jboss.aop.joinpoint.FieldJoinpoint;
import org.jboss.aop.joinpoint.FieldReadInvocation;
import org.jboss.aop.joinpoint.FieldWriteInvocation;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aop.joinpoint.MethodCalledByConstructorInvocation;
import org.jboss.aop.joinpoint.MethodCalledByConstructorJoinpoint;
import org.jboss.aop.joinpoint.MethodCalledByMethodInvocation;
import org.jboss.aop.joinpoint.MethodCalledByMethodJoinpoint;
import org.jboss.aop.joinpoint.MethodInvocation;
import org.jboss.aop.metadata.ClassMetaDataBinding;
import org.jboss.aop.metadata.ClassMetaDataLoader;
import org.jboss.aop.util.Advisable;
import org.jboss.aop.util.BindingClassifier;
import org.jboss.aop.util.ConstructorComparator;
import org.jboss.aop.util.FieldComparator;
import org.jboss.aop.util.MethodHashing;
import org.jboss.aop.util.ReflectUtils;
import org.jboss.aop.util.UnmodifiableEmptyCollections;
import org.jboss.logging.Logger;
import org.jboss.util.NotImplementedException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassAdvisor
extends Advisor {
    private static final Logger logger = Logger.getLogger(ClassAdvisor.class);
    public static final String NOT_TRANSFORMABLE_SUFFIX = "$aop";
    protected TLongObjectHashMap unadvisedMethods = new TLongObjectHashMap();
    private volatile MethodByMethodData methodByMethodData;
    private volatile ConByMethodData conByMethodData;
    protected HashMap<String, TLongObjectHashMap>[] methodCalledByConBindings;
    protected HashMap<String, TLongObjectHashMap>[] methodCalledByConInterceptors;
    protected HashMap<String, ArrayList<ArrayList<AdviceBinding>>> backrefMethodCalledByConstructorBindings = new HashMap();
    protected HashMap<String, TLongObjectHashMap>[] conCalledByConBindings;
    protected HashMap<String, TLongObjectHashMap>[] conCalledByConInterceptors;
    protected HashMap<String, ArrayList<ArrayList<AdviceBinding>>> backrefConCalledByConstructorBindings = new HashMap();
    private Interceptor[][] fieldReadInterceptors;
    protected FieldInfo[] fieldReadInfos;
    private Interceptor[][] fieldWriteInterceptors;
    protected FieldInfo[] fieldWriteInfos;
    protected Field[] advisedFields;
    private volatile HashMap<AspectDefinition, HashMap<FieldJoinpoint, Object>> fieldAspectsWithNoInstance = new HashMap();
    protected boolean initialized = false;
    private InterceptorChainObserver interceptorChainObserver;

    public ClassAdvisor(String classname, AspectManager manager) {
        super(classname, manager);
    }

    public ClassAdvisor(Class<?> clazz, AspectManager manager) {
        this(clazz.getName(), manager);
        this.clazz = clazz;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getFieldAspect(FieldJoinpoint joinpoint, AspectDefinition def) {
        HashMap<Object, Object> hashMap;
        HashMap<FieldJoinpoint, Object> map = this.fieldAspectsWithNoInstance.get(def);
        if (map == null) {
            hashMap = this.fieldAspectsWithNoInstance;
            synchronized (hashMap) {
                map = this.fieldAspectsWithNoInstance.get(def);
                if (map == null) {
                    map = new HashMap();
                    this.fieldAspectsWithNoInstance.put(def, map);
                }
            }
        }
        if (map.containsKey(joinpoint)) {
            return map.get(joinpoint);
        }
        hashMap = map;
        synchronized (hashMap) {
            if (map.containsKey(joinpoint)) {
                return map.get(joinpoint);
            }
            Object aspect = def.getFactory().createPerJoinpoint(this, joinpoint);
            map.put(joinpoint, aspect);
            return aspect;
        }
    }

    public Field[] getAdvisedFields() {
        return this.advisedFields;
    }

    public TLongObjectHashMap getAdvisedMethods() {
        return this.advisedMethods;
    }

    protected TLongObjectHashMap getUnadvisedMethods() {
        return this.unadvisedMethods;
    }

    @Override
    public Constructor<?>[] getConstructors() {
        return this.constructors;
    }

    public TLongObjectHashMap getMethodCalledByMethodInterceptors() {
        return this.getMethodByMethodData().getMethodCalledByMethodInterceptors();
    }

    public HashMap<String, TLongObjectHashMap>[] getMethodCalledByConInterceptors() {
        return this.methodCalledByConInterceptors;
    }

    public HashMap<String, TLongObjectHashMap>[] getConCalledByConInterceptors() {
        return this.conCalledByConInterceptors;
    }

    public TLongObjectHashMap getConCalledByMethodInterceptors() {
        return this.getConByMethodData().getConCalledByMethodInterceptors();
    }

    public TLongObjectHashMap getMethodCalledByMethodBindings() {
        return this.getMethodByMethodData().getMethodCalledByMethodBindings();
    }

    public Interceptor[][] getFieldReadInterceptors() {
        throw new NotImplementedException("Use getFieldReadInfos");
    }

    public FieldInfo[] getFieldReadInfos() {
        return this.fieldReadInfos;
    }

    public Interceptor[][] getFieldWriteInterceptors() {
        throw new NotImplementedException("Use getFieldWriteInfos");
    }

    public FieldInfo[] getFieldWriteInfos() {
        return this.fieldWriteInfos;
    }

    public TLongObjectHashMap getMethodInterceptors() {
        return this.methodInfos.infos;
    }

    public synchronized void attachClass(final Class<?> clazz) {
        if (this.initialized) {
            return;
        }
        try {
            final AspectManager theManager = this.manager;
            this.manager.registerClassLoader(SecurityActions.getClassLoader(clazz));
            AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    theManager.attachMetaData(ClassAdvisor.this, clazz);
                    ClassAdvisor.this.interfaceIntroductions.clear();
                    ClassAdvisor.this.clazz = clazz;
                    ClassAdvisor.this.rebindClassMetaData();
                    theManager.applyInterfaceIntroductions((Advisor)ClassAdvisor.this, clazz);
                    ClassAdvisor.this.createFieldTable();
                    ClassAdvisor.this.createMethodTables();
                    ClassAdvisor.this.createConstructorTables();
                    ClassAdvisor.this.populateMixinMethods();
                    ClassAdvisor.this.rebindClassMetaData();
                    ClassAdvisor.this.createInterceptorChains();
                    ClassAdvisor.this.initialized = true;
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw new RuntimeException(e.getException());
        }
    }

    private static Method getMethod(Class<?> clazz, Method method) throws NoSuchMethodException {
        if (clazz == null || clazz.equals(Object.class)) {
            throw new NoSuchMethodException(method.getName());
        }
        try {
            String wrappedName = ClassAdvisor.notAdvisedMethodName(clazz.getName(), method.getName());
            return clazz.getMethod(wrappedName, method.getParameterTypes());
        }
        catch (NoSuchMethodException e) {
            return ClassAdvisor.getMethod(clazz.getSuperclass(), method);
        }
    }

    public int getConstructorIndex(Constructor<?> constructor) {
        for (int i = 0; i < this.constructors.length; ++i) {
            if (!constructor.equals(this.constructors[i])) continue;
            return i;
        }
        return -1;
    }

    public int getFieldIndex(Field field) {
        for (int i = 0; i < this.advisedFields.length; ++i) {
            if (!field.equals(this.advisedFields[i])) continue;
            return i;
        }
        return -1;
    }

    protected void populateMixinMethods() throws Exception {
        ArrayList<InterfaceIntroduction> introductions = this.getInterfaceIntroductions();
        for (InterfaceIntroduction introduction : introductions) {
            ArrayList<InterfaceIntroduction.Mixin> mixins = introduction.getMixins();
            for (int i = 0; i < mixins.size(); ++i) {
                InterfaceIntroduction.Mixin mixin = mixins.get(i);
                ClassLoader cl = this.getClassLoader();
                if (cl == null) {
                    cl = SecurityActions.getContextClassLoader();
                }
                cl.loadClass(mixin.getClassName());
                String[] interfaces = mixin.getInterfaces();
                for (int j = 0; j < interfaces.length; ++j) {
                    Class<?> intf = cl.loadClass(interfaces[j]);
                    if (!intf.isAssignableFrom(this.clazz)) continue;
                    Method[] methods = intf.getMethods();
                    for (int k = 0; k < methods.length; ++k) {
                        Method method = ClassAdvisor.getMethod(this.clazz, methods[k]);
                        long hash = MethodHashing.methodHash(method);
                        this.unadvisedMethods.put(hash, (Object)method);
                    }
                }
            }
        }
    }

    @Override
    public synchronized void removeAdviceBinding(AdviceBinding binding) {
        this.removeCallerPointcut(binding);
        super.removeAdviceBinding(binding);
    }

    @Override
    public synchronized void removeAdviceBindings(ArrayList<AdviceBinding> bindings) {
        for (int i = 0; i < bindings.size(); ++i) {
            AdviceBinding binding = bindings.get(i);
            this.removeCallerPointcut(binding);
        }
        this.adviceBindings.removeAll(bindings);
        this.rebuildInterceptors();
        this.doesHaveAspects = this.adviceBindings.size() > 0;
    }

    protected void resolveFieldPointcut(FieldInfo[] newFieldInfos, Interceptor[][] interceptors, AdviceBinding binding, boolean write) {
        for (int i = 0; i < newFieldInfos.length; ++i) {
            Field field = newFieldInfos[i].getField();
            if ((write || !binding.getPointcut().matchesGet((Advisor)this, field)) && (!write || !binding.getPointcut().matchesSet((Advisor)this, field))) continue;
            if (AspectManager.verbose) {
                logger.debug((Object)("field matched " + (write ? "write" : "read") + " binding: " + field));
            }
            this.adviceBindings.add(binding);
            binding.addAdvisor(this);
            this.pointcutResolved(newFieldInfos[i], binding, new FieldJoinpoint(field));
            if (!AspectManager.maintainAdvisorMethodInterceptors || !this.initialized) continue;
            interceptors[i] = newFieldInfos[i].getInterceptors();
        }
    }

    protected void initializeMethodChain() {
        long[] keys = this.advisedMethods.keys();
        for (int i = 0; i < keys.length; ++i) {
            MethodInfo info = new MethodInfo();
            Method amethod = (Method)this.advisedMethods.get(keys[i]);
            info.setAdvisedMethod(amethod);
            Method umethod = (Method)this.unadvisedMethods.get(keys[i]);
            if (umethod == null) {
                umethod = amethod;
            }
            info.setUnadvisedMethod(umethod);
            info.setHash(keys[i]);
            info.setAdvisor(this);
            this.methodInfos.put(keys[i], info);
            try {
                Field infoField = this.clazz.getDeclaredField(MethodExecutionTransformer.getMethodInfoFieldName(amethod.getName(), keys[i]));
                infoField.setAccessible(true);
                infoField.set(null, new WeakReference<MethodInfo>(info));
                continue;
            }
            catch (NoSuchFieldException e) {
                continue;
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
    }

    protected void initializeFieldReadChain() {
        this.fieldReadInfos = new FieldInfo[this.advisedFields.length];
        for (int i = 0; i < this.advisedFields.length; ++i) {
            FieldInfo info = new FieldInfo();
            info.setAdvisedField(this.advisedFields[i]);
            info.setAdvisor(this);
            info.setIndex(i);
            try {
                info.setWrapper(this.clazz.getDeclaredMethod(FieldAccessTransformer.fieldRead(this.advisedFields[i].getName()), Object.class));
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
            this.fieldReadInfos[i] = info;
            try {
                Field infoField = this.clazz.getDeclaredField(FieldAccessTransformer.getFieldReadInfoFieldName(this.advisedFields[i].getName()));
                infoField.setAccessible(true);
                infoField.set(null, new WeakReference<FieldInfo>(info));
                continue;
            }
            catch (NoSuchFieldException e) {
                continue;
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
    }

    protected void initializeFieldWriteChain() {
        this.fieldWriteInfos = new FieldInfo[this.advisedFields.length];
        for (int i = 0; i < this.advisedFields.length; ++i) {
            FieldInfo info = new FieldInfo();
            info.setAdvisedField(this.advisedFields[i]);
            info.setAdvisor(this);
            info.setIndex(i);
            try {
                info.setWrapper(this.clazz.getDeclaredMethod(FieldAccessTransformer.fieldWrite(this.advisedFields[i].getName()), Object.class, this.advisedFields[i].getType()));
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
            this.fieldWriteInfos[i] = info;
            try {
                Field infoField = this.clazz.getDeclaredField(FieldAccessTransformer.getFieldWriteInfoFieldName(this.advisedFields[i].getName()));
                infoField.setAccessible(true);
                infoField.set(null, new WeakReference<FieldInfo>(info));
                continue;
            }
            catch (NoSuchFieldException e) {
                continue;
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
    }

    protected void createInterceptorChains() throws Exception {
        if (AspectManager.verbose && logger.isDebugEnabled()) {
            logger.debug((Object)("Creating chains for " + this.clazz + " " + this.getClassLoader()));
        }
        if (this.fieldReadInfos == null) {
            this.initializeFieldReadChain();
            this.initializeFieldWriteChain();
            this.initializeMethodChain();
        }
        this.initializeConstructorChain();
        this.initializeConstructionChain();
        this.resolveBindings(this.manager);
        this.finalizeChains();
        this.populateInterceptorsFromInfos();
        boolean bl = this.doesHaveAspects = this.adviceBindings.size() > 0;
        if (this.interceptorChainObserver != null) {
            this.interceptorChainObserver.interceptorChainsUpdated(this.fieldReadInfos, this.fieldWriteInfos, this.constructorInfos, this.methodInfos);
        }
    }

    private void resolveBindings(AspectManager manager) {
        ClassifiedBindingAndPointcutCollection bindingCol = manager.getBindingCollection();
        for (AdviceBinding binding : bindingCol.getFieldReadBindings()) {
            if (AspectManager.verbose && logger.isDebugEnabled()) {
                logger.debug((Object)("iterate binding " + binding.getName() + " " + binding.getPointcut().getExpr()));
            }
            this.resolveFieldPointcut(this.fieldReadInfos, this.fieldReadInterceptors, binding, false);
        }
        for (AdviceBinding binding : bindingCol.getFieldWriteBindings()) {
            if (AspectManager.verbose && logger.isDebugEnabled()) {
                logger.debug((Object)("iterate binding " + binding.getName() + " " + binding.getPointcut().getExpr()));
            }
            this.resolveFieldPointcut(this.fieldWriteInfos, this.fieldWriteInterceptors, binding, true);
        }
        for (AdviceBinding binding : bindingCol.getConstructionBindings()) {
            if (AspectManager.verbose && logger.isDebugEnabled()) {
                logger.debug((Object)("iterate binding " + binding.getName() + " " + binding.getPointcut().getExpr()));
            }
            this.resolveConstructionPointcut(binding);
        }
        for (AdviceBinding binding : bindingCol.getConstructorExecutionBindings()) {
            if (AspectManager.verbose && logger.isDebugEnabled()) {
                logger.debug((Object)("iterate binding " + binding.getName() + " " + binding.getPointcut().getExpr()));
            }
            this.resolveConstructorPointcut(binding);
        }
        for (AdviceBinding binding : bindingCol.getMethodExecutionBindings()) {
            if (AspectManager.verbose && logger.isDebugEnabled()) {
                logger.debug((Object)("iterate binding " + binding.getName() + " " + binding.getPointcut().getExpr()));
            }
            this.resolveMethodPointcut(binding);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateInterceptorChains() throws Exception {
        if (AspectManager.verbose && logger.isDebugEnabled()) {
            logger.debug((Object)("Updating chains for " + this.clazz + " " + (this.clazz != null ? this.getClassLoader() : null)));
        }
        this.lockWriteChains();
        try {
            this.resetChains();
            this.resolveBindings(this.manager);
            this.finalizeChains();
            this.populateInterceptorsFromInfos();
        }
        finally {
            this.unlockWriteChains();
        }
        boolean bl = this.doesHaveAspects = this.adviceBindings.size() > 0;
        if (this.interceptorChainObserver != null) {
            this.interceptorChainObserver.interceptorChainsUpdated(this.fieldReadInfos, this.fieldWriteInfos, this.constructorInfos, this.methodInfos);
        }
    }

    private void lockWriteChains() {
        this.lockWriteChain(this.methodInfos);
        this.lockWriteChain(this.fieldReadInfos);
        this.lockWriteChain(this.fieldWriteInfos);
        this.lockWriteChain(this.constructorInfos);
        this.lockWriteChain(this.constructionInfos);
    }

    private void unlockWriteChains() {
        this.unlockWriteChain(this.methodInfos);
        this.unlockWriteChain(this.fieldReadInfos);
        this.unlockWriteChain(this.fieldWriteInfos);
        this.unlockWriteChain(this.constructorInfos);
        this.unlockWriteChain(this.constructionInfos);
    }

    private void resetChains() {
        this.resetChain(this.methodInfos);
        this.resetChain(this.fieldReadInfos);
        this.resetChain(this.fieldWriteInfos);
        this.resetChain(this.constructorInfos);
        this.resetChain(this.constructionInfos);
    }

    private void resetChainsKeepInterceptors() {
        this.resetChainKeepInterceptors(this.methodInfos);
        this.resetChainKeepInterceptors(this.fieldReadInfos);
        this.resetChainKeepInterceptors(this.fieldWriteInfos);
        this.resetChainKeepInterceptors(this.constructorInfos);
        this.resetChainKeepInterceptors(this.constructionInfos);
    }

    protected void finalizeChains() {
        this.finalizeMethodChain();
        this.finalizeChain(this.fieldReadInfos);
        this.finalizeChain(this.fieldWriteInfos);
        this.finalizeChain(this.constructorInfos);
        this.finalizeChain(this.constructionInfos);
    }

    protected void resolvePointcuts(AdviceBinding binding) {
        if (AspectManager.verbose && logger.isDebugEnabled()) {
            logger.debug((Object)("iterate binding " + binding.getName() + " " + binding.getPointcut().getExpr()));
        }
        if (BindingClassifier.isExecution(binding)) {
            this.resolveMethodPointcut(binding);
        }
        if (BindingClassifier.isGet(binding)) {
            this.resolveFieldPointcut(this.fieldReadInfos, this.fieldReadInterceptors, binding, false);
        }
        if (BindingClassifier.isSet(binding)) {
            this.resolveFieldPointcut(this.fieldWriteInfos, this.fieldWriteInterceptors, binding, true);
        }
        if (BindingClassifier.isConstructorExecution(binding)) {
            this.resolveConstructorPointcut(binding);
        }
        if (BindingClassifier.isConstruction(binding)) {
            this.resolveConstructionPointcut(binding);
        }
    }

    @Override
    protected void rebuildInterceptorsForRemovedBinding(AdviceBinding binding) {
        if (this.initialized) {
            if (System.getSecurityManager() == null) {
                RebuildInterceptorsAction.NON_PRIVILEGED.rebuildInterceptorsForRemovedBinding(this, binding);
            } else {
                RebuildInterceptorsAction.PRIVILEGED.rebuildInterceptorsForRemovedBinding(this, binding);
            }
        }
    }

    protected void doRebuildInterceptorsForRemovedBinding(AdviceBinding removedBinding) {
        this.lockWriteChains();
        if (BindingClassifier.isExecution(removedBinding)) {
            this.updateMethodPointcutAfterRemove(removedBinding);
        }
        if (BindingClassifier.isGet(removedBinding) || BindingClassifier.isSet(removedBinding)) {
            this.updateFieldPointcutAfterRemove(this.fieldReadInfos, removedBinding, false);
            this.updateFieldPointcutAfterRemove(this.fieldWriteInfos, removedBinding, true);
        }
        if (BindingClassifier.isConstructorExecution(removedBinding)) {
            this.updateConstructorPointcutAfterRemove(removedBinding);
        }
        if (BindingClassifier.isConstruction(removedBinding)) {
            this.updateConstructionPointcutAfterRemove(removedBinding);
        }
        this.finalizeChains();
        this.unlockWriteChains();
        if (this.interceptorChainObserver != null) {
            this.interceptorChainObserver.interceptorChainsUpdated(this.fieldReadInfos, this.fieldWriteInfos, this.constructorInfos, this.methodInfos);
        }
        try {
            this.rebuildCallerInterceptors();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    protected void updateFieldPointcutAfterRemove(FieldInfo fieldInfo, int i, boolean write) {
        if (AspectManager.maintainAdvisorMethodInterceptors) {
            if (write) {
                this.fieldWriteInterceptors[i] = fieldInfo.getInterceptors();
            } else {
                this.fieldReadInterceptors[i] = fieldInfo.getInterceptors();
            }
        }
    }

    private MethodByConInfo initializeConstructorCallerInterceptorsMap(Class<?> callingClass, int callingIndex, String calledClass, long calledMethodHash, Method calledMethod) throws Exception {
        TLongObjectHashMap calledMethodsMap;
        HashMap<String, Object> calledClassesMap = this.methodCalledByConInterceptors[callingIndex];
        if (calledClassesMap == null) {
            calledClassesMap = new HashMap();
            this.methodCalledByConInterceptors[callingIndex] = calledClassesMap;
        }
        if ((calledMethodsMap = calledClassesMap.get(calledClass)) == null) {
            calledMethodsMap = new TLongObjectHashMap();
            calledClassesMap.put(calledClass, calledMethodsMap);
        }
        SecurityActions.setAccessible(calledMethod);
        Class<?> calledClazz = this.getClassLoader().loadClass(calledClass);
        MethodByConInfo info = new MethodByConInfo(this, calledClazz, callingClass, callingIndex, calledMethod, calledMethodHash, null);
        calledMethodsMap.put(calledMethodHash, (Object)info);
        return info;
    }

    private ConByConInfo initializeConCalledByConInterceptorsMap(Class<?> callingClass, int callingIndex, String calledClass, long calledConHash, Constructor<?> calledCon) throws Exception {
        TLongObjectHashMap calledMethodsMap;
        HashMap<String, Object> calledClassesMap = this.conCalledByConInterceptors[callingIndex];
        if (calledClassesMap == null) {
            calledClassesMap = new HashMap();
            this.conCalledByConInterceptors[callingIndex] = calledClassesMap;
        }
        if ((calledMethodsMap = calledClassesMap.get(calledClass)) == null) {
            calledMethodsMap = new TLongObjectHashMap();
            calledClassesMap.put(calledClass, calledMethodsMap);
        }
        ConByConInfo info = this.createConByConInfo(callingClass, callingIndex, calledClass, calledCon, calledConHash);
        calledMethodsMap.put(calledConHash, (Object)info);
        return info;
    }

    private ConByConInfo createConByConInfo(Class<?> callingClass, int callingIndex, String calledClass, Constructor<?> calledCon, long calledConHash) throws Exception {
        calledCon.setAccessible(true);
        Class<?> calledClazz = this.getClassLoader().loadClass(calledClass);
        try {
            int index = calledClass.lastIndexOf(46);
            String baseClassName = calledClass.substring(index + 1);
            Method wrapper = calledCon.getDeclaringClass().getDeclaredMethod(ConstructorExecutionTransformer.constructorFactory(baseClassName), calledCon.getParameterTypes());
            return new ConByConInfo(this, calledClazz, callingClass, callingIndex, calledCon, calledConHash, wrapper, null);
        }
        catch (NoSuchMethodException e) {
            return new ConByConInfo(this, calledClazz, callingClass, callingIndex, calledCon, calledConHash, null, null);
        }
    }

    protected void rebuildCallerInterceptors() throws Exception {
        ArrayList<AdviceBinding> bindings;
        long calledHash;
        int j;
        long[] calledKeys;
        TLongObjectHashMap calledMethods;
        String cname;
        HashMap<String, TLongObjectHashMap> calledClasses;
        int i;
        if (this.methodByMethodData != null) {
            this.getMethodByMethodData().rebuildCallerInterceptors();
        }
        for (i = 0; i < this.methodCalledByConInterceptors.length; ++i) {
            calledClasses = this.methodCalledByConInterceptors[i];
            if (calledClasses == null) continue;
            for (Map.Entry<String, TLongObjectHashMap> entry : calledClasses.entrySet()) {
                cname = entry.getKey();
                calledMethods = entry.getValue();
                calledKeys = calledMethods.keys();
                for (j = 0; j < calledKeys.length; ++j) {
                    calledHash = calledKeys[j];
                    bindings = this.getConstructorCallerBindings(i, cname, calledHash);
                    this.bindConstructorCallerInterceptorChain(bindings, i, cname, calledHash);
                }
            }
        }
        if (this.conByMethodData != null) {
            this.getConByMethodData().rebuildCallerInterceptors();
        }
        for (i = 0; i < this.conCalledByConInterceptors.length; ++i) {
            calledClasses = this.conCalledByConInterceptors[i];
            if (calledClasses == null) continue;
            for (Map.Entry<String, TLongObjectHashMap> entry : calledClasses.entrySet()) {
                cname = entry.getKey();
                calledMethods = entry.getValue();
                calledKeys = calledMethods.keys();
                for (j = 0; j < calledKeys.length; ++j) {
                    calledHash = calledKeys[j];
                    bindings = this.getConCalledByConBindings(i, cname, calledHash);
                    this.bindConCalledByConInterceptorChain(bindings, i, cname, calledHash);
                }
            }
        }
    }

    private ArrayList<AdviceBinding> getConstructorCallerBindings(int callingIndex, String cname, long calledHash) {
        try {
            Constructor callingConstructor = this.constructors[callingIndex];
            if (callingConstructor == null) {
                throw new RuntimeException("Unable to figure out calling method of a caller pointcut");
            }
            Class<?> called = this.getClassLoader().loadClass(cname);
            Method calledMethod = MethodHashing.findMethodByHash(called, calledHash);
            if (calledMethod == null) {
                throw new RuntimeException("Unable to figure out calledmethod of a caller pointcut");
            }
            Collection<AdviceBinding> bindings = this.manager.getBindingCollection().getMethodCallBindings();
            ArrayList<AdviceBinding> result = new ArrayList<AdviceBinding>(bindings.size());
            for (AdviceBinding ab : bindings) {
                if (!ab.getPointcut().matchesCall((Advisor)this, (AccessibleObject)callingConstructor, called, calledMethod)) continue;
                result.add(ab);
            }
            return result;
        }
        catch (Exception e) {
            logger.error((Object)"Error happened with methodCallConBinding", (Throwable)e);
            return new ArrayList<AdviceBinding>();
        }
    }

    private ArrayList<AdviceBinding> getConCalledByConBindings(int callingIndex, String cname, long calledHash) {
        try {
            Constructor callingConstructor = this.constructors[callingIndex];
            if (callingConstructor == null) {
                throw new RuntimeException("Unable to figure out calling method of a caller pointcut");
            }
            Class<?> called = this.getClassLoader().loadClass(cname);
            Constructor<?> calledCon = MethodHashing.findConstructorByHash(called, calledHash);
            if (calledCon == null) {
                throw new RuntimeException("Unable to figure out calledcon of a caller pointcut");
            }
            Collection<AdviceBinding> bindings = this.manager.getBindingCollection().getConstructorCallBindings();
            ArrayList<AdviceBinding> result = new ArrayList<AdviceBinding>(bindings.size());
            for (AdviceBinding ab : bindings) {
                if (!ab.getPointcut().matchesCall((Advisor)this, (AccessibleObject)callingConstructor, called, calledCon)) continue;
                result.add(ab);
            }
            return result;
        }
        catch (Exception e) {
            logger.error((Object)"Error happened for conCalledConBindings", (Throwable)e);
            return new ArrayList<AdviceBinding>();
        }
    }

    protected void finalizeMethodCalledByMethodInterceptorChain(MethodByMethodInfo info) {
        this.adjustInfoForAddedBinding(info);
        ArrayList<Interceptor> list = info.getInterceptorChain();
        Interceptor[] interceptors = null;
        if (list.size() > 0) {
            interceptors = this.applyPrecedence(list.toArray(new Interceptor[list.size()]));
        }
        info.setInterceptors(interceptors);
    }

    protected void finalizeConCalledByMethodInterceptorChain(ConByMethodInfo info) {
        this.adjustInfoForAddedBinding(info);
        ArrayList<Interceptor> list = info.getInterceptorChain();
        Interceptor[] interceptors = null;
        if (list.size() > 0) {
            interceptors = this.applyPrecedence(list.toArray(new Interceptor[list.size()]));
        }
        info.setInterceptors(interceptors);
    }

    private void bindConCalledByConInterceptorChain(ArrayList<AdviceBinding> bindings, int callingIndex, String cname, long calledHash) {
        ConByConInfo info = this.getConCalledByCon(callingIndex, cname, calledHash);
        info.clear();
        for (AdviceBinding binding : bindings) {
            if (!BindingClassifier.isConstructorCall(binding)) continue;
            this.pointcutResolved(info, binding, new ConstructorCalledByConstructorJoinpoint(info.getCallingConstructor(), info.getConstructor()));
        }
        this.finalizeConCalledByConInterceptorChain(info);
    }

    protected void finalizeConCalledByConInterceptorChain(ConByConInfo info) {
        this.adjustInfoForAddedBinding(info);
        ArrayList<Interceptor> list = info.getInterceptorChain();
        Interceptor[] interceptors = null;
        if (list.size() > 0) {
            interceptors = this.applyPrecedence(list.toArray(new Interceptor[list.size()]));
        }
        info.setInterceptors(interceptors);
    }

    private void bindConstructorCallerInterceptorChain(ArrayList<AdviceBinding> bindings, int callingIndex, String cname, long calledHash) {
        MethodByConInfo info = this.getConstructorCallerMethodInfo(callingIndex, cname, calledHash);
        info.clear();
        for (AdviceBinding binding : bindings) {
            if (!BindingClassifier.isCall(binding)) continue;
            this.pointcutResolved(info, binding, new MethodCalledByConstructorJoinpoint(info.getCallingConstructor(), info.getMethod()));
        }
        this.finalizeMethodCalledByConInterceptorChain(info);
    }

    protected void finalizeMethodCalledByConInterceptorChain(MethodByConInfo info) {
        this.adjustInfoForAddedBinding(info);
        ArrayList<Interceptor> list = info.getInterceptorChain();
        Interceptor[] interceptors = null;
        if (list.size() > 0) {
            interceptors = this.applyPrecedence(list.toArray(new Interceptor[list.size()]));
        }
        info.setInterceptors(interceptors);
    }

    @Override
    protected void rebuildInterceptors() {
        if (this.initialized) {
            if (System.getSecurityManager() == null) {
                RebuildInterceptorsAction.NON_PRIVILEGED.rebuildInterceptors(this);
            } else {
                RebuildInterceptorsAction.PRIVILEGED.rebuildInterceptors(this);
            }
        }
    }

    protected void doRebuildInterceptors() {
        try {
            this.adviceBindings.clear();
            if (!this.initialized) {
                this.createInterceptorChains();
            } else {
                this.updateInterceptorChains();
            }
            this.rebuildCallerInterceptors();
        }
        catch (Exception ex) {
            if (ex instanceof RuntimeException) {
                throw (RuntimeException)ex;
            }
            throw new RuntimeException(ex);
        }
    }

    @Override
    protected void rebuildInterceptorsForAddedBinding(AdviceBinding binding) {
        if (this.initialized) {
            if (System.getSecurityManager() == null) {
                RebuildInterceptorsAction.NON_PRIVILEGED.rebuildInterceptorsForAddedBinding(this, binding);
            } else {
                RebuildInterceptorsAction.PRIVILEGED.rebuildInterceptorsForAddedBinding(this, binding);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doRebuildInterceptorsForAddedBinding(AdviceBinding binding) {
        try {
            if (!this.initialized) {
                throw new IllegalStateException("This should only be called when adding bindings to an exisiting advisor");
            }
            this.lockWriteChains();
            try {
                this.resetChainsKeepInterceptors();
                this.resolvePointcuts(binding);
                this.finalizeChains();
            }
            finally {
                this.unlockWriteChains();
            }
            this.rebuildCallerInterceptors();
            if (this.interceptorChainObserver != null) {
                this.interceptorChainObserver.interceptorChainsUpdated(this.fieldReadInfos, this.fieldWriteInfos, this.constructorInfos, this.methodInfos);
            }
        }
        catch (Exception ex) {
            if (ex instanceof RuntimeException) {
                throw (RuntimeException)ex;
            }
            throw new RuntimeException(ex);
        }
    }

    protected void bindClassMetaData(ClassMetaDataBinding data) {
        try {
            Constructor[] cons;
            ClassMetaDataLoader loader = data.getLoader();
            Object[] objs = this.advisedMethods.getValues();
            Method[] methods = new Method[objs.length];
            Field[] fields = this.advisedFields;
            if (fields == null) {
                fields = new Field[]{};
            }
            if ((cons = this.constructors) == null) {
                cons = new Constructor[]{};
            }
            for (int i = 0; i < objs.length; ++i) {
                methods[i] = (Method)objs[i];
            }
            loader.bind((Advisor)this, data, methods, fields, cons);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    protected void rebindClassMetaData() {
        this.defaultMetaData.clear();
        this.methodMetaData.clear();
        this.fieldMetaData.clear();
        this.constructorMetaData.clear();
        this.classMetaData.clear();
        for (int i = 0; i < this.classMetaDataBindings.size(); ++i) {
            ClassMetaDataBinding data = (ClassMetaDataBinding)this.classMetaDataBindings.get(i);
            this.bindClassMetaData(data);
        }
        this.deployAnnotationOverrides();
    }

    @Override
    public synchronized void addClassMetaData(ClassMetaDataBinding data) {
        this.initClassMetaDataBindingsList();
        this.classMetaDataBindings.add(data);
        if (this.clazz == null) {
            return;
        }
        this.bindClassMetaData(data);
        this.adviceBindings.clear();
        this.doesHaveAspects = false;
        this.rebuildInterceptors();
    }

    @Override
    public synchronized void removeClassMetaData(ClassMetaDataBinding data) {
        if (this.classMetaDataBindings.remove(data)) {
            if (this.clazz == null) {
                return;
            }
            this.rebindClassMetaData();
            this.adviceBindings.clear();
            this.doesHaveAspects = false;
            this.rebuildInterceptors();
        }
    }

    private void initializeEmptyConstructorCallerChain(int callingIndex, String calledClass, long calledMethodHash) throws Exception {
        ArrayList bindings;
        TLongObjectHashMap classMap;
        HashMap<String, Object> callingCon = this.methodCalledByConBindings[callingIndex];
        if (callingCon == null) {
            callingCon = new HashMap();
            this.methodCalledByConBindings[callingIndex] = callingCon;
        }
        if ((classMap = callingCon.get(calledClass)) == null) {
            classMap = new TLongObjectHashMap();
            callingCon.put(calledClass, classMap);
        }
        if ((bindings = (ArrayList)classMap.get(calledMethodHash)) == null) {
            bindings = new ArrayList();
            classMap.put(calledMethodHash, bindings);
        }
    }

    private void initializeConCalledByConEmptyChain(int callingIndex, String calledClass, long calledConHash) throws Exception {
        ArrayList bindings;
        TLongObjectHashMap classMap;
        HashMap<String, Object> callingCon = this.conCalledByConBindings[callingIndex];
        if (callingCon == null) {
            callingCon = new HashMap();
            this.conCalledByConBindings[callingIndex] = callingCon;
        }
        if ((classMap = callingCon.get(calledClass)) == null) {
            classMap = new TLongObjectHashMap();
            callingCon.put(calledClass, classMap);
        }
        if ((bindings = (ArrayList)classMap.get(calledConHash)) == null) {
            bindings = new ArrayList();
            classMap.put(calledConHash, bindings);
        }
    }

    public void addConstructorCallerPointcut(int callingIndex, String calledClass, long calledMethodHash, AdviceBinding binding) throws Exception {
        ArrayList<ArrayList<AdviceBinding>> backrefs;
        TLongObjectHashMap classMap;
        if (AspectManager.verbose) {
            logger.debug((Object)("constructor call matched binding " + binding.getPointcut().getExpr()));
        }
        this.adviceBindings.add(binding);
        binding.addAdvisor(this);
        HashMap<String, Object> callingCon = this.methodCalledByConBindings[callingIndex];
        if (callingCon == null) {
            callingCon = new HashMap();
            this.methodCalledByConBindings[callingIndex] = callingCon;
        }
        if ((classMap = callingCon.get(calledClass)) == null) {
            classMap = new TLongObjectHashMap();
            callingCon.put(calledClass, classMap);
        }
        ArrayList<AdviceBinding> bindings = (ArrayList<AdviceBinding>)classMap.get(calledMethodHash);
        boolean createdBindings = false;
        if (bindings == null) {
            bindings = new ArrayList<AdviceBinding>();
            classMap.put(calledMethodHash, bindings);
            createdBindings = true;
        }
        if (!bindings.contains(binding)) {
            bindings.add(binding);
        }
        if ((backrefs = this.backrefMethodCalledByConstructorBindings.get(binding.getName())) == null) {
            backrefs = new ArrayList();
            this.backrefMethodCalledByConstructorBindings.put(binding.getName(), backrefs);
            backrefs.add(bindings);
        } else if (createdBindings) {
            backrefs.add(bindings);
        }
    }

    private void addConstructorCalledByConPointcut(int callingIndex, String calledClass, long calledConHash, AdviceBinding binding) throws Exception {
        ArrayList<ArrayList<AdviceBinding>> backrefs;
        TLongObjectHashMap classMap;
        if (AspectManager.verbose) {
            logger.debug((Object)("constructor call matched binding " + binding.getPointcut().getExpr()));
        }
        this.adviceBindings.add(binding);
        binding.addAdvisor(this);
        HashMap<String, Object> callingCon = this.conCalledByConBindings[callingIndex];
        if (callingCon == null) {
            callingCon = new HashMap();
            this.conCalledByConBindings[callingIndex] = callingCon;
        }
        if ((classMap = callingCon.get(calledClass)) == null) {
            classMap = new TLongObjectHashMap();
            callingCon.put(calledClass, classMap);
        }
        ArrayList<AdviceBinding> bindings = (ArrayList<AdviceBinding>)classMap.get(calledConHash);
        boolean createdBindings = false;
        if (bindings == null) {
            bindings = new ArrayList<AdviceBinding>();
            classMap.put(calledConHash, bindings);
            createdBindings = true;
        }
        if (!bindings.contains(binding)) {
            bindings.add(binding);
        }
        if ((backrefs = this.backrefConCalledByConstructorBindings.get(binding.getName())) == null) {
            backrefs = new ArrayList();
            this.backrefConCalledByConstructorBindings.put(binding.getName(), backrefs);
            backrefs.add(bindings);
        } else if (createdBindings) {
            backrefs.add(bindings);
        }
    }

    private void removeCallerPointcut(AdviceBinding binding) {
        this.getMethodByMethodData().removeCallerPointcut(binding);
    }

    public static String notAdvisedMethodName(String className, String methodName) {
        return className.replace('.', '$') + "$" + methodName + NOT_TRANSFORMABLE_SUFFIX;
    }

    public static boolean isWithoutAdvisement(String name) {
        return name.endsWith(NOT_TRANSFORMABLE_SUFFIX);
    }

    public static boolean isAdvisable(Method method) {
        int modifiers = method.getModifiers();
        return !(ClassAdvisor.isWithoutAdvisement(method.getName()) || Modifier.isAbstract(modifiers) || Modifier.isNative(modifiers) || method.getName().equals("_getAdvisor") && method.getParameterTypes().length == 0 && method.getReturnType().equals(Advisor.class) || method.getName().equals("_getClassAdvisor") && method.getParameterTypes().length == 0 && method.getReturnType().equals(Advisor.class) || method.getName().equals("_getInstanceAdvisor") && method.getParameterTypes().length == 0 && method.getReturnType().equals(InstanceAdvisor.class) || method.getName().equals("_setInstanceAdvisor") && method.getParameterTypes().length == 1 && method.getParameterTypes()[0].equals(InstanceAdvisor.class) || !ReflectUtils.isNotAccessMethod(method));
    }

    private void populateFieldTable(ArrayList<Field> fields, Class<?> superclass) throws Exception {
        if (superclass == null) {
            return;
        }
        if (superclass.equals(Object.class)) {
            return;
        }
        this.populateFieldTable(fields, superclass.getSuperclass());
        ArrayList<Field> temp = new ArrayList<Field>();
        Field[] declaredFields = superclass.getDeclaredFields();
        for (int i = 0; i < declaredFields.length; ++i) {
            if (!Advisable.isAdvisable(declaredFields[i])) continue;
            declaredFields[i].setAccessible(true);
            temp.add(declaredFields[i]);
        }
        Collections.sort(temp, FieldComparator.INSTANCE);
        fields.addAll(temp);
    }

    protected void createFieldTable() throws Exception {
        ArrayList<Field> fields = new ArrayList<Field>();
        this.populateFieldTable(fields, this.clazz);
        this.advisedFields = fields.toArray(new Field[fields.size()]);
    }

    protected void addDeclaredMethods(Class<?> superclass) throws Exception {
        Method[] declaredMethods = superclass.getDeclaredMethods();
        for (int i = 0; i < declaredMethods.length; ++i) {
            if (!ClassAdvisor.isAdvisable(declaredMethods[i])) continue;
            long hash = MethodHashing.methodHash(declaredMethods[i]);
            this.advisedMethods.put(hash, (Object)declaredMethods[i]);
            try {
                Method m = declaredMethods[i];
                Method un = superclass.getDeclaredMethod(ClassAdvisor.notAdvisedMethodName(superclass.getName(), m.getName()), m.getParameterTypes());
                un.setAccessible(true);
                this.unadvisedMethods.put(hash, (Object)un);
                continue;
            }
            catch (NoSuchMethodException ignored) {
                // empty catch block
            }
        }
    }

    private void populateMethodTables(Class<?> superclass) throws Exception {
        if (superclass == null) {
            return;
        }
        if (superclass.equals(Object.class)) {
            return;
        }
        this.populateMethodTables(superclass.getSuperclass());
        Advisor superAdvisor = this.manager.getAnyAdvisorIfAdvised(superclass);
        if (superAdvisor != null && superAdvisor instanceof ClassAdvisor) {
            TLongObjectHashMap superHash = ((ClassAdvisor)superAdvisor).getUnadvisedMethods();
            long[] keys = superHash.keys();
            for (int i = 0; i < keys.length; ++i) {
                this.unadvisedMethods.put(keys[i], superHash.get(keys[i]));
            }
        }
        this.addDeclaredMethods(superclass);
    }

    protected void createMethodTables() throws Exception {
        this.initAdvisedMethodsMap();
        this.populateMethodTables(this.clazz.getSuperclass());
        this.addDeclaredMethods(this.clazz);
    }

    protected void createConstructorTables() throws Exception {
        int i;
        this.constructors = this.clazz.getDeclaredConstructors();
        if (this.clazz.isMemberClass()) {
            for (i = 0; i < this.constructors.length; ++i) {
                if (this.constructors[i].getParameterTypes().length != 1 || !this.constructors[i].getParameterTypes()[0].getName().equals(Inner.class.getName())) continue;
                Constructor[] newConstructors = new Constructor[this.constructors.length - 1];
                System.arraycopy(this.constructors, 0, newConstructors, 0, i);
                System.arraycopy(this.constructors, i + 1, newConstructors, i, this.constructors.length - i - 1);
                this.constructors = newConstructors;
                break;
            }
        }
        this.methodCalledByConBindings = new HashMap[this.constructors.length];
        this.methodCalledByConInterceptors = new HashMap[this.constructors.length];
        this.conCalledByConBindings = new HashMap[this.constructors.length];
        this.conCalledByConInterceptors = new HashMap[this.constructors.length];
        for (i = 0; i < this.constructors.length; ++i) {
            this.constructors[i].setAccessible(true);
        }
        Arrays.sort(this.constructors, ConstructorComparator.INSTANCE);
    }

    public MethodByMethodInfo resolveCallerMethodInfo(long callingMethodHash, String calledClass, long calledMethodHash) {
        return this.getMethodByMethodData().resolveCallerMethodInfo(callingMethodHash, calledClass, calledMethodHash);
    }

    public WeakReference<MethodByMethodInfo> resolveCallerMethodInfoAsWeakReference(long callingMethodHash, String calledClass, long calledMethodHash) {
        return new WeakReference<MethodByMethodInfo>(this.resolveCallerMethodInfo(callingMethodHash, calledClass, calledMethodHash));
    }

    public ConByMethodInfo resolveCallerConstructorInfo(long callingMethodHash, String calledClass, long calledConHash) {
        return this.getConByMethodData().resolveCallerConstructorInfo(callingMethodHash, calledClass, calledConHash);
    }

    public WeakReference<ConByMethodInfo> resolveCallerConstructorInfoAsWeakReference(long callingMethodHash, String calledClass, long calledConHash) {
        return new WeakReference<ConByMethodInfo>(this.resolveCallerConstructorInfo(callingMethodHash, calledClass, calledConHash));
    }

    @Deprecated
    public MethodByConInfo resolveConstructorCallerMethodInfo(int callingIndex, String calledClass, long calledMethodHash) {
        return this.resolveConstructorCallerMethodInfo(this.getClazz(), callingIndex, calledClass, calledMethodHash);
    }

    public MethodByConInfo resolveConstructorCallerMethodInfo(Class<?> callingClass, int callingIndex, String calledClass, long calledMethodHash) {
        if (System.getSecurityManager() == null) {
            return ResolveConstructorCallerMethodInfoAction.NON_PRIVILEGED.resolveInfo(this, callingClass, callingIndex, calledClass, calledMethodHash);
        }
        return ResolveConstructorCallerMethodInfoAction.PRIVILEGED.resolveInfo(this, callingClass, callingIndex, calledClass, calledMethodHash);
    }

    private MethodByConInfo doResolveConstructorCallerMethodInfo(Class<?> callingClass, int callingIndex, String calledClass, long calledMethodHash) {
        try {
            Constructor callingConstructor = this.constructors[callingIndex];
            if (callingConstructor == null) {
                throw new RuntimeException("Unable to figure out calling method of a caller pointcut");
            }
            Class<?> called = SecurityActions.getClassLoader(callingClass).loadClass(calledClass);
            Method calledMethod = MethodHashing.findMethodByHash(called, calledMethodHash);
            if (calledMethod == null) {
                throw new RuntimeException("Unable to figure out calledmethod of a caller pointcut");
            }
            boolean matched = false;
            ClassifiedBindingAndPointcutCollection bindingCol = this.manager.getBindingCollection();
            for (AdviceBinding binding : bindingCol.getConstructorCallBindings()) {
                if (!binding.getPointcut().matchesCall((Advisor)this, (AccessibleObject)callingConstructor, called, calledMethod)) continue;
                this.addConstructorCallerPointcut(callingIndex, calledClass, calledMethodHash, binding);
                matched = true;
            }
            if (!matched) {
                this.initializeEmptyConstructorCallerChain(callingIndex, calledClass, calledMethodHash);
            }
            MethodByConInfo info = this.initializeConstructorCallerInterceptorsMap(callingClass, callingIndex, calledClass, calledMethodHash, calledMethod);
            ArrayList<AdviceBinding> bindings = this.getConstructorCallerBindings(callingIndex, calledClass, calledMethodHash);
            this.bindConstructorCallerInterceptorChain(bindings, callingIndex, calledClass, calledMethodHash);
            return info;
        }
        catch (Exception x) {
            throw new RuntimeException(x);
        }
    }

    @Deprecated
    public WeakReference<MethodByConInfo> resolveConstructorCallerMethodInfoAsWeakReference(int callingIndex, String calledClass, long calledMethodHash) {
        return new WeakReference<MethodByConInfo>(this.resolveConstructorCallerMethodInfo(callingIndex, calledClass, calledMethodHash));
    }

    public WeakReference<MethodByConInfo> resolveConstructorCallerMethodInfoAsWeakReference(Class<?> callingClass, int callingIndex, String calledClass, long calledMethodHash) {
        return new WeakReference<MethodByConInfo>(this.resolveConstructorCallerMethodInfo(callingClass, callingIndex, calledClass, calledMethodHash));
    }

    public ConByConInfo resolveConstructorCallerConstructorInfo(int callingIndex, String calledClass, long calledConHash) {
        return this.resolveConstructorCallerConstructorInfo(this.getClazz(), callingIndex, calledClass, calledConHash);
    }

    public ConByConInfo resolveConstructorCallerConstructorInfo(Class<?> callingClass, int callingIndex, String calledClass, long calledConHash) {
        if (System.getSecurityManager() == null) {
            return ResolveConstructorCallerConstructorInfoAction.NON_PRIVILEGED.resolveInfo(this, callingClass, callingIndex, calledClass, calledConHash);
        }
        return ResolveConstructorCallerConstructorInfoAction.PRIVILEGED.resolveInfo(this, callingClass, callingIndex, calledClass, calledConHash);
    }

    private ConByConInfo doResolveConstructorCallerConstructorInfo(Class<?> callingClass, int callingIndex, String calledClass, long calledConHash) {
        try {
            Constructor callingConstructor = this.constructors[callingIndex];
            if (callingConstructor == null) {
                throw new RuntimeException("Unable to figure out calling method of a caller pointcut");
            }
            Class<?> called = SecurityActions.getClassLoader(callingClass).loadClass(calledClass);
            Constructor<?> calledCon = MethodHashing.findConstructorByHash(called, calledConHash);
            if (calledCon == null) {
                throw new RuntimeException("Unable to figure out calledcon of a caller pointcut");
            }
            boolean matched = false;
            ClassifiedBindingAndPointcutCollection bindingCol = this.manager.getBindingCollection();
            for (AdviceBinding binding : bindingCol.getConstructorCallBindings()) {
                if (!binding.getPointcut().matchesCall((Advisor)this, (AccessibleObject)callingConstructor, called, calledCon)) continue;
                this.addConstructorCalledByConPointcut(callingIndex, calledClass, calledConHash, binding);
                matched = true;
            }
            if (!matched) {
                this.initializeConCalledByConEmptyChain(callingIndex, calledClass, calledConHash);
            }
            ConByConInfo info = this.initializeConCalledByConInterceptorsMap(callingClass, callingIndex, calledClass, calledConHash, calledCon);
            ArrayList<AdviceBinding> bindings = this.getConCalledByConBindings(callingIndex, calledClass, calledConHash);
            this.bindConCalledByConInterceptorChain(bindings, callingIndex, calledClass, calledConHash);
            return info;
        }
        catch (Exception x) {
            throw new RuntimeException(x);
        }
    }

    @Deprecated
    public WeakReference<ConByConInfo> resolveConstructorCallerConstructorInfoAsWeakReference(int callingIndex, String calledClass, long calledConHash) {
        return new WeakReference<ConByConInfo>(this.resolveConstructorCallerConstructorInfo(callingIndex, calledClass, calledConHash));
    }

    public WeakReference<ConByConInfo> resolveConstructorCallerConstructorInfoAsWeakReference(Class<?> callingClass, int callingIndex, String calledClass, long calledConHash) {
        return new WeakReference<ConByConInfo>(this.resolveConstructorCallerConstructorInfo(callingClass, callingIndex, calledClass, calledConHash));
    }

    public Object invokeWithoutAdvisement(Object target, long methodHash, Object[] arguments) throws Throwable {
        try {
            Method method = (Method)this.unadvisedMethods.get(methodHash);
            return method.invoke(target, arguments);
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
    }

    public Object invokeNewWithoutAdvisement(Object[] arguments, Constructor<?> constructor) throws Throwable {
        try {
            return constructor.newInstance(arguments);
        }
        catch (InstantiationException in) {
            throw new RuntimeException("failed to call constructor", in);
        }
        catch (IllegalAccessException ill) {
            throw new RuntimeException("illegal access", ill);
        }
        catch (InvocationTargetException ite) {
            throw ite.getCause();
        }
    }

    public Object invokeMethod(long methodHash, Object[] arguments) throws Throwable {
        return this.invokeMethod(null, methodHash, arguments);
    }

    public Object invokeMethod(Object target, long methodHash, Object[] arguments) throws Throwable {
        InstanceAdvisor advisor = null;
        if (target != null) {
            InstanceAdvised advised = (InstanceAdvised)target;
            advisor = advised._getInstanceAdvisor();
        }
        MethodInfo info = this.methodInfos.getMethodInfo(methodHash);
        return this.invokeMethod(advisor, target, methodHash, arguments, info);
    }

    public Object invokeMethod(InstanceAdvisor instanceAdvisor, Object target, long methodHash, Object[] arguments) throws Throwable {
        MethodInfo info = this.methodInfos.getMethodInfo(methodHash);
        if (info == null && logger.isDebugEnabled()) {
            logger.debug((Object)("info is null for hash: " + methodHash + " of " + this.clazz.getName()));
        }
        return this.invokeMethod(instanceAdvisor, target, methodHash, arguments, info);
    }

    public Object invokeMethod(InstanceAdvisor instanceAdvisor, Object target, long methodHash, Object[] arguments, MethodInfo info) throws Throwable {
        Interceptor[] aspects = info.getInterceptors();
        if (instanceAdvisor != null && instanceAdvisor.hasInterceptors()) {
            aspects = instanceAdvisor.getInterceptors(aspects);
        }
        MethodInvocation invocation = new MethodInvocation(info, aspects);
        invocation.setArguments(arguments);
        invocation.setTargetObject(target);
        return invocation.invokeNext();
    }

    public Object invokeCaller(long callingMethodHash, Object target, Object[] args, CallerMethodInfo info, Object callingObject) throws Throwable {
        return this.invokeCaller((MethodByMethodInfo)info, callingObject, target, args);
    }

    public Object invokeCaller(MethodByMethodInfo info, Object callingObject, Object target, Object[] args) throws Throwable {
        MethodCalledByMethodInvocation invocation = new MethodCalledByMethodInvocation(info, callingObject, target, args, info.getInterceptors());
        invocation.setTargetObject(target);
        return invocation.invokeNext();
    }

    public Object invokeConCalledByMethod(long callingMethodHash, Object[] args, CallerConstructorInfo info, Object callingObject) throws Throwable {
        return this.invokeConCalledByMethod((ConByMethodInfo)info, callingObject, args);
    }

    public Object invokeConCalledByMethod(ConByMethodInfo info, Object callingObject, Object[] args) throws Throwable {
        ConstructorCalledByMethodInvocation invocation = new ConstructorCalledByMethodInvocation(info, callingObject, args, info.getInterceptors());
        return invocation.invokeNext();
    }

    public Object invokeConstructorCaller(int callingIndex, Object target, Object[] args, CallerMethodInfo info) throws Throwable {
        return this.invokeConstructorCaller((MethodByConInfo)info, null, target, args);
    }

    public Object invokeConstructorCaller(int callingIndex, Object callingObject, Object target, Object[] args, CallerMethodInfo info) throws Throwable {
        return this.invokeConstructorCaller((MethodByConInfo)info, callingObject, target, args);
    }

    public Object invokeConstructorCaller(MethodByConInfo info, Object target, Object[] args) throws Throwable {
        return this.invokeConstructorCaller(info, null, target, args);
    }

    public Object invokeConstructorCaller(MethodByConInfo info, Object callingObject, Object target, Object[] args) throws Throwable {
        MethodCalledByConstructorInvocation invocation = new MethodCalledByConstructorInvocation(info, callingObject, target, args, info.getInterceptors());
        invocation.setTargetObject(target);
        return invocation.invokeNext();
    }

    public Object invokeConCalledByCon(int callingIndex, Object[] args, CallerConstructorInfo info) throws Throwable {
        return this.invokeConCalledByCon((ConByConInfo)info, null, args);
    }

    public Object invokeConCalledByCon(int callingIndex, Object callingObject, Object[] args, CallerConstructorInfo info) throws Throwable {
        return this.invokeConCalledByCon((ConByConInfo)info, callingObject, args);
    }

    public Object invokeConCalledByCon(ConByConInfo info, Object[] args) throws Throwable {
        return this.invokeConCalledByCon(info, null, args);
    }

    public Object invokeConCalledByCon(ConByConInfo info, Object callingObject, Object[] args) throws Throwable {
        ConstructorCalledByConstructorInvocation invocation = new ConstructorCalledByConstructorInvocation(info, callingObject, args, info.getInterceptors());
        return invocation.invokeNext();
    }

    private MethodByConInfo getConstructorCallerMethodInfo(int callingIndex, String calledClass, long calledMethodHash) {
        HashMap<String, TLongObjectHashMap> calledClasses = this.methodCalledByConInterceptors[callingIndex];
        TLongObjectHashMap calledMethods = calledClasses.get(calledClass);
        MethodByConInfo info = (MethodByConInfo)calledMethods.get(calledMethodHash);
        return info;
    }

    private ConByConInfo getConCalledByCon(int callingIndex, String calledClass, long calledConHash) {
        HashMap<String, TLongObjectHashMap> calledClasses = this.conCalledByConInterceptors[callingIndex];
        TLongObjectHashMap calledMethods = calledClasses.get(calledClass);
        ConByConInfo info = (ConByConInfo)calledMethods.get(calledConHash);
        return info;
    }

    public Object invokeNew(Object[] args, int idx) throws Throwable {
        Interceptor[] cInterceptors = this.constructorInfos[idx].getInterceptors();
        if (cInterceptors == null) {
            cInterceptors = new Interceptor[]{};
        }
        ConstructorInvocation invocation = new ConstructorInvocation(cInterceptors);
        invocation.setAdvisor(this);
        invocation.setArguments(args);
        invocation.setConstructor(this.constructors[idx]);
        return invocation.invokeNext();
    }

    public Object invokeRead(Object target, int index) throws Throwable {
        InstanceAdvised advised;
        InstanceAdvisor advisor;
        Interceptor[] aspects = this.fieldReadInfos[index].getInterceptors();
        if (aspects == null) {
            aspects = new Interceptor[]{};
        }
        if (target != null && (advisor = (advised = (InstanceAdvised)target)._getInstanceAdvisor()) != null && advisor.hasInterceptors()) {
            aspects = advisor.getInterceptors(aspects);
        }
        FieldReadInvocation invocation = new FieldReadInvocation(this.advisedFields[index], index, aspects);
        invocation.setAdvisor(this);
        invocation.setTargetObject(target);
        return invocation.invokeNext();
    }

    public Object invokeWrite(Object target, int index, Object value) throws Throwable {
        InstanceAdvised advised;
        InstanceAdvisor advisor;
        Interceptor[] aspects = this.fieldWriteInfos[index].getInterceptors();
        if (aspects == null) {
            aspects = new Interceptor[]{};
        }
        if (target != null && (advisor = (advised = (InstanceAdvised)target)._getInstanceAdvisor()) != null && advisor.hasInterceptors()) {
            aspects = advised._getInstanceAdvisor().getInterceptors(aspects);
        }
        FieldWriteInvocation invocation = new FieldWriteInvocation(this.advisedFields[index], index, value, aspects);
        invocation.setAdvisor(this);
        invocation.setTargetObject(target);
        return invocation.invokeNext();
    }

    public Object invoke(Invocation invocation) throws Throwable {
        if (invocation instanceof FieldWriteInvocation) {
            FieldWriteInvocation fieldInvocation = (FieldWriteInvocation)invocation;
            Object target = fieldInvocation.getTargetObject();
            Object val = fieldInvocation.getValue();
            Field field = fieldInvocation.getField();
            field.set(target, val);
            return null;
        }
        if (invocation instanceof FieldReadInvocation) {
            FieldReadInvocation fieldInvocation = (FieldReadInvocation)invocation;
            Object target = fieldInvocation.getTargetObject();
            Field field = fieldInvocation.getField();
            return field.get(target);
        }
        if (invocation instanceof MethodInvocation) {
            MethodInvocation methodInvocation = (MethodInvocation)invocation;
            return this.invokeWithoutAdvisement(methodInvocation.getTargetObject(), methodInvocation.getMethodHash(), methodInvocation.getArguments());
        }
        if (invocation instanceof ConstructorInvocation) {
            ConstructorInvocation cInvocation = (ConstructorInvocation)invocation;
            Object[] arguments = cInvocation.getArguments();
            Constructor<?> constructor = cInvocation.getConstructor();
            return this.invokeNewWithoutAdvisement(arguments, constructor);
        }
        throw new IllegalStateException("Unknown Invocation type: " + invocation.getClass().getName());
    }

    @Override
    public void cleanup() {
        super.cleanup();
        if (this.methodByMethodData != null) {
            this.methodByMethodData.cleanup();
            this.methodByMethodData = null;
        }
        if (this.conByMethodData != null) {
            this.conByMethodData.cleanup();
            this.conByMethodData = null;
        }
    }

    protected InterceptorChainObserver getInterceptorChainObserver() {
        return this.interceptorChainObserver;
    }

    protected void setInterceptorChainObserver(InterceptorChainObserver observer) {
        if (observer != null) {
            observer.initialInterceptorChains(this.clazz, this.fieldReadInfos, this.fieldWriteInfos, this.constructorInfos, this.methodInfos);
        }
        this.interceptorChainObserver = observer;
    }

    @Override
    protected void populateInterceptorsFromInfos() {
        int i;
        if (!AspectManager.maintainAdvisorMethodInterceptors) {
            return;
        }
        super.populateInterceptorsFromInfos();
        this.fieldReadInterceptors = new Interceptor[this.fieldReadInfos.length][];
        for (i = 0; i < this.fieldReadInfos.length; ++i) {
            this.fieldReadInterceptors[i] = this.fieldReadInfos[i].getInterceptors();
        }
        this.fieldWriteInterceptors = new Interceptor[this.fieldWriteInfos.length][];
        for (i = 0; i < this.fieldWriteInfos.length; ++i) {
            this.fieldWriteInterceptors[i] = this.fieldWriteInfos[i].getInterceptors();
        }
        if (this.constructionInfos == null) {
            this.constructionInterceptors = new Interceptor[0][];
        } else {
            this.constructionInterceptors = new Interceptor[this.constructionInfos.length][];
            for (i = 0; i < this.constructionInfos.length; ++i) {
                this.constructionInterceptors[i] = this.constructionInfos[i].getInterceptors();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MethodByMethodData getMethodByMethodData() {
        if (this.methodByMethodData == null) {
            Object object = this.lazyCollectionLock;
            synchronized (object) {
                if (this.methodByMethodData == null) {
                    this.methodByMethodData = new MethodByMethodData();
                }
            }
        }
        return this.methodByMethodData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ConByMethodData getConByMethodData() {
        if (this.conByMethodData == null) {
            Object object = this.lazyCollectionLock;
            synchronized (object) {
                if (this.conByMethodData == null) {
                    this.conByMethodData = new ConByMethodData();
                }
            }
        }
        return this.conByMethodData;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ConByMethodData {
        private volatile TLongObjectHashMap conCalledByMethodBindings = UnmodifiableEmptyCollections.EMPTY_TLONG_OBJECT_HASHMAP;
        private volatile HashMap<String, ArrayList<ArrayList<AdviceBinding>>> backrefConCalledByMethodBindings = UnmodifiableEmptyCollections.EMPTY_HASHMAP;
        private volatile TLongObjectHashMap conCalledByMethodInterceptors = UnmodifiableEmptyCollections.EMPTY_TLONG_OBJECT_HASHMAP;

        private ConByMethodData() {
        }

        public TLongObjectHashMap getConCalledByMethodInterceptors() {
            return this.conCalledByMethodInterceptors;
        }

        public ArrayList<AdviceBinding> getConCalledByMethodBindings(long callingHash, String cname, long calledHash) {
            try {
                Method callingMethod = MethodHashing.findMethodByHash(ClassAdvisor.this.clazz, callingHash);
                if (callingMethod == null) {
                    throw new RuntimeException("Unable to figure out calling method of a constructor caller pointcut");
                }
                Class<?> called = ClassAdvisor.this.getClassLoader().loadClass(cname);
                Constructor<?> calledCon = MethodHashing.findConstructorByHash(called, calledHash);
                if (calledCon == null) {
                    throw new RuntimeException("Unable to figure out calledcon of a constructor caller pointcut");
                }
                Collection<AdviceBinding> bindings = ClassAdvisor.this.manager.getBindingCollection().getConstructorCallBindings();
                ArrayList<AdviceBinding> result = new ArrayList<AdviceBinding>(bindings.size());
                for (AdviceBinding ab : bindings) {
                    if (!ab.getPointcut().matchesCall((Advisor)ClassAdvisor.this, (AccessibleObject)callingMethod, called, calledCon)) continue;
                    result.add(ab);
                }
                return result;
            }
            catch (Exception e) {
                logger.error((Object)"Error happened conCalledMethod bindings", (Throwable)e);
                return new ArrayList<AdviceBinding>();
            }
        }

        public void rebuildCallerInterceptors() throws Exception {
            long[] callingKeys = this.conCalledByMethodInterceptors.keys();
            for (int i = 0; i < callingKeys.length; ++i) {
                long callingHash = callingKeys[i];
                HashMap calledClasses = (HashMap)this.conCalledByMethodInterceptors.get(callingHash);
                for (Map.Entry entry : calledClasses.entrySet()) {
                    String cname = (String)entry.getKey();
                    TLongObjectHashMap calledMethods = (TLongObjectHashMap)entry.getValue();
                    long[] calledKeys = calledMethods.keys();
                    for (int j = 0; j < calledKeys.length; ++j) {
                        long calledHash = calledKeys[j];
                        ArrayList<AdviceBinding> bindings = this.getConCalledByMethodBindings(callingHash, cname, calledHash);
                        this.bindConCalledByMethodInterceptorChain(bindings, callingHash, cname, calledHash);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ConByMethodInfo resolveCallerConstructorInfo(long callingMethodHash, String calledClass, long calledConHash) {
            if (this.conCalledByMethodBindings == UnmodifiableEmptyCollections.EMPTY_TLONG_OBJECT_HASHMAP || this.backrefConCalledByMethodBindings == UnmodifiableEmptyCollections.EMPTY_HASHMAP || this.conCalledByMethodInterceptors == UnmodifiableEmptyCollections.EMPTY_TLONG_OBJECT_HASHMAP) {
                Object object = ClassAdvisor.this.lazyCollectionLock;
                synchronized (object) {
                    if (this.conCalledByMethodBindings == UnmodifiableEmptyCollections.EMPTY_TLONG_OBJECT_HASHMAP) {
                        this.conCalledByMethodBindings = new TLongObjectHashMap();
                    }
                    if (this.backrefConCalledByMethodBindings == UnmodifiableEmptyCollections.EMPTY_HASHMAP) {
                        this.backrefConCalledByMethodBindings = new HashMap();
                    }
                    if (this.conCalledByMethodInterceptors == UnmodifiableEmptyCollections.EMPTY_TLONG_OBJECT_HASHMAP) {
                        this.conCalledByMethodInterceptors = new TLongObjectHashMap();
                    }
                }
            }
            if (System.getSecurityManager() == null) {
                return ResolveCallerConstuctorInfoAction.NON_PRIVILEGED.resolveInfo(this, callingMethodHash, calledClass, calledConHash);
            }
            return ResolveCallerConstuctorInfoAction.PRIVILEGED.resolveInfo(this, callingMethodHash, calledClass, calledConHash);
        }

        private ConByMethodInfo doResolveCallerConstructorInfo(long callingMethodHash, String calledClass, long calledConHash) {
            try {
                Method callingMethod = MethodHashing.findMethodByHash(ClassAdvisor.this.clazz, callingMethodHash);
                if (callingMethod == null) {
                    throw new RuntimeException("Unable to figure out calling method of a constructor caller pointcut");
                }
                Class<?> called = ClassAdvisor.this.getClassLoader().loadClass(calledClass);
                Constructor<?> calledCon = MethodHashing.findConstructorByHash(called, calledConHash);
                if (calledCon == null) {
                    throw new RuntimeException("Unable to figure out calledcon of a constructor caller pointcut");
                }
                boolean matched = false;
                ClassifiedBindingAndPointcutCollection bindingCol = ClassAdvisor.this.manager.getBindingCollection();
                for (AdviceBinding binding : bindingCol.getConstructorCallBindings()) {
                    if (!binding.getPointcut().matchesCall((Advisor)ClassAdvisor.this, (AccessibleObject)callingMethod, called, calledCon)) continue;
                    this.addConstructorCalledByMethodPointcut(callingMethodHash, calledClass, calledConHash, binding);
                    matched = true;
                }
                if (!matched) {
                    this.initializeConCalledByMethodEmptyChain(callingMethodHash, calledClass, calledConHash);
                }
                ConByMethodInfo info = this.initializeConCalledByMethodInterceptorsMap(callingMethod, callingMethodHash, calledClass, calledConHash, calledCon);
                ArrayList<AdviceBinding> bindings = this.getConCalledByMethodBindings(callingMethodHash, calledClass, calledConHash);
                this.bindConCalledByMethodInterceptorChain(bindings, callingMethodHash, calledClass, calledConHash);
                return info;
            }
            catch (Exception x) {
                throw new RuntimeException(x);
            }
        }

        private void addConstructorCalledByMethodPointcut(long callingMethodHash, String calledClass, long calledMethodHash, AdviceBinding binding) throws Exception {
            ArrayList<ArrayList<AdviceBinding>> backrefs;
            TLongObjectHashMap classMap;
            if (AspectManager.verbose) {
                logger.debug((Object)("method call matched binding " + binding.getPointcut().getExpr()));
            }
            ClassAdvisor.this.adviceBindings.add(binding);
            binding.addAdvisor(ClassAdvisor.this);
            HashMap<String, TLongObjectHashMap> callingMethod = (HashMap<String, TLongObjectHashMap>)this.conCalledByMethodBindings.get(callingMethodHash);
            if (callingMethod == null) {
                callingMethod = new HashMap<String, TLongObjectHashMap>();
                this.conCalledByMethodBindings.put(callingMethodHash, callingMethod);
            }
            if ((classMap = (TLongObjectHashMap)callingMethod.get(calledClass)) == null) {
                classMap = new TLongObjectHashMap();
                callingMethod.put(calledClass, classMap);
            }
            ArrayList<AdviceBinding> bindings = (ArrayList<AdviceBinding>)classMap.get(calledMethodHash);
            boolean createdBindings = false;
            if (bindings == null) {
                bindings = new ArrayList<AdviceBinding>();
                classMap.put(calledMethodHash, bindings);
                createdBindings = true;
            }
            if (!bindings.contains(binding)) {
                bindings.add(binding);
            }
            if ((backrefs = this.backrefConCalledByMethodBindings.get(binding.getName())) == null) {
                backrefs = new ArrayList();
                this.backrefConCalledByMethodBindings.put(binding.getName(), backrefs);
                backrefs.add(bindings);
            } else if (createdBindings) {
                backrefs.add(bindings);
            }
        }

        private ConByMethodInfo initializeConCalledByMethodInterceptorsMap(Method callingMethod, long callingMethodHash, String calledClass, long calledConHash, Constructor<?> calledCon) throws Exception {
            TLongObjectHashMap calledMethodsMap;
            HashMap<String, TLongObjectHashMap> calledClassesMap = (HashMap<String, TLongObjectHashMap>)this.conCalledByMethodInterceptors.get(callingMethodHash);
            if (calledClassesMap == null) {
                calledClassesMap = new HashMap<String, TLongObjectHashMap>();
                this.conCalledByMethodInterceptors.put(callingMethodHash, calledClassesMap);
            }
            if ((calledMethodsMap = (TLongObjectHashMap)calledClassesMap.get(calledClass)) == null) {
                calledMethodsMap = new TLongObjectHashMap();
                calledClassesMap.put(calledClass, calledMethodsMap);
            }
            ConByMethodInfo info = this.createConByMethodInfo(calledClass, callingMethod, callingMethodHash, calledCon, calledConHash);
            calledMethodsMap.put(calledConHash, (Object)info);
            return info;
        }

        private void initializeConCalledByMethodEmptyChain(long callingMethodHash, String calledClass, long calledConHash) throws Exception {
            ArrayList bindings;
            TLongObjectHashMap classMap;
            HashMap<String, TLongObjectHashMap> callingMethod = (HashMap<String, TLongObjectHashMap>)this.conCalledByMethodBindings.get(callingMethodHash);
            if (callingMethod == null) {
                callingMethod = new HashMap<String, TLongObjectHashMap>();
                this.conCalledByMethodBindings.put(callingMethodHash, callingMethod);
            }
            if ((classMap = (TLongObjectHashMap)callingMethod.get(calledClass)) == null) {
                classMap = new TLongObjectHashMap();
                callingMethod.put(calledClass, classMap);
            }
            if ((bindings = (ArrayList)classMap.get(calledConHash)) == null) {
                bindings = new ArrayList();
                classMap.put(calledConHash, bindings);
            }
        }

        private ConByMethodInfo getConCalledByMethod(long callingMethodHash, String calledClass, long calledConHash) {
            HashMap calledClasses = (HashMap)this.conCalledByMethodInterceptors.get(callingMethodHash);
            TLongObjectHashMap calledMethods = (TLongObjectHashMap)calledClasses.get(calledClass);
            ConByMethodInfo info = (ConByMethodInfo)calledMethods.get(calledConHash);
            return info;
        }

        private ConByMethodInfo createConByMethodInfo(String calledClass, Method callingMethod, long callingMethodHash, Constructor<?> calledCon, long calledConHash) throws Exception {
            calledCon.setAccessible(true);
            Class<?> calledClazz = ClassAdvisor.this.getClassLoader().loadClass(calledClass);
            try {
                int index = calledClass.lastIndexOf(46);
                String baseClassName = calledClass.substring(index + 1);
                Method wrapper = calledCon.getDeclaringClass().getDeclaredMethod(ConstructorExecutionTransformer.constructorFactory(baseClassName), calledCon.getParameterTypes());
                return new ConByMethodInfo(ClassAdvisor.this, calledClazz, callingMethod, callingMethodHash, calledCon, calledConHash, wrapper, null);
            }
            catch (NoSuchMethodException e) {
                return new ConByMethodInfo(ClassAdvisor.this, calledClazz, callingMethod, callingMethodHash, calledCon, calledConHash, null, null);
            }
        }

        private void bindConCalledByMethodInterceptorChain(ArrayList<AdviceBinding> bindings, long callingHash, String cname, long calledHash) throws Exception {
            ConByMethodInfo info = this.getConCalledByMethod(callingHash, cname, calledHash);
            info.clear();
            for (AdviceBinding binding : bindings) {
                if (!BindingClassifier.isConstructorCall(binding)) continue;
                ClassAdvisor.this.pointcutResolved(info, binding, new ConstructorCalledByMethodJoinpoint(info.getCallingMethod(), info.getConstructor()));
            }
            ClassAdvisor.this.finalizeConCalledByMethodInterceptorChain(info);
        }

        public void cleanup() {
            this.conCalledByMethodBindings.clear();
            this.conCalledByMethodInterceptors.clear();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MethodByMethodData {
        private volatile TLongObjectHashMap methodCalledByMethodBindings = UnmodifiableEmptyCollections.EMPTY_TLONG_OBJECT_HASHMAP;
        private volatile HashMap<String, ArrayList<ArrayList<AdviceBinding>>> backrefMethodCalledByMethodBindings = UnmodifiableEmptyCollections.EMPTY_HASHMAP;
        private volatile TLongObjectHashMap methodCalledByMethodInterceptors = UnmodifiableEmptyCollections.EMPTY_TLONG_OBJECT_HASHMAP;

        private MethodByMethodData() {
        }

        public TLongObjectHashMap getMethodCalledByMethodInterceptors() {
            return this.methodCalledByMethodInterceptors;
        }

        public TLongObjectHashMap getMethodCalledByMethodBindings() {
            return this.methodCalledByMethodBindings;
        }

        public void rebuildCallerInterceptors() throws Exception {
            long[] callingKeys = this.methodCalledByMethodInterceptors.keys();
            for (int i = 0; i < callingKeys.length; ++i) {
                long callingHash = callingKeys[i];
                HashMap calledClasses = (HashMap)this.methodCalledByMethodInterceptors.get(callingHash);
                for (Map.Entry entry : calledClasses.entrySet()) {
                    String cname = (String)entry.getKey();
                    TLongObjectHashMap calledMethods = (TLongObjectHashMap)entry.getValue();
                    long[] calledKeys = calledMethods.keys();
                    for (int j = 0; j < calledKeys.length; ++j) {
                        long calledHash = calledKeys[j];
                        ArrayList<AdviceBinding> bindings = this.getCallerBindings(callingHash, cname, calledHash);
                        Method calling = MethodHashing.findMethodByHash(ClassAdvisor.this.clazz, callingHash);
                        this.bindCallerInterceptorChain(bindings, callingHash, cname, calledHash, calling);
                    }
                }
            }
        }

        public void removeCallerPointcut(AdviceBinding binding) {
            ArrayList<ArrayList<AdviceBinding>> backrefs = this.backrefMethodCalledByMethodBindings.get(binding.getName());
            if (backrefs == null) {
                return;
            }
            for (int i = 0; i < backrefs.size(); ++i) {
                ArrayList<AdviceBinding> ref = backrefs.get(i);
                ref.remove(binding);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public MethodByMethodInfo resolveCallerMethodInfo(long callingMethodHash, String calledClass, long calledMethodHash) {
            if (this.methodCalledByMethodBindings == UnmodifiableEmptyCollections.EMPTY_TLONG_OBJECT_HASHMAP || this.backrefMethodCalledByMethodBindings == UnmodifiableEmptyCollections.EMPTY_HASHMAP || this.methodCalledByMethodInterceptors == UnmodifiableEmptyCollections.EMPTY_TLONG_OBJECT_HASHMAP) {
                Object object = ClassAdvisor.this.lazyCollectionLock;
                synchronized (object) {
                    if (this.methodCalledByMethodBindings == UnmodifiableEmptyCollections.EMPTY_TLONG_OBJECT_HASHMAP) {
                        this.methodCalledByMethodBindings = new TLongObjectHashMap();
                    }
                    if (this.backrefMethodCalledByMethodBindings == UnmodifiableEmptyCollections.EMPTY_HASHMAP) {
                        this.backrefMethodCalledByMethodBindings = new HashMap();
                    }
                    if (this.methodCalledByMethodInterceptors == UnmodifiableEmptyCollections.EMPTY_TLONG_OBJECT_HASHMAP) {
                        this.methodCalledByMethodInterceptors = new TLongObjectHashMap();
                    }
                }
            }
            if (System.getSecurityManager() == null) {
                return ResolveCallerMethodInfoAction.NON_PRIVILEGED.resolveInfo(this, callingMethodHash, calledClass, calledMethodHash);
            }
            return ResolveCallerMethodInfoAction.PRIVILEGED.resolveInfo(this, callingMethodHash, calledClass, calledMethodHash);
        }

        private MethodByMethodInfo doResolveCallerMethodInfo(long callingMethodHash, String calledClass, long calledMethodHash) {
            try {
                Method callingMethod = MethodHashing.findMethodByHash(ClassAdvisor.this.clazz, callingMethodHash);
                if (callingMethod == null) {
                    throw new RuntimeException("Unable to figure out calling method of a caller pointcut");
                }
                Class<?> called = ClassAdvisor.this.getClassLoader().loadClass(calledClass);
                Method calledMethod = MethodHashing.findMethodByHash(called, calledMethodHash);
                if (calledMethod == null) {
                    throw new RuntimeException("Unable to figure out calledmethod of a caller pointcut");
                }
                boolean matched = false;
                for (AdviceBinding binding : ClassAdvisor.this.manager.getBindingCollection().getMethodCallBindings()) {
                    if (!binding.getPointcut().matchesCall((Advisor)ClassAdvisor.this, (AccessibleObject)callingMethod, called, calledMethod)) continue;
                    this.addMethodCalledByMethodPointcut(callingMethodHash, calledClass, calledMethodHash, binding);
                    matched = true;
                }
                if (!matched) {
                    this.initializeEmptyCallerChain(callingMethodHash, calledClass, calledMethodHash);
                }
                MethodByMethodInfo info = this.initializeCallerInterceptorsMap(callingMethodHash, calledClass, calledMethodHash, callingMethod, calledMethod);
                ArrayList<AdviceBinding> bindings = this.getCallerBindings(callingMethodHash, calledClass, calledMethodHash);
                this.bindCallerInterceptorChain(bindings, callingMethodHash, calledClass, calledMethodHash, callingMethod);
                return info;
            }
            catch (Exception x) {
                throw new RuntimeException(x);
            }
        }

        private void addMethodCalledByMethodPointcut(long callingMethodHash, String calledClass, long calledMethodHash, AdviceBinding binding) throws Exception {
            ArrayList<ArrayList<AdviceBinding>> backrefs;
            TLongObjectHashMap classMap;
            if (AspectManager.verbose) {
                logger.debug((Object)("method call matched binding " + binding.getPointcut().getExpr()));
            }
            ClassAdvisor.this.adviceBindings.add(binding);
            binding.addAdvisor(ClassAdvisor.this);
            HashMap<String, TLongObjectHashMap> callingMethod = (HashMap<String, TLongObjectHashMap>)this.methodCalledByMethodBindings.get(callingMethodHash);
            if (callingMethod == null) {
                callingMethod = new HashMap<String, TLongObjectHashMap>();
                this.methodCalledByMethodBindings.put(callingMethodHash, callingMethod);
            }
            if ((classMap = (TLongObjectHashMap)callingMethod.get(calledClass)) == null) {
                classMap = new TLongObjectHashMap();
                callingMethod.put(calledClass, classMap);
            }
            ArrayList<AdviceBinding> bindings = (ArrayList<AdviceBinding>)classMap.get(calledMethodHash);
            boolean createdBindings = false;
            if (bindings == null) {
                bindings = new ArrayList<AdviceBinding>();
                classMap.put(calledMethodHash, bindings);
                createdBindings = true;
            }
            if (!bindings.contains(binding)) {
                bindings.add(binding);
            }
            if ((backrefs = this.backrefMethodCalledByMethodBindings.get(binding.getName())) == null) {
                backrefs = new ArrayList();
                this.backrefMethodCalledByMethodBindings.put(binding.getName(), backrefs);
                backrefs.add(bindings);
            } else if (createdBindings) {
                backrefs.add(bindings);
            }
        }

        private void initializeEmptyCallerChain(long callingMethodHash, String calledClass, long calledMethodHash) throws Exception {
            ArrayList bindings;
            TLongObjectHashMap classMap;
            HashMap<String, TLongObjectHashMap> callingMethod = (HashMap<String, TLongObjectHashMap>)this.methodCalledByMethodBindings.get(callingMethodHash);
            if (callingMethod == null) {
                callingMethod = new HashMap<String, TLongObjectHashMap>();
                this.methodCalledByMethodBindings.put(callingMethodHash, callingMethod);
            }
            if ((classMap = (TLongObjectHashMap)callingMethod.get(calledClass)) == null) {
                classMap = new TLongObjectHashMap();
                callingMethod.put(calledClass, classMap);
            }
            if ((bindings = (ArrayList)classMap.get(calledMethodHash)) == null) {
                bindings = new ArrayList();
                classMap.put(calledMethodHash, bindings);
            }
        }

        private MethodByMethodInfo initializeCallerInterceptorsMap(long callingMethodHash, String calledClass, long calledMethodHash, Method callingMethod, Method calledMethod) throws Exception {
            TLongObjectHashMap calledMethodsMap;
            HashMap<String, TLongObjectHashMap> calledClassesMap = (HashMap<String, TLongObjectHashMap>)this.methodCalledByMethodInterceptors.get(callingMethodHash);
            if (calledClassesMap == null) {
                calledClassesMap = new HashMap<String, TLongObjectHashMap>();
                this.methodCalledByMethodInterceptors.put(callingMethodHash, calledClassesMap);
            }
            if ((calledMethodsMap = (TLongObjectHashMap)calledClassesMap.get(calledClass)) == null) {
                calledMethodsMap = new TLongObjectHashMap();
                calledClassesMap.put(calledClass, calledMethodsMap);
            }
            calledMethod.setAccessible(true);
            Class<?> calledClazz = ClassAdvisor.this.getClassLoader().loadClass(calledClass);
            MethodByMethodInfo info = new MethodByMethodInfo(ClassAdvisor.this, calledClazz, calledMethod, callingMethod, callingMethodHash, calledMethodHash, null);
            calledMethodsMap.put(calledMethodHash, (Object)info);
            return info;
        }

        private ArrayList<AdviceBinding> getCallerBindings(long callingHash, String cname, long calledHash) {
            try {
                Method callingMethod = MethodHashing.findMethodByHash(ClassAdvisor.this.clazz, callingHash);
                if (callingMethod == null) {
                    throw new RuntimeException("Unable to figure out calling method of a caller pointcut");
                }
                Class<?> called = ClassAdvisor.this.getClassLoader().loadClass(cname);
                Method calledMethod = MethodHashing.findMethodByHash(called, calledHash);
                if (calledMethod == null) {
                    throw new RuntimeException("Unable to figure out calledmethod of a caller pointcut");
                }
                Collection<AdviceBinding> bindings = ClassAdvisor.this.manager.getBindingCollection().getMethodCallBindings();
                ArrayList<AdviceBinding> result = new ArrayList<AdviceBinding>(bindings.size());
                for (AdviceBinding ab : bindings) {
                    if (!ab.getPointcut().matchesCall((Advisor)ClassAdvisor.this, (AccessibleObject)callingMethod, called, calledMethod)) continue;
                    result.add(ab);
                }
                return result;
            }
            catch (Exception e) {
                logger.error((Object)"Error happened when getting callerBindings", (Throwable)e);
                return new ArrayList<AdviceBinding>();
            }
        }

        private void bindCallerInterceptorChain(ArrayList<AdviceBinding> bindings, long callingHash, String cname, long calledHash, Method calling) {
            MethodByMethodInfo info = this.getCallerMethodInfo(callingHash, cname, calledHash);
            info.clear();
            for (AdviceBinding binding : bindings) {
                if (!BindingClassifier.isCall(binding)) continue;
                ClassAdvisor.this.pointcutResolved(info, binding, new MethodCalledByMethodJoinpoint(info.getCallingMethod(), info.getMethod()));
            }
            ClassAdvisor.this.finalizeMethodCalledByMethodInterceptorChain(info);
        }

        private MethodByMethodInfo getCallerMethodInfo(long callingMethodHash, String calledClass, long calledMethodHash) {
            HashMap calledClasses = (HashMap)this.methodCalledByMethodInterceptors.get(callingMethodHash);
            TLongObjectHashMap calledMethods = (TLongObjectHashMap)calledClasses.get(calledClass);
            MethodByMethodInfo info = (MethodByMethodInfo)calledMethods.get(calledMethodHash);
            return info;
        }

        public void cleanup() {
            this.methodCalledByMethodBindings.clear();
            this.backrefMethodCalledByMethodBindings.clear();
            this.methodCalledByMethodInterceptors.clear();
        }
    }

    static interface RebuildInterceptorsAction {
        public static final RebuildInterceptorsAction PRIVILEGED = new RebuildInterceptorsAction(){

            public void rebuildInterceptors(final ClassAdvisor advisor) {
                try {
                    AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                        @Override
                        public Object run() {
                            advisor.doRebuildInterceptors();
                            return null;
                        }
                    });
                }
                catch (PrivilegedActionException e) {
                    Exception ex = e.getException();
                    if (ex instanceof RuntimeException) {
                        throw (RuntimeException)ex;
                    }
                    throw new RuntimeException(ex);
                }
            }

            public void rebuildInterceptorsForAddedBinding(final ClassAdvisor advisor, final AdviceBinding binding) {
                try {
                    AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                        @Override
                        public Object run() {
                            advisor.doRebuildInterceptorsForAddedBinding(binding);
                            return null;
                        }
                    });
                }
                catch (PrivilegedActionException e) {
                    Exception ex = e.getException();
                    if (ex instanceof RuntimeException) {
                        throw (RuntimeException)ex;
                    }
                    throw new RuntimeException(ex);
                }
            }

            public void rebuildInterceptorsForRemovedBinding(final ClassAdvisor advisor, final AdviceBinding binding) {
                try {
                    AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                        @Override
                        public Object run() {
                            advisor.doRebuildInterceptorsForRemovedBinding(binding);
                            return null;
                        }
                    });
                }
                catch (PrivilegedActionException e) {
                    Exception ex = e.getException();
                    if (ex instanceof RuntimeException) {
                        throw (RuntimeException)ex;
                    }
                    throw new RuntimeException(ex);
                }
            }
        };
        public static final RebuildInterceptorsAction NON_PRIVILEGED = new RebuildInterceptorsAction(){

            public void rebuildInterceptors(ClassAdvisor advisor) {
                advisor.doRebuildInterceptors();
            }

            public void rebuildInterceptorsForAddedBinding(ClassAdvisor advisor, AdviceBinding binding) {
                advisor.doRebuildInterceptorsForAddedBinding(binding);
            }

            public void rebuildInterceptorsForRemovedBinding(ClassAdvisor advisor, AdviceBinding binding) {
                advisor.doRebuildInterceptorsForRemovedBinding(binding);
            }
        };

        public void rebuildInterceptors(ClassAdvisor var1);

        public void rebuildInterceptorsForAddedBinding(ClassAdvisor var1, AdviceBinding var2);

        public void rebuildInterceptorsForRemovedBinding(ClassAdvisor var1, AdviceBinding var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface ResolveConstructorCallerConstructorInfoAction {
        public static final ResolveConstructorCallerConstructorInfoAction PRIVILEGED = new ResolveConstructorCallerConstructorInfoAction(){

            @Override
            public ConByConInfo resolveInfo(final ClassAdvisor advisor, final Class<?> callingClass, final int callingIndex, final String calledClass, final long calledConHash) {
                try {
                    return AccessController.doPrivileged(new PrivilegedExceptionAction<ConByConInfo>(){

                        @Override
                        public ConByConInfo run() throws Exception {
                            return advisor.doResolveConstructorCallerConstructorInfo(callingClass, callingIndex, calledClass, calledConHash);
                        }
                    });
                }
                catch (PrivilegedActionException e) {
                    Exception ex = e.getException();
                    if (ex instanceof RuntimeException) {
                        throw (RuntimeException)ex;
                    }
                    throw new RuntimeException(ex);
                }
            }
        };
        public static final ResolveConstructorCallerConstructorInfoAction NON_PRIVILEGED = new ResolveConstructorCallerConstructorInfoAction(){

            @Override
            public ConByConInfo resolveInfo(ClassAdvisor advisor, Class<?> callingClass, int callingIndex, String calledClass, long calledConHash) {
                return advisor.doResolveConstructorCallerConstructorInfo(callingClass, callingIndex, calledClass, calledConHash);
            }
        };

        public ConByConInfo resolveInfo(ClassAdvisor var1, Class<?> var2, int var3, String var4, long var5);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface ResolveConstructorCallerMethodInfoAction {
        public static final ResolveConstructorCallerMethodInfoAction PRIVILEGED = new ResolveConstructorCallerMethodInfoAction(){

            @Override
            public MethodByConInfo resolveInfo(final ClassAdvisor advisor, final Class<?> callingClass, final int callingIndex, final String calledClass, final long calledMethodHash) {
                try {
                    return AccessController.doPrivileged(new PrivilegedExceptionAction<MethodByConInfo>(){

                        @Override
                        public MethodByConInfo run() throws Exception {
                            return advisor.doResolveConstructorCallerMethodInfo(callingClass, callingIndex, calledClass, calledMethodHash);
                        }
                    });
                }
                catch (PrivilegedActionException e) {
                    Exception ex = e.getException();
                    if (ex instanceof RuntimeException) {
                        throw (RuntimeException)ex;
                    }
                    throw new RuntimeException(ex);
                }
            }
        };
        public static final ResolveConstructorCallerMethodInfoAction NON_PRIVILEGED = new ResolveConstructorCallerMethodInfoAction(){

            @Override
            public MethodByConInfo resolveInfo(ClassAdvisor advisor, Class<?> callingClass, int callingIndex, String calledClass, long calledMethodHash) {
                return advisor.doResolveConstructorCallerMethodInfo(callingClass, callingIndex, calledClass, calledMethodHash);
            }
        };

        public MethodByConInfo resolveInfo(ClassAdvisor var1, Class<?> var2, int var3, String var4, long var5);
    }

    static interface ResolveCallerMethodInfoAction {
        public static final ResolveCallerMethodInfoAction PRIVILEGED = new ResolveCallerMethodInfoAction(){

            public MethodByMethodInfo resolveInfo(final MethodByMethodData data, final long callingMethodHash, final String calledClass, final long calledMethodHash) {
                try {
                    return AccessController.doPrivileged(new PrivilegedExceptionAction<MethodByMethodInfo>(){

                        @Override
                        public MethodByMethodInfo run() throws Exception {
                            return data.doResolveCallerMethodInfo(callingMethodHash, calledClass, calledMethodHash);
                        }
                    });
                }
                catch (PrivilegedActionException e) {
                    Exception ex = e.getException();
                    if (ex instanceof RuntimeException) {
                        throw (RuntimeException)ex;
                    }
                    throw new RuntimeException(ex);
                }
            }
        };
        public static final ResolveCallerMethodInfoAction NON_PRIVILEGED = new ResolveCallerMethodInfoAction(){

            public MethodByMethodInfo resolveInfo(MethodByMethodData data, long callingMethodHash, String calledClass, long calledMethodHash) {
                return data.doResolveCallerMethodInfo(callingMethodHash, calledClass, calledMethodHash);
            }
        };

        public MethodByMethodInfo resolveInfo(MethodByMethodData var1, long var2, String var4, long var5);
    }

    static interface ResolveCallerConstuctorInfoAction {
        public static final ResolveCallerConstuctorInfoAction PRIVILEGED = new ResolveCallerConstuctorInfoAction(){

            public ConByMethodInfo resolveInfo(final ConByMethodData data, final long callingMethodHash, final String calledClass, final long calledConHash) {
                try {
                    return AccessController.doPrivileged(new PrivilegedExceptionAction<ConByMethodInfo>(){

                        @Override
                        public ConByMethodInfo run() throws Exception {
                            return data.doResolveCallerConstructorInfo(callingMethodHash, calledClass, calledConHash);
                        }
                    });
                }
                catch (PrivilegedActionException e) {
                    Exception ex = e.getException();
                    if (ex instanceof RuntimeException) {
                        throw (RuntimeException)ex;
                    }
                    throw new RuntimeException(ex);
                }
            }
        };
        public static final ResolveCallerConstuctorInfoAction NON_PRIVILEGED = new ResolveCallerConstuctorInfoAction(){

            public ConByMethodInfo resolveInfo(ConByMethodData data, long callingMethodHash, String calledClass, long calledConHash) {
                return data.doResolveCallerConstructorInfo(callingMethodHash, calledClass, calledConHash);
            }
        };

        public ConByMethodInfo resolveInfo(ConByMethodData var1, long var2, String var4, long var5);
    }
}

