/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xnio.channels;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLSession;
import org.jboss.xnio.Buffers;
import org.jboss.xnio.ChannelListener;
import org.jboss.xnio.IoUtils;
import org.jboss.xnio.Option;
import org.jboss.xnio.Options;
import org.jboss.xnio.Sequence;
import org.jboss.xnio.channels.Configurable;
import org.jboss.xnio.channels.SslTcpChannel;
import org.jboss.xnio.channels.TcpChannel;
import org.jboss.xnio.log.Logger;

final class WrappingSslTcpChannel
implements SslTcpChannel {
    private static final Logger log = Logger.getLogger("org.jboss.xnio.ssl");
    private final TcpChannel tcpChannel;
    private final SSLEngine sslEngine;
    private final Executor executor;
    private volatile ChannelListener<? super SslTcpChannel> readListener = null;
    private volatile ChannelListener<? super SslTcpChannel> writeListener = null;
    private volatile ChannelListener<? super SslTcpChannel> closeListener = null;
    private static final AtomicReferenceFieldUpdater<WrappingSslTcpChannel, ChannelListener> readListenerUpdater = AtomicReferenceFieldUpdater.newUpdater(WrappingSslTcpChannel.class, ChannelListener.class, "readListener");
    private static final AtomicReferenceFieldUpdater<WrappingSslTcpChannel, ChannelListener> writeListenerUpdater = AtomicReferenceFieldUpdater.newUpdater(WrappingSslTcpChannel.class, ChannelListener.class, "writeListener");
    private static final AtomicReferenceFieldUpdater<WrappingSslTcpChannel, ChannelListener> closeListenerUpdater = AtomicReferenceFieldUpdater.newUpdater(WrappingSslTcpChannel.class, ChannelListener.class, "closeListener");
    private final ChannelListener.Setter<SslTcpChannel> readSetter = IoUtils.getSetter(this, readListenerUpdater);
    private final ChannelListener.Setter<SslTcpChannel> writeSetter = IoUtils.getSetter(this, writeListenerUpdater);
    private final ChannelListener.Setter<SslTcpChannel> closeSetter = IoUtils.getSetter(this, closeListenerUpdater);
    private final ChannelListener<TcpChannel> tcpCloseListener = new ChannelListener<TcpChannel>(){

        @Override
        public void handleEvent(TcpChannel channel) {
            IoUtils.safeClose(WrappingSslTcpChannel.this);
            IoUtils.invokeChannelListener(WrappingSslTcpChannel.this, WrappingSslTcpChannel.this.closeListener);
        }
    };
    private final Runnable readTriggeredTask = new Runnable(){

        @Override
        public void run() {
            WrappingSslTcpChannel.this.runReadListener();
        }
    };
    private final ChannelListener<TcpChannel> tcpReadListener = new ReadListener();
    private final ChannelListener<TcpChannel> tcpWriteListener = new WriteListener();
    private final Lock mainLock = new ReentrantLock();
    private final Condition readAwaiters = this.mainLock.newCondition();
    private final Condition writeAwaiters = this.mainLock.newCondition();
    private boolean userReads;
    private boolean userWrites;
    private boolean needsWrap;
    private boolean needsUnwrap;
    private boolean newReadData;
    private ByteBuffer readBuffer = Buffers.EMPTY_BYTE_BUFFER;
    private ByteBuffer receiveBuffer = Buffers.EMPTY_BYTE_BUFFER;
    private ByteBuffer sendBuffer = Buffers.EMPTY_BYTE_BUFFER;
    private static final Set<Option<?>> OPTIONS = Option.setBuilder().add(Options.SSL_ENABLED_CIPHER_SUITES).add(Options.SSL_ENABLED_PROTOCOLS).add(Options.SSL_SUPPORTED_CIPHER_SUITES).add(Options.SSL_SUPPORTED_PROTOCOLS).create();

    private void runReadListener() {
        IoUtils.invokeChannelListener(this, this.readListener);
    }

    private void runWriteListener() {
        IoUtils.invokeChannelListener(this, this.writeListener);
    }

    WrappingSslTcpChannel(TcpChannel tcpChannel, SSLEngine sslEngine, Executor executor) {
        this.tcpChannel = tcpChannel;
        this.sslEngine = sslEngine;
        this.executor = executor;
        tcpChannel.getReadSetter().set(this.tcpReadListener);
        tcpChannel.getWriteSetter().set(this.tcpWriteListener);
        tcpChannel.getCloseSetter().set(this.tcpCloseListener);
    }

    @Override
    public InetSocketAddress getPeerAddress() {
        return (InetSocketAddress)this.tcpChannel.getPeerAddress();
    }

    @Override
    public InetSocketAddress getLocalAddress() {
        return (InetSocketAddress)this.tcpChannel.getLocalAddress();
    }

    @Override
    public void startHandshake() throws IOException {
        this.sslEngine.beginHandshake();
    }

    @Override
    public SSLSession getSslSession() {
        return this.sslEngine.getSession();
    }

    @Override
    public long transferTo(long position, long count, FileChannel target) throws IOException {
        return target.transferFrom(this, position, count);
    }

    @Override
    public ChannelListener.Setter<SslTcpChannel> getReadSetter() {
        return this.readSetter;
    }

    @Override
    public long transferFrom(FileChannel src, long position, long count) throws IOException {
        return src.transferTo(position, count, this);
    }

    @Override
    public ChannelListener.Setter<SslTcpChannel> getWriteSetter() {
        return this.writeSetter;
    }

    @Override
    public ChannelListener.Setter<SslTcpChannel> getCloseSetter() {
        return this.closeSetter;
    }

    @Override
    public boolean flush() throws IOException {
        Lock mainLock = this.mainLock;
        mainLock.lock();
        try {
            boolean bl = this.doFlush();
            return bl;
        }
        finally {
            mainLock.unlock();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean doFlush() throws IOException {
        SSLEngineResult wrapResult;
        TcpChannel tcpChannel = this.tcpChannel;
        block23: while (true) {
            ByteBuffer sendBuffer = this.sendBuffer;
            sendBuffer.flip();
            try {
                while (sendBuffer.hasRemaining()) {
                    log.trace("Flushing send buffer %s", (Object)sendBuffer);
                    if (tcpChannel.write(sendBuffer) != 0) continue;
                    log.trace("Send (in flush) would block, return false");
                    return false;
                }
                if (!tcpChannel.flush()) {
                    log.trace("Flushing TCP channel would block, return false");
                    return false;
                }
            }
            finally {
                sendBuffer.compact();
            }
            SSLEngine sslEngine = this.sslEngine;
            log.trace("Wrapping empty buffer into send buffer %s", (Object)sendBuffer);
            wrapResult = sslEngine.wrap(Buffers.EMPTY_BYTE_BUFFER, sendBuffer);
            log.trace("Wrap result is %s", (Object)wrapResult);
            int produced = wrapResult.bytesProduced();
            switch (wrapResult.getStatus()) {
                case CLOSED: {
                    return true;
                }
                case BUFFER_UNDERFLOW: 
                case OK: {
                    if (produced > 0) {
                        log.trace("Data produced, flush needed");
                        continue block23;
                    }
                    switch (wrapResult.getHandshakeStatus()) {
                        case NOT_HANDSHAKING: 
                        case FINISHED: {
                            log.trace("Fully flushed, return true");
                            return true;
                        }
                        case NEED_TASK: {
                            Runnable task = sslEngine.getDelegatedTask();
                            log.trace("Running delegated task %s", (Object)task);
                            task.run();
                            log.trace("Finished delegated task %s", (Object)task);
                            continue block23;
                        }
                        case NEED_UNWRAP: {
                            SSLEngineResult unwrapResult;
                            log.trace("Unwrap needed to proceed with flush");
                            block26: while (true) {
                                ByteBuffer receiveBuffer = this.receiveBuffer;
                                ByteBuffer readBuffer = this.readBuffer;
                                log.trace("Unwrapping from receive buffer %s to read buffer %s", (Object)receiveBuffer, (Object)readBuffer);
                                unwrapResult = sslEngine.unwrap(receiveBuffer, readBuffer);
                                this.readAwaiters.signalAll();
                                switch (unwrapResult.getStatus()) {
                                    case BUFFER_UNDERFLOW: {
                                        this.newReadData = false;
                                        if (receiveBuffer.position() == 0 && receiveBuffer.limit() == receiveBuffer.capacity()) {
                                            log.trace("Receive buffer is too small, growing from %s", (Object)receiveBuffer);
                                            int pktBufSize = sslEngine.getSession().getPacketBufferSize();
                                            if (receiveBuffer.capacity() >= pktBufSize) {
                                                throw new IOException("Unexpected/inexplicable buffer underflow from the SSL engine");
                                            }
                                            this.receiveBuffer = Buffers.flip(ByteBuffer.allocate(pktBufSize).put(receiveBuffer));
                                            log.trace("Grew receive buffer to %s", (Object)this.receiveBuffer);
                                            continue block26;
                                        }
                                        receiveBuffer.compact();
                                        try {
                                            log.trace("Reading data into receive buffer %s", (Object)receiveBuffer);
                                            int res = tcpChannel.read(receiveBuffer);
                                            if (res == -1) {
                                                log.trace("End of input stream reached");
                                                sslEngine.closeInbound();
                                                continue block23;
                                            }
                                            if (res == 0) {
                                                log.trace("Read would block, set needsUnwrap = true");
                                                this.needsUnwrap = true;
                                                return false;
                                            }
                                            this.newReadData = true;
                                            continue block26;
                                        }
                                        finally {
                                            receiveBuffer.flip();
                                            continue block23;
                                        }
                                    }
                                    case CLOSED: {
                                        log.trace("Engine is closed, everything must be flushed; return true");
                                        return true;
                                    }
                                    case OK: {
                                        log.trace("Unwrap complete, proceeding with wrap");
                                        continue block23;
                                    }
                                }
                                break;
                            }
                            throw new IOException("Unexpected unwrap result status " + (Object)((Object)unwrapResult.getStatus()));
                        }
                    }
                    throw new IOException("Unexpected wrap result handshake status " + (Object)((Object)wrapResult.getStatus()));
                }
            }
            break;
        }
        throw new IOException("Unexpected wrap result status " + (Object)((Object)wrapResult.getStatus()));
    }

    @Override
    public boolean isOpen() {
        return this.tcpChannel.isOpen();
    }

    @Override
    public void close() throws IOException {
        Lock mainLock = this.mainLock;
        mainLock.lock();
        try {
            this.sslEngine.closeOutbound();
            IOException e1 = null;
            IOException e2 = null;
            try {
                this.sslEngine.closeInbound();
            }
            catch (IOException e) {
                e1 = e;
            }
            try {
                this.tcpChannel.close();
            }
            catch (IOException e) {
                e2 = e;
            }
            if (e1 != null && e2 != null) {
                IOException t = new IOException("Multiple failures on close!  The second exception is: " + e2.toString());
                t.initCause(e1);
                throw t;
            }
            if (e1 != null) {
                throw e1;
            }
            if (e2 != null) {
                throw e2;
            }
        }
        finally {
            mainLock.unlock();
        }
    }

    @Override
    public boolean supportsOption(Option<?> option) {
        return OPTIONS.contains(option) || this.tcpChannel.supportsOption(option);
    }

    @Override
    public <T> T getOption(Option<T> option) throws IOException {
        if (option == Options.SSL_ENABLED_CIPHER_SUITES) {
            return option.cast(Sequence.of(this.sslEngine.getEnabledCipherSuites()));
        }
        if (option == Options.SSL_SUPPORTED_CIPHER_SUITES) {
            return option.cast(Sequence.of(this.sslEngine.getSupportedCipherSuites()));
        }
        if (option == Options.SSL_ENABLED_PROTOCOLS) {
            return option.cast(Sequence.of(this.sslEngine.getEnabledProtocols()));
        }
        if (option == Options.SSL_SUPPORTED_PROTOCOLS) {
            return option.cast(Sequence.of(this.sslEngine.getSupportedProtocols()));
        }
        return this.tcpChannel.getOption(option);
    }

    @Override
    public <T> Configurable setOption(Option<T> option, T value) throws IllegalArgumentException, IOException {
        if (option == Options.SSL_ENABLED_CIPHER_SUITES) {
            Sequence<String> strings = Options.SSL_ENABLED_CIPHER_SUITES.cast(value);
            this.sslEngine.setEnabledCipherSuites(strings.toArray((String[])new String[strings.size()]));
        } else if (option == Options.SSL_ENABLED_PROTOCOLS) {
            Sequence<String> strings = Options.SSL_ENABLED_PROTOCOLS.cast(value);
            this.sslEngine.setEnabledProtocols(strings.toArray((String[])new String[strings.size()]));
        } else {
            this.tcpChannel.setOption(option, value);
        }
        return this;
    }

    @Override
    public void suspendReads() {
        Lock mainLock = this.mainLock;
        mainLock.lock();
        try {
            this.userReads = false;
        }
        finally {
            mainLock.unlock();
        }
    }

    @Override
    public void suspendWrites() {
        Lock mainLock = this.mainLock;
        mainLock.lock();
        try {
            this.userWrites = false;
        }
        finally {
            mainLock.unlock();
        }
    }

    @Override
    public void resumeReads() {
        Lock mainLock = this.mainLock;
        mainLock.lock();
        try {
            if (this.readBuffer.position() > 0 || this.newReadData) {
                log.trace("Application resumeReads() -> Execute read handler");
                this.executor.execute(this.readTriggeredTask);
            } else {
                this.userReads = true;
                if (this.needsWrap) {
                    log.trace("Application resumeReads() -> SSL resumeWrites()");
                    this.tcpChannel.resumeWrites();
                } else {
                    log.trace("Application resumeReads() -> SSL resumeReads()");
                    this.tcpChannel.resumeReads();
                }
            }
        }
        finally {
            mainLock.unlock();
        }
    }

    @Override
    public void resumeWrites() {
        Lock mainLock = this.mainLock;
        mainLock.lock();
        try {
            this.userWrites = true;
            if (this.needsUnwrap) {
                log.trace("Application resumeWrites() -> SSL resumeReads()");
                this.tcpChannel.resumeReads();
            } else {
                log.trace("Application resumeWrites() -> SSL resumeWrites()");
                this.tcpChannel.resumeWrites();
            }
        }
        finally {
            mainLock.unlock();
        }
    }

    @Override
    public void shutdownReads() throws IOException {
        Lock mainLock = this.mainLock;
        mainLock.lock();
        try {
            log.trace("Shutting down writes");
            this.tcpChannel.shutdownReads();
            this.sslEngine.closeInbound();
        }
        finally {
            mainLock.unlock();
        }
    }

    @Override
    public boolean shutdownWrites() throws IOException {
        Lock mainLock = this.mainLock;
        mainLock.lock();
        try {
            if (this.flush()) {
                log.trace("Shutting down writes");
                this.sslEngine.closeOutbound();
                boolean bl = this.flush() && this.sslEngine.isOutboundDone() && this.tcpChannel.shutdownWrites();
                return bl;
            }
            return false;
        }
        finally {
            mainLock.unlock();
        }
    }

    @Override
    public void awaitReadable() throws IOException {
        block7: {
            Lock mainLock = this.mainLock;
            mainLock.lock();
            try {
                if (this.readBuffer.position() != 0) break block7;
                try {
                    if (this.needsWrap) {
                        log.trace("Application awaitReadable() -> SSL resumeWrites()");
                        this.tcpChannel.resumeWrites();
                    } else {
                        log.trace("Application awaitReadable() -> SSL resumeReads()");
                        this.tcpChannel.resumeReads();
                    }
                    this.readAwaiters.await();
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                    throw new InterruptedIOException();
                }
            }
            finally {
                mainLock.unlock();
            }
        }
    }

    @Override
    public void awaitReadable(long time, TimeUnit timeUnit) throws IOException {
        block7: {
            Lock mainLock = this.mainLock;
            mainLock.lock();
            try {
                if (this.readBuffer.position() != 0) break block7;
                try {
                    if (this.needsWrap) {
                        log.trace("Application awaitReadable() -> SSL resumeWrites()");
                        this.tcpChannel.resumeWrites();
                    } else {
                        log.trace("Application awaitReadable() -> SSL resumeReads()");
                        this.tcpChannel.resumeReads();
                    }
                    this.readAwaiters.await(time, timeUnit);
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                    throw new InterruptedIOException();
                }
            }
            finally {
                mainLock.unlock();
            }
        }
    }

    @Override
    public void awaitWritable() throws IOException {
        Lock mainLock = this.mainLock;
        mainLock.lock();
        try {
            try {
                if (this.needsUnwrap) {
                    log.trace("Application awaitWritable() -> SSL resumeReads()");
                    this.tcpChannel.resumeReads();
                } else {
                    log.trace("Application awaitWritable() -> SSL resumeWrites()");
                    this.tcpChannel.resumeWrites();
                }
                this.writeAwaiters.await();
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                throw new InterruptedIOException();
            }
        }
        finally {
            mainLock.unlock();
        }
    }

    @Override
    public void awaitWritable(long time, TimeUnit timeUnit) throws IOException {
        Lock mainLock = this.mainLock;
        mainLock.lock();
        try {
            try {
                if (this.needsUnwrap) {
                    log.trace("Application awaitWritable() -> SSL resumeReads()");
                    this.tcpChannel.resumeReads();
                } else {
                    log.trace("Application awaitWritable() -> SSL resumeWrites()");
                    this.tcpChannel.resumeWrites();
                }
                this.writeAwaiters.await(time, timeUnit);
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                throw new InterruptedIOException();
            }
        }
        finally {
            mainLock.unlock();
        }
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        return (int)this.write(new ByteBuffer[]{src}, 0, 1);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        if (length < 1) {
            return 0L;
        }
        SSLEngine sslEngine = this.sslEngine;
        Lock mainLock = this.mainLock;
        mainLock.lock();
        try {
            SSLEngineResult wrapResult;
            ByteBuffer sendBuffer = this.sendBuffer;
            block32: while (true) {
                log.trace("Wrapping %s (and possibly more) into send buffer %s", (Object)srcs[0], (Object)sendBuffer);
                wrapResult = sslEngine.wrap(srcs, offset, length, sendBuffer);
                log.trace("Wrap result is %s", (Object)wrapResult);
                int produced = wrapResult.bytesProduced();
                int consumed = wrapResult.bytesConsumed();
                TcpChannel tcpChannel = this.tcpChannel;
                switch (wrapResult.getStatus()) {
                    case BUFFER_OVERFLOW: {
                        if (sendBuffer.position() == 0) {
                            log.trace("Send buffer is too small, growing from %s", (Object)sendBuffer);
                            int oldCap = sendBuffer.capacity();
                            int reqCap = sslEngine.getSession().getPacketBufferSize();
                            if (reqCap <= oldCap) {
                                throw new IOException("SSLEngine required a bigger send buffer but our buffer was already big enough");
                            }
                            sendBuffer = this.sendBuffer = ByteBuffer.allocate(reqCap);
                            log.trace("Grew send buffer to %s", (Object)this.sendBuffer);
                            continue block32;
                        }
                        log.trace("No room in send buffer, flushing");
                        sendBuffer.flip();
                        try {
                            int res = tcpChannel.write(sendBuffer);
                            if (res == 0) {
                                long l = consumed;
                                return l;
                            }
                        }
                        finally {
                            sendBuffer.compact();
                        }
                    }
                    case BUFFER_UNDERFLOW: {
                        log.trace("Source buffer must be empty, finished");
                        long l = consumed;
                        return l;
                    }
                    case CLOSED: {
                        log.trace("Attempted to write after the channel is shut down");
                        throw new ClosedChannelException();
                    }
                    case OK: {
                        if (consumed != 0) {
                            long l = consumed;
                            return l;
                        }
                        if (produced > 0) continue block32;
                        switch (wrapResult.getHandshakeStatus()) {
                            case NEED_TASK: {
                                Runnable task = sslEngine.getDelegatedTask();
                                log.trace("Running delegated task %s", (Object)task);
                                task.run();
                                log.trace("Finished delegated task %s", (Object)task);
                                continue block32;
                            }
                            case NEED_UNWRAP: {
                                SSLEngineResult unwrapResult;
                                log.trace("Unwrap required before write can proceed");
                                block33: while (true) {
                                    ByteBuffer receiveBuffer = this.receiveBuffer;
                                    ByteBuffer readBuffer = this.readBuffer;
                                    log.trace("Unwrapping from receive buffer %s to read buffer %s", (Object)receiveBuffer, (Object)readBuffer);
                                    unwrapResult = sslEngine.unwrap(receiveBuffer, readBuffer);
                                    log.trace("Unwrap result is %s", (Object)unwrapResult);
                                    if (!receiveBuffer.hasRemaining()) {
                                        receiveBuffer.clear().flip();
                                    }
                                    this.readAwaiters.signalAll();
                                    switch (unwrapResult.getStatus()) {
                                        case BUFFER_UNDERFLOW: {
                                            this.newReadData = false;
                                            if (receiveBuffer.position() == 0 && receiveBuffer.limit() == receiveBuffer.capacity()) {
                                                log.trace("Receive buffer is not large enough to feed unwrap, growing from %s", (Object)receiveBuffer);
                                                int pktBufSize = sslEngine.getSession().getPacketBufferSize();
                                                if (receiveBuffer.capacity() >= pktBufSize) {
                                                    throw new IOException("Unexpected/inexplicable buffer underflow from the SSL engine");
                                                }
                                                this.receiveBuffer = Buffers.flip(ByteBuffer.allocate(pktBufSize).put(receiveBuffer));
                                                log.trace("Grew receive buffer to %s", (Object)this.receiveBuffer);
                                                continue block33;
                                            }
                                            receiveBuffer.compact();
                                            try {
                                                log.trace("Filling receive buffer (read)");
                                                int res = tcpChannel.read(receiveBuffer);
                                                if (res == -1) {
                                                    log.trace("End of inbound data");
                                                    sslEngine.closeInbound();
                                                    continue block32;
                                                }
                                                if (res == 0) {
                                                    log.trace("Read would block, setting needsUnwrap = true");
                                                    this.needsUnwrap = true;
                                                    long l = consumed;
                                                    return l;
                                                }
                                                log.trace("Read successful, retrying unwrap");
                                                this.newReadData = true;
                                                continue block33;
                                            }
                                            finally {
                                                receiveBuffer.flip();
                                                continue block32;
                                            }
                                        }
                                        case BUFFER_OVERFLOW: {
                                            int appBufSize = sslEngine.getSession().getApplicationBufferSize();
                                            if (readBuffer.capacity() >= appBufSize) {
                                                throw new IOException("Unexpected/inexplicable buffer overflow from the SSL engine");
                                            }
                                            log.trace("Read buffer is too small, growing from %s", (Object)readBuffer);
                                            this.readBuffer = ByteBuffer.allocate(appBufSize).put(Buffers.flip(readBuffer));
                                            log.trace("Grew read buffer to %s", (Object)this.readBuffer);
                                            continue block33;
                                        }
                                        case CLOSED: {
                                            log.trace("Read on closed channel, return");
                                            long l = consumed == 0 ? -1 : consumed;
                                            return l;
                                        }
                                        case OK: {
                                            log.trace("Unwrap succeeded, proceeding with wrap");
                                            continue block32;
                                        }
                                    }
                                    break;
                                }
                                throw new IOException("Unexpected unwrap result status " + (Object)((Object)unwrapResult.getStatus()));
                            }
                        }
                        throw new IOException("Unexpected handshake state " + (Object)((Object)wrapResult.getHandshakeStatus()) + " on wrap");
                    }
                }
                break;
            }
            throw new IOException("Unexpected wrap result status " + (Object)((Object)wrapResult.getStatus()));
        }
        finally {
            mainLock.unlock();
        }
    }

    @Override
    public long write(ByteBuffer[] srcs) throws IOException {
        return this.write(srcs, 0, srcs.length);
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        return (int)this.read(new ByteBuffer[]{dst}, 0, 1);
    }

    /*
     * Recovered potentially malformed switches.  Disable with '--allowmalformedswitch false'
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
        if (dsts.length == 0) return 0L;
        if (length == 0) {
            return 0L;
        }
        Lock mainLock = this.mainLock;
        mainLock.lock();
        ByteBuffer readBuffer = this.readBuffer;
        if (readBuffer.position() > 0) {
            log.trace("Returning data from read buffer %s", (Object)readBuffer);
            readBuffer.flip();
            try {
                long l = Buffers.put(dsts, offset, length, readBuffer);
                return l;
            }
            finally {
                readBuffer.compact();
            }
        }
        TcpChannel tcpChannel = this.tcpChannel;
        SSLEngine sslEngine = this.sslEngine;
        block38: while (true) {
            ByteBuffer receiveBuffer = this.receiveBuffer;
            log.trace("Unwrapping from %s to %s", (Object)receiveBuffer, (Object)readBuffer);
            SSLEngineResult unwrapResult = sslEngine.unwrap(receiveBuffer, readBuffer);
            log.trace("Unwrap result is %s", (Object)unwrapResult);
            int produced = unwrapResult.bytesProduced();
            switch (WrappingSslTcpChannel.$SWITCH_TABLE$javax$net$ssl$SSLEngineResult$Status()[unwrapResult.getStatus().ordinal()]) {
                case 2: {
                    if (readBuffer.position() > 0) {
                        this.readAwaiters.signalAll();
                        log.trace("Returning data from read buffer %s", (Object)readBuffer);
                        readBuffer.flip();
                        try {
                            long l = Buffers.put(dsts, offset, length, readBuffer);
                            return l;
                        }
                        finally {
                            readBuffer.compact();
                        }
                    }
                    log.trace("Growing application readBuffer from %s", (Object)readBuffer);
                    int appBufSize = sslEngine.getSession().getApplicationBufferSize();
                    if (readBuffer.capacity() >= appBufSize) {
                        throw new IOException("Unexpected/inexplicable buffer overflow from the SSL engine");
                    }
                    readBuffer = this.readBuffer = ByteBuffer.allocate(appBufSize);
                    log.trace("Grew application readBuffer to %s", (Object)this.readBuffer);
                    continue block38;
                }
                case 1: {
                    int rres;
                    this.newReadData = false;
                    if (receiveBuffer.position() == 0 && receiveBuffer.limit() == receiveBuffer.capacity()) {
                        log.trace("Growing receive buffer from %s", (Object)receiveBuffer);
                        int pktBufSize = sslEngine.getSession().getPacketBufferSize();
                        if (receiveBuffer.capacity() >= pktBufSize) {
                            throw new IOException("Unexpected/inexplicable buffer underflow from the SSL engine");
                        }
                        this.receiveBuffer = Buffers.flip(ByteBuffer.allocate(pktBufSize).put(receiveBuffer));
                        log.trace("Grew receive buffer to %s", (Object)this.receiveBuffer);
                        continue block38;
                    }
                    receiveBuffer.compact();
                    try {
                        log.trace("Reading into %s", (Object)receiveBuffer);
                        rres = tcpChannel.read(receiveBuffer);
                        log.trace("Read into %s", (Object)receiveBuffer);
                    }
                    finally {
                        receiveBuffer.flip();
                    }
                    if (rres == -1) {
                        log.trace("Hit EOF on TCP stream, closing SSL inbound");
                        sslEngine.closeInbound();
                    } else if (rres == 0) {
                        return 0L;
                    }
                    this.newReadData = true;
                    continue block38;
                }
                case 3: {
                    this.needsUnwrap = false;
                    if (produced > 0) {
                        this.readAwaiters.signalAll();
                        log.trace("Returning data from read buffer %s", (Object)readBuffer);
                        readBuffer.flip();
                        try {
                            long l = Buffers.put(dsts, offset, length, readBuffer);
                            return l;
                        }
                        finally {
                            readBuffer.compact();
                        }
                    }
                    switch (unwrapResult.getHandshakeStatus()) {
                        case NEED_TASK: {
                            Runnable task = sslEngine.getDelegatedTask();
                            log.trace("Running delegated task %s", (Object)task);
                            task.run();
                            log.trace("Delegated task %s complete", (Object)task);
                            continue block38;
                        }
                        case NEED_WRAP: {
                            SSLEngineResult wrapResult;
                            log.trace("Wrap required for read to proceed");
                            block39: while (true) {
                                ByteBuffer sendBuffer = this.sendBuffer;
                                log.trace("Wrapping empty buffer into %s", (Object)sendBuffer);
                                wrapResult = sslEngine.wrap(Buffers.EMPTY_BYTE_BUFFER, sendBuffer);
                                log.trace("Wrap result is %s", (Object)wrapResult);
                                this.writeAwaiters.signalAll();
                                switch (wrapResult.getStatus()) {
                                    case BUFFER_OVERFLOW: {
                                        int pktBufSize = sslEngine.getSession().getPacketBufferSize();
                                        if (sendBuffer.capacity() < pktBufSize) {
                                            log.trace("Send buffer is too small; resizing from %s", (Object)sendBuffer);
                                            this.sendBuffer = ByteBuffer.allocate(pktBufSize);
                                            log.trace("Send buffer resized to %s", (Object)this.sendBuffer.put(sendBuffer).flip());
                                            continue block39;
                                        }
                                        sendBuffer.flip();
                                        try {
                                            log.trace("Send buffer has insufficient space, flushing");
                                            int res = tcpChannel.write(sendBuffer);
                                            if (res != 0) continue block39;
                                            log.trace("Channel is not writable, set needsWrap = true");
                                            this.needsWrap = true;
                                            return 0L;
                                        }
                                        finally {
                                            sendBuffer.compact();
                                            continue block39;
                                        }
                                    }
                                    case OK: {
                                        log.trace("Wrap successful, continuing unwrap");
                                        this.needsWrap = false;
                                        continue block38;
                                    }
                                }
                                break;
                            }
                            throw new IOException("Unexpected status of " + (Object)((Object)wrapResult.getStatus()) + " while wrapping for an unwrap");
                        }
                    }
                    throw new IOException("Unexpected handshake status of " + (Object)((Object)unwrapResult.getHandshakeStatus()) + " while unwrapping");
                }
                default: {
                    throw new IllegalStateException();
                }
                finally {
                    mainLock.unlock();
                }
                case 4: 
            }
            break;
        }
        log.trace("Read from closed SSL inbound");
        this.needsUnwrap = false;
        return -1L;
    }

    @Override
    public long read(ByteBuffer[] dsts) throws IOException {
        return this.read(dsts, 0, dsts.length);
    }

    public String toString() {
        return String.format("SSL wrapped <%h> %s", this, this.tcpChannel);
    }

    private class ReadListener
    implements ChannelListener<TcpChannel> {
        private ReadListener() {
        }

        @Override
        public void handleEvent(TcpChannel channel) {
            boolean runRead = false;
            boolean runWrite = false;
            Lock mainLock = WrappingSslTcpChannel.this.mainLock;
            mainLock.lock();
            try {
                if (WrappingSslTcpChannel.this.needsUnwrap) {
                    WrappingSslTcpChannel.this.writeAwaiters.signalAll();
                }
                if (!WrappingSslTcpChannel.this.needsWrap) {
                    WrappingSslTcpChannel.this.readAwaiters.signalAll();
                    if (WrappingSslTcpChannel.this.userReads) {
                        WrappingSslTcpChannel.this.userReads = false;
                        runRead = true;
                    }
                }
                if (WrappingSslTcpChannel.this.userWrites && WrappingSslTcpChannel.this.needsUnwrap) {
                    WrappingSslTcpChannel.this.userWrites = false;
                    runWrite = true;
                }
            }
            finally {
                mainLock.unlock();
            }
            if (runRead) {
                WrappingSslTcpChannel.this.runReadListener();
            }
            if (runWrite) {
                WrappingSslTcpChannel.this.runWriteListener();
            }
        }
    }

    private class WriteListener
    implements ChannelListener<TcpChannel> {
        private WriteListener() {
        }

        @Override
        public void handleEvent(TcpChannel channel) {
            boolean runRead = false;
            boolean runWrite = false;
            Lock mainLock = WrappingSslTcpChannel.this.mainLock;
            mainLock.lock();
            try {
                if (WrappingSslTcpChannel.this.needsWrap) {
                    WrappingSslTcpChannel.this.readAwaiters.signalAll();
                }
                if (!WrappingSslTcpChannel.this.needsUnwrap) {
                    WrappingSslTcpChannel.this.writeAwaiters.signalAll();
                    if (WrappingSslTcpChannel.this.userWrites) {
                        WrappingSslTcpChannel.this.userWrites = false;
                        runWrite = true;
                    }
                }
                if (WrappingSslTcpChannel.this.userReads && WrappingSslTcpChannel.this.needsWrap) {
                    WrappingSslTcpChannel.this.userReads = false;
                    runRead = true;
                }
            }
            finally {
                mainLock.unlock();
            }
            if (runRead) {
                WrappingSslTcpChannel.this.runReadListener();
            }
            if (runWrite) {
                WrappingSslTcpChannel.this.runWriteListener();
            }
        }
    }
}

