/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.reflect.plugins.bytecode;

import java.lang.annotation.Annotation;
import java.lang.reflect.Modifier;
import javassist.bytecode.BadBytecode;
import javassist.bytecode.SignatureAttribute;
import org.jboss.reflect.plugins.AnnotationHelper;
import org.jboss.reflect.plugins.bytecode.BytecodeAnnotatedInfo;
import org.jboss.reflect.plugins.bytecode.BytecodeParameterInfo;
import org.jboss.reflect.plugins.bytecode.BytecodeTypeInfo;
import org.jboss.reflect.plugins.bytecode.BytecodeTypeInfoFactoryImpl;
import org.jboss.reflect.plugins.bytecode.BytecodeTypeVariableSpy;
import org.jboss.reflect.plugins.bytecode.SignatureKey;
import org.jboss.reflect.plugins.bytecode.bytes.BehaviourBytes;
import org.jboss.reflect.spi.AnnotationInfo;
import org.jboss.reflect.spi.AnnotationValue;
import org.jboss.reflect.spi.ClassInfo;
import org.jboss.reflect.spi.ParameterInfo;
import org.jboss.reflect.spi.TypeInfo;

public abstract class BytecodeBehaviourInfo
extends BytecodeAnnotatedInfo {
    private static final long serialVersionUID = -494071110672611729L;
    protected volatile transient ParameterInfo[] parameters;
    protected volatile transient TypeInfo[] parameterTypes;
    protected volatile transient ClassInfo[] exceptionTypes;
    protected final BytecodeTypeInfo typeInfo;
    protected final BehaviourBytes behaviour;
    private volatile transient boolean initializedMethodSignature;
    private volatile transient SignatureAttribute.MethodSignature methodSignature;

    public BytecodeBehaviourInfo(AnnotationHelper annotationHelper, BytecodeTypeInfo typeInfo, BehaviourBytes behaviour) {
        super(annotationHelper);
        this.typeInfo = typeInfo;
        this.behaviour = behaviour;
    }

    public int getModifiers() {
        return this.behaviour.getModifiers();
    }

    public boolean isPublic() {
        return Modifier.isPublic(this.getModifiers());
    }

    public boolean isStatic() {
        return Modifier.isStatic(this.getModifiers());
    }

    public boolean isVolatile() {
        return Modifier.isVolatile(this.getModifiers());
    }

    public BytecodeTypeInfo getDeclaringClass() {
        return this.typeInfo;
    }

    public ClassInfo[] getExceptionTypes() {
        if (this.exceptionTypes == null) {
            String[] types = this.behaviour.getExceptionTypeTypeInfoNames();
            ClassInfo[] exceptionTypes = new ClassInfo[types.length];
            for (int i = 0; i < types.length; ++i) {
                try {
                    exceptionTypes[i] = (ClassInfo)this.typeInfo.getFactory().getTypeInfo(types[i], this.getDeclaringClass().getClassLoaderInternal());
                    continue;
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException(e);
                }
            }
            this.exceptionTypes = exceptionTypes;
        }
        return this.exceptionTypes;
    }

    protected void generateParameters() {
        if (this.parameters != null) {
            return;
        }
        SignatureKey key = this.getSignatureKey();
        SignatureAttribute.MethodSignature sig = this.getMethodSignature();
        if (sig != null && sig.getParameterTypes().length == key.getParams().length) {
            SignatureAttribute.Type[] types = sig.getParameterTypes();
            TypeInfo[] parameterTypes = new TypeInfo[types.length];
            for (int i = 0; i < types.length; ++i) {
                parameterTypes[i] = this.typeInfo.getFactory().getTypeInfo(this.typeInfo.getClassLoaderInternal(), types[i], BytecodeTypeVariableSpy.createForBehavior(this.typeInfo.getClassSignature(), sig));
            }
            this.parameterTypes = parameterTypes;
        } else {
            TypeInfo[] parameterTypes = new TypeInfo[key.getParams().length];
            for (int i = 0; i < parameterTypes.length; ++i) {
                try {
                    parameterTypes[i] = this.typeInfo.getFactory().getTypeInfo(key.getParams()[i], this.typeInfo.getClassLoaderInternal());
                    continue;
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException(e);
                }
            }
            this.parameterTypes = parameterTypes;
        }
        ParameterInfo[] parameters = new ParameterInfo[this.parameterTypes.length];
        for (int i = 0; i < this.parameterTypes.length; ++i) {
            parameters[i] = new BytecodeParameterInfo(this.annotationHelper, this, i, this.parameterTypes[i]);
        }
        this.parameters = parameters;
    }

    public ParameterInfo[] getParameters() {
        if (this.parameters == null) {
            this.generateParameters();
        }
        return this.parameters;
    }

    public TypeInfo[] getParameterTypes() {
        if (this.parameterTypes == null) {
            this.generateParameters();
        }
        return this.parameterTypes;
    }

    public AnnotationValue[] getAnnotations() {
        return this.getAnnotations(this.behaviour);
    }

    public abstract String getName();

    protected void setupParameterAnnotations(Object[][] annotations) {
        if (annotations == null) {
            return;
        }
        for (int param = 0; param < annotations.length; ++param) {
            AnnotationValue[] annotationValues = new AnnotationValue[annotations[param].length];
            for (int ann = 0; ann < annotationValues.length; ++ann) {
                Class<? extends Annotation> clazz = ((Annotation)annotations[param][ann]).annotationType();
                AnnotationInfo info = (AnnotationInfo)((BytecodeTypeInfoFactoryImpl)this.annotationHelper).getTypeInfo(clazz);
                annotationValues[ann] = this.annotationHelper.createAnnotationValue(info, annotations[param][ann]);
            }
            ((BytecodeParameterInfo)this.parameters[param]).setAnnotations(annotationValues);
        }
    }

    protected void createParameterAnnotations() {
        Object[][] parameterAnnotations = this.behaviour.getParameterAnnotations();
        this.setupParameterAnnotations(parameterAnnotations);
    }

    protected SignatureAttribute.MethodSignature getMethodSignature() {
        if (!this.initializedMethodSignature) {
            try {
                String sig = this.behaviour.getGenericSignature();
                if (sig != null) {
                    this.methodSignature = SignatureAttribute.toMethodSignature((String)sig);
                }
            }
            catch (BadBytecode e) {
                throw new RuntimeException(e);
            }
            this.initializedMethodSignature = true;
        }
        return this.methodSignature;
    }

    public SignatureKey getSignatureKey() {
        return this.behaviour.getSignatureKey();
    }

    public String getDescriptor() {
        return this.behaviour.getJvmSignature();
    }
}

