/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.reflect.plugins.bytecode;

import java.util.Arrays;
import org.jboss.reflect.plugins.AnnotationHelper;
import org.jboss.reflect.plugins.bytecode.BytecodeAccessController;
import org.jboss.reflect.plugins.bytecode.BytecodeBehaviourInfo;
import org.jboss.reflect.plugins.bytecode.BytecodeTypeInfo;
import org.jboss.reflect.plugins.bytecode.accessor.ConstructorAccessor;
import org.jboss.reflect.plugins.bytecode.accessor.MemberAccessorFactory;
import org.jboss.reflect.plugins.bytecode.bytes.ConstructorBytes;
import org.jboss.reflect.spi.ConstructorInfo;
import org.jboss.util.JBossStringBuilder;

public class BytecodeConstructorInfo
extends BytecodeBehaviourInfo
implements ConstructorInfo {
    private static final long serialVersionUID = -2255405601790592604L;
    private volatile transient ConstructorAccessor constructor;

    public BytecodeConstructorInfo(AnnotationHelper annotationHelper, BytecodeTypeInfo typeInfo, ConstructorBytes constructor) {
        super(annotationHelper, typeInfo, constructor);
    }

    public Object newInstance(Object[] args) throws Throwable {
        if (this.constructor == null) {
            ConstructorAccessor ctor = MemberAccessorFactory.INSTANCE.createConstructor(this);
            if (this.constructor == null) {
                this.constructor = ctor;
            }
        }
        BytecodeAccessController.checkAccess(this);
        return this.constructor.newInstance(args);
    }

    protected int getHashCode() {
        int result = this.getDeclaringClass().hashCode();
        if (this.parameters == null) {
            this.generateParameters();
        }
        if (this.parameterTypes != null) {
            for (int i = 0; i < this.parameterTypes.length; ++i) {
                result = 29 * result + this.parameterTypes[i].hashCode();
            }
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof ConstructorInfo)) {
            return false;
        }
        ConstructorInfo other = (ConstructorInfo)obj;
        if (!((BytecodeTypeInfo)this.getDeclaringClass()).equals(other.getDeclaringClass())) {
            return false;
        }
        if (other instanceof BytecodeConstructorInfo) {
            return this.getSignatureKey().equals(((BytecodeConstructorInfo)other).getSignatureKey());
        }
        return Arrays.equals(this.getParameterTypes(), other.getParameterTypes());
    }

    protected void toString(JBossStringBuilder buffer) {
        buffer.append(Arrays.asList(this.getParameterTypes()));
        super.toString(buffer);
    }

    public String getName() {
        return "<init>";
    }
}

