/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.on.embedded.ui.configuration.resource;

import java.io.Serializable;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javax.faces.application.FacesMessage;
import org.jboss.on.embedded.bean.ResourceListItem;
import org.jboss.on.embedded.manager.ResourceManager;
import org.jboss.on.embedded.manager.ResourceManagerFactory;
import org.jboss.on.embedded.ui.CommonActionUtil;
import org.jboss.on.embedded.ui.configuration.resource.AbstractResourceConfigurationUIBean;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Begin;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Out;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.core.Conversation;
import org.jboss.seam.faces.FacesMessages;
import org.jetbrains.annotations.NotNull;
import org.rhq.core.clientapi.agent.inventory.CreateResourceResponse;
import org.rhq.core.clientapi.server.configuration.ConfigurationUpdateResponse;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.configuration.definition.ConfigurationDefinition;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.gui.configuration.ConfigHelperUIBean;
import org.rhq.core.gui.util.IdChunkGeneratorUIBean;

@Name(value="resourceConfigurationUIBean")
@Scope(value=ScopeType.CONVERSATION)
public class ResourceConfigurationUIBean
extends AbstractResourceConfigurationUIBean
implements Serializable {
    public static final String MANAGED_BEAN_NAME = "resourceConfigurationUIBean";
    @In(create=true)
    CommonActionUtil commonActionUtil;
    @In(required=false)
    private transient FacesMessages facesMessages;
    @In(value="IdChunkGeneratorUIBean", create=true)
    private IdChunkGeneratorUIBean idChunkGenerator;
    @In(value="ConfigHelperUIBean", create=true)
    private ConfigHelperUIBean configHelperUIBean;
    @In(value="ancestorResource", required=false)
    private Resource ancestorResource;
    @Out(required=false)
    private ResourceListItem currentResource;
    private ResourceType serviceType;
    private ResourceBundle messages = ResourceBundle.getBundle("messages");
    private ResourceManager configurationManager = ResourceManagerFactory.resourceManager();
    private ActionType actionType;

    @In(value="serviceType", required=false)
    public void setServiceType(ResourceType serviceType) {
        if (serviceType != null) {
            this.serviceType = serviceType;
            this.setConfigurationDefinition(this.serviceType.getResourceConfigurationDefinition());
            this.actionType = ActionType.CREATE;
        }
    }

    @In(value="templateConfiguration", required=false)
    public void setTemplateConfiguration(Configuration template) {
        if (template != null) {
            this.setConfiguration(template);
        }
    }

    public ActionType getActionType() {
        return this.actionType;
    }

    @Begin
    public void resourceConfiguration() {
        this.actionType = ActionType.UPDATE;
        this.currentResource = this.commonActionUtil.getCurrentResourceListItem();
        Resource resource = this.currentResource.getResource();
        try {
            this.setConfiguration(this.configurationManager.getResourceConfiguration(resource));
        }
        catch (Exception e) {
            this.setConfiguration(null);
        }
        this.setConfigurationDefinition(resource.getResourceType().getResourceConfigurationDefinition());
    }

    public String saveConfiguration() {
        String result = "failure";
        switch (this.actionType) {
            case CREATE: {
                result = this.createConfiguration();
                break;
            }
            case UPDATE: {
                result = this.updateConfiguration();
            }
        }
        if (result.equals("success")) {
            Conversation.instance().end(false);
        }
        return result;
    }

    private String updateConfiguration() {
        String result;
        Configuration resourceConfig = this.getConfiguration();
        ConfigurationUpdateResponse pluginResponse = this.configurationManager.updateResource(this.currentResource.getResource(), resourceConfig);
        switch (pluginResponse.getStatus()) {
            case SUCCESS: {
                this.facesMessages.addFromResourceBundle(FacesMessage.SEVERITY_INFO, "resource.status.update.success", new Object[]{this.currentResource.getResource().getResourceType().getName(), this.currentResource.getResource().getName()});
                result = "success";
                break;
            }
            default: {
                String baseMessage = this.messages.getString("resource.status.update.failure");
                this.addActionFailureMessageToFacesMessages(baseMessage, pluginResponse.getErrorMessage(), pluginResponse.getConfiguration());
                result = "failure";
            }
        }
        return result;
    }

    private String createConfiguration() {
        String result;
        ConfigurationDefinition configDef;
        Configuration resourceConfig = this.getConfiguration();
        Configuration pluginConfig = null;
        if (this.serviceType != null && (configDef = this.serviceType.getPluginConfigurationDefinition()) != null) {
            pluginConfig = configDef.getDefaultTemplate().getConfiguration();
        }
        CreateResourceResponse pluginResponse = this.configurationManager.createResource("newResource", this.serviceType, this.ancestorResource, pluginConfig, resourceConfig);
        switch (pluginResponse.getStatus()) {
            case SUCCESS: {
                this.facesMessages.addFromResourceBundle(FacesMessage.SEVERITY_INFO, "resource.status.create.success", new Object[]{this.serviceType.getName()});
                result = "success";
                break;
            }
            default: {
                String baseMessage = this.messages.getString("resource.status.create.failure");
                this.addActionFailureMessageToFacesMessages(baseMessage, pluginResponse.getErrorMessage(), pluginResponse.getResourceConfiguration());
                result = "failure";
                break;
            }
        }
        return result;
    }

    public void addMap() {
    }

    public void editMap() {
    }

    public void cancelEditMap() {
    }

    protected IdChunkGeneratorUIBean getIdChunkGenerator() {
        return this.idChunkGenerator;
    }

    protected ConfigHelperUIBean getConfigHelperUIBean() {
        return this.configHelperUIBean;
    }

    private void addActionFailureMessageToFacesMessages(@NotNull String baseMessage, String errorDetails, Configuration resourceConfiguration) {
        if (errorDetails == null || errorDetails.trim().equals("")) {
            errorDetails = ResourceConfigurationUIBean.containsPropertyErrors(resourceConfiguration) ? this.messages.getString("resource.status.invalidProps") : this.messages.getString("resource.status.failedForUnknownReason");
        }
        this.facesMessages.add(new FacesMessage(FacesMessage.SEVERITY_ERROR, baseMessage + " " + errorDetails, null));
    }

    private static boolean containsPropertyErrors(Configuration configuration) {
        if (configuration == null) {
            return false;
        }
        Map properties = configuration.getSimpleProperties();
        Set propNames = properties.keySet();
        for (String propName : propNames) {
            String error;
            PropertySimple property = (PropertySimple)properties.get(propName);
            if (property == null || (error = property.getErrorMessage()) == null || error.equals("")) continue;
            return true;
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ActionType {
        CREATE,
        UPDATE;

    }
}

