/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.ra;

import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import javax.jms.StreamMessage;
import javax.jms.TextMessage;
import org.hornetq.core.logging.Logger;
import org.hornetq.ra.HornetQRABytesMessage;
import org.hornetq.ra.HornetQRAMapMessage;
import org.hornetq.ra.HornetQRAMessage;
import org.hornetq.ra.HornetQRAMessageListener;
import org.hornetq.ra.HornetQRAObjectMessage;
import org.hornetq.ra.HornetQRASession;
import org.hornetq.ra.HornetQRAStreamMessage;
import org.hornetq.ra.HornetQRATextMessage;

public class HornetQRAMessageConsumer
implements MessageConsumer {
    private static final Logger log = Logger.getLogger(HornetQRAMessageConsumer.class);
    private static boolean trace = log.isTraceEnabled();
    protected MessageConsumer consumer;
    protected HornetQRASession session;

    public HornetQRAMessageConsumer(MessageConsumer consumer, HornetQRASession session) {
        this.consumer = consumer;
        this.session = session;
        if (trace) {
            log.trace((Object)("new HornetQMessageConsumer " + this + " consumer=" + consumer + " session=" + session));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws JMSException {
        if (trace) {
            log.trace((Object)("close " + this));
        }
        try {
            this.closeConsumer();
        }
        finally {
            this.session.removeConsumer(this);
        }
    }

    void checkState() throws JMSException {
        if (trace) {
            log.trace((Object)"checkState()");
        }
        this.session.checkState();
    }

    public MessageListener getMessageListener() throws JMSException {
        if (trace) {
            log.trace((Object)"getMessageListener()");
        }
        this.checkState();
        this.session.checkStrict();
        return this.consumer.getMessageListener();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMessageListener(MessageListener listener) throws JMSException {
        this.session.lock();
        try {
            this.checkState();
            this.session.checkStrict();
            if (listener == null) {
                this.consumer.setMessageListener(null);
            } else {
                this.consumer.setMessageListener(this.wrapMessageListener(listener));
            }
        }
        finally {
            this.session.unlock();
        }
    }

    public String getMessageSelector() throws JMSException {
        if (trace) {
            log.trace((Object)"getMessageSelector()");
        }
        this.checkState();
        return this.consumer.getMessageSelector();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message receive() throws JMSException {
        this.session.lock();
        try {
            if (trace) {
                log.trace((Object)("receive " + this));
            }
            this.checkState();
            Message message = this.consumer.receive();
            if (trace) {
                log.trace((Object)("received " + this + " result=" + message));
            }
            if (message == null) {
                Message message2 = null;
                return message2;
            }
            Message message3 = this.wrapMessage(message);
            return message3;
        }
        finally {
            this.session.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message receive(long timeout) throws JMSException {
        this.session.lock();
        try {
            if (trace) {
                log.trace((Object)("receive " + this + " timeout=" + timeout));
            }
            this.checkState();
            Message message = this.consumer.receive(timeout);
            if (trace) {
                log.trace((Object)("received " + this + " result=" + message));
            }
            if (message == null) {
                Message message2 = null;
                return message2;
            }
            Message message3 = this.wrapMessage(message);
            return message3;
        }
        finally {
            this.session.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message receiveNoWait() throws JMSException {
        this.session.lock();
        try {
            if (trace) {
                log.trace((Object)("receiveNoWait " + this));
            }
            this.checkState();
            Message message = this.consumer.receiveNoWait();
            if (trace) {
                log.trace((Object)("received " + this + " result=" + message));
            }
            if (message == null) {
                Message message2 = null;
                return message2;
            }
            Message message3 = this.wrapMessage(message);
            return message3;
        }
        finally {
            this.session.unlock();
        }
    }

    void closeConsumer() throws JMSException {
        if (trace) {
            log.trace((Object)"closeConsumer()");
        }
        this.consumer.close();
    }

    Message wrapMessage(Message message) {
        if (trace) {
            log.trace((Object)("wrapMessage(" + message + ")"));
        }
        if (message instanceof BytesMessage) {
            return new HornetQRABytesMessage((BytesMessage)message, this.session);
        }
        if (message instanceof MapMessage) {
            return new HornetQRAMapMessage((MapMessage)message, this.session);
        }
        if (message instanceof ObjectMessage) {
            return new HornetQRAObjectMessage((ObjectMessage)message, this.session);
        }
        if (message instanceof StreamMessage) {
            return new HornetQRAStreamMessage((StreamMessage)message, this.session);
        }
        if (message instanceof TextMessage) {
            return new HornetQRATextMessage((TextMessage)message, this.session);
        }
        return new HornetQRAMessage(message, this.session);
    }

    MessageListener wrapMessageListener(MessageListener listener) {
        if (trace) {
            log.trace((Object)"getMessageSelector()");
        }
        return new HornetQRAMessageListener(listener, this);
    }
}

