/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resource.deployers.management;

import java.util.ArrayList;
import org.jboss.managed.api.ManagedObject;
import org.jboss.profileservice.persistence.PersistenceFactory;
import org.jboss.profileservice.persistence.component.AbstractComponentMapper;
import org.jboss.profileservice.persistence.xml.PersistedComponent;
import org.jboss.resource.metadata.mcf.ManagedConnectionFactoryDeploymentGroup;
import org.jboss.resource.metadata.mcf.ManagedConnectionFactoryDeploymentMetaData;

public class MCFDGComponentMapper
extends AbstractComponentMapper {
    public MCFDGComponentMapper(PersistenceFactory persistenceFactory) {
        super(persistenceFactory);
    }

    protected void setComponentName(PersistedComponent component, ManagedObject mo) {
        ManagedConnectionFactoryDeploymentMetaData metaData = (ManagedConnectionFactoryDeploymentMetaData)mo.getAttachment();
        component.setName(metaData.getJndiName());
    }

    protected ManagedObject getComponent(Object attachment, PersistedComponent component, boolean create) {
        ManagedConnectionFactoryDeploymentGroup deployment = (ManagedConnectionFactoryDeploymentGroup)attachment;
        ManagedConnectionFactoryDeploymentMetaData metaData = null;
        if (deployment.getDeployments() != null && !deployment.getDeployments().isEmpty()) {
            for (ManagedConnectionFactoryDeploymentMetaData md : deployment.getDeployments()) {
                if (!md.getJndiName().equals(component.getOriginalName())) continue;
                metaData = md;
                break;
            }
        }
        if (metaData != null || create) {
            // empty if block
        }
        if (metaData == null) {
            throw new IllegalStateException("could not find deployment " + component.getOriginalName());
        }
        return this.getMOF().initManagedObject(metaData, null);
    }

    protected void removeComponent(Object attachment, PersistedComponent component) {
        ManagedConnectionFactoryDeploymentGroup deployment = (ManagedConnectionFactoryDeploymentGroup)attachment;
        if (deployment.getDeployments() != null && !deployment.getDeployments().isEmpty()) {
            ArrayList<ManagedConnectionFactoryDeploymentMetaData> deployments = new ArrayList<ManagedConnectionFactoryDeploymentMetaData>();
            for (ManagedConnectionFactoryDeploymentMetaData md : deployment.getDeployments()) {
                if (md.getJndiName().equals(component.getOriginalName())) continue;
                deployments.add(md);
            }
            deployment.setDeployments(deployments);
        }
    }

    public String getType() {
        return ManagedConnectionFactoryDeploymentGroup.class.getName();
    }
}

