/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.reloaded.naming.service;

import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.naming.spi.ObjectFactory;
import org.jboss.reloaded.naming.service.AppObjectFactory;
import org.jboss.reloaded.naming.service.ComponentObjectFactory;
import org.jboss.reloaded.naming.service.ModuleObjectFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NameSpaces {
    private InitialContext iniCtx;
    private Context globalContext;

    protected Reference createRef(String nns, Class<? extends ObjectFactory> objectFactory) {
        StringRefAddr refAddr = new StringRefAddr("nns", nns);
        Reference ref = new Reference("javax.naming.Context", refAddr, objectFactory.getName(), null);
        return ref;
    }

    public Context getGlobalContext() {
        return this.globalContext;
    }

    public void start() throws NamingException {
        this.iniCtx = new InitialContext();
        Context javaContext = (Context)this.iniCtx.lookup("java:");
        javaContext.rebind("comp", (Object)this.createRef("ENC", ComponentObjectFactory.class));
        javaContext.rebind("module", (Object)this.createRef("MOD", ModuleObjectFactory.class));
        javaContext.rebind("app", (Object)this.createRef("APP", AppObjectFactory.class));
        this.globalContext = javaContext.createSubcontext("global");
    }

    public void stop() throws NamingException {
        if (this.iniCtx == null) {
            return;
        }
        Context javaContext = (Context)this.iniCtx.lookup("java:");
        javaContext.unbind("global");
        this.globalContext = null;
        javaContext.unbind("app");
        javaContext.unbind("module");
        javaContext.unbind("comp");
        this.iniCtx.close();
    }
}

