/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.singleton.deployer;

import org.jboss.ejb3.container.spi.EJBContainer;
import org.jboss.ejb3.container.spi.EJBInstanceManager;
import org.jboss.ejb3.singleton.spi.SingletonEJBInstanceManager;
import org.jboss.logging.Logger;
import org.jboss.metadata.ejb.jboss.JBossEnterpriseBeanMetaData;
import org.jboss.metadata.ejb.jboss.JBossSessionBean31MetaData;

public class StartupSingletonInitiator {
    private static Logger logger = Logger.getLogger(StartupSingletonInitiator.class);
    private EJBContainer container;

    public StartupSingletonInitiator(EJBContainer container) {
        if (container == null) {
            throw new IllegalArgumentException("Container cannot be null while creating " + this.getClass().getName());
        }
        if (!this.isStartupSingletonBean(container.getMetaData())) {
            throw new IllegalArgumentException(container.getEJBName() + " is not a @Startup @Singleton bean");
        }
        this.container = container;
    }

    public void start() {
        EJBInstanceManager instanceManager = this.container.getBeanInstanceManager();
        if (instanceManager instanceof SingletonEJBInstanceManager) {
            SingletonEJBInstanceManager singletonBeanInstanceManager = (SingletonEJBInstanceManager)instanceManager;
            singletonBeanInstanceManager.get();
        } else {
            instanceManager.create();
        }
        logger.debug((Object)("Created an instance of @Startup @Singleton bean: " + this.container.getEJBName()));
    }

    private boolean isStartupSingletonBean(JBossEnterpriseBeanMetaData enterpriseBean) {
        if (!enterpriseBean.getJBossMetaData().isEJB31()) {
            return false;
        }
        if (!enterpriseBean.isSession()) {
            return false;
        }
        if (!(enterpriseBean instanceof JBossSessionBean31MetaData)) {
            return false;
        }
        JBossSessionBean31MetaData sessionBean = (JBossSessionBean31MetaData)enterpriseBean;
        if (!sessionBean.isSingleton()) {
            return false;
        }
        return sessionBean.isInitOnStartup();
    }
}

