/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modcluster.load.metric.impl;

import java.util.List;
import javax.management.JMException;
import org.jboss.modcluster.load.metric.impl.MBeanQueryLoadContext;
import org.jboss.modcluster.load.metric.impl.MBeanQueryLoadMetricSource;
import org.jboss.modcluster.load.metric.impl.SourcedLoadMetric;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MBeanAttributeRatioLoadMetric
extends SourcedLoadMetric<MBeanQueryLoadContext> {
    private final String dividendAttribute;
    private final String divisorAttribute;

    public MBeanAttributeRatioLoadMetric(MBeanQueryLoadMetricSource source, String currentAttribute, String maxAttribute) {
        super(source);
        this.dividendAttribute = currentAttribute;
        this.divisorAttribute = maxAttribute;
    }

    @Override
    public double getLoad(MBeanQueryLoadContext context) throws JMException {
        double dividend = 0.0;
        List<Number> results = context.getAttributes(this.dividendAttribute, Number.class);
        for (Number result : results) {
            dividend += result.doubleValue();
        }
        double divisor = 0.0;
        results = context.getAttributes(this.divisorAttribute, Number.class);
        for (Number result : results) {
            divisor += result.doubleValue();
        }
        return dividend / divisor;
    }
}

