/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.advice;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.jboss.aop.AspectManager;
import org.jboss.aop.advice.AdviceFactory;
import org.jboss.aop.advice.AspectFactory;
import org.jboss.aop.advice.CFlowInterceptor;
import org.jboss.aop.advice.GeneratedAdvisorInterceptor;
import org.jboss.aop.advice.GenericInterceptorFactory;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.advice.InterceptorFactory;
import org.jboss.aop.advice.PerInstanceInterceptor;
import org.jboss.aop.advice.PerJoinpointInterceptor;
import org.jboss.aop.advice.PrecedenceDef;
import org.jboss.aop.advice.PrecedenceDefEntry;
import org.jboss.aop.advice.PrecedenceGraph;
import org.jboss.aop.advice.SortedCFlowInterceptor;
import org.jboss.aop.pointcut.ast.ASTCFlowExpression;
import org.jboss.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrecedenceSorter {
    private static final Logger logger = Logger.getLogger(PrecedenceSorter.class);
    static Comparator<InterceptorEntry> interceptorComparator = new Comparator<InterceptorEntry>(){

        @Override
        public int compare(InterceptorEntry objA, InterceptorEntry objB) {
            InterceptorEntry entryA = objA;
            InterceptorEntry entryB = objB;
            return entryA.precedenceOrder - entryB.precedenceOrder;
        }
    };

    private static boolean matches(InterceptorEntry ientry, PrecedenceDefEntry pentry) {
        if (ientry.classname != null && pentry.interceptorClass != null && ientry.classname.equals(pentry.interceptorClass)) {
            if (ientry.method == null) {
                if (pentry.adviceMethod == null) {
                    return true;
                }
            } else if (pentry.adviceMethod != null) {
                return ientry.method.equals(pentry.adviceMethod);
            }
        }
        return false;
    }

    public static PrecedenceDefEntry[] createOverallPrecedence(AspectManager manager) {
        PrecedenceGraph precedenceGraph = new PrecedenceGraph(manager.getPrecedenceDefs().values());
        return precedenceGraph.getSortedPrecedence();
    }

    @Deprecated
    public static ArrayList<PrecedenceDefEntry> mergePrecedenceDef(ArrayList<PrecedenceDefEntry> overall, PrecedenceDef precedenceDef) {
        PrecedenceDefEntry[] entries = precedenceDef.getEntries();
        int start = 0;
        int end = 0;
        int size = overall.size();
        for (int i = 0; i < size; ++i) {
            PrecedenceDefEntry global = overall.get(i);
            boolean found = false;
            for (int j = start; j < entries.length; ++j) {
                PrecedenceDefEntry cur = entries[j];
                if (!cur.equals(global)) continue;
                found = true;
                end = j;
                break;
            }
            if (!found) continue;
            int insert = i;
            for (int j = start; j < end; ++j) {
                overall.add(insert++, entries[j]);
            }
            start = ++end;
        }
        for (int j = start; j < entries.length; ++j) {
            overall.add(entries[j]);
        }
        return overall;
    }

    public static Interceptor[] applyPrecedence(Interceptor[] interceptors, AspectManager manager) {
        if (interceptors.length == 0) {
            return interceptors;
        }
        ArrayList<InterceptorEntry> all = new ArrayList<InterceptorEntry>(interceptors.length);
        ArrayList<InterceptorEntry> precedence = new ArrayList<InterceptorEntry>(interceptors.length);
        PrecedenceDefEntry[] precedenceEntries = manager.getSortedPrecedenceDefEntries();
        boolean cflowFound = false;
        for (int i = 0; i < interceptors.length; ++i) {
            InterceptorEntry[] interceptorEntries;
            ASTCFlowExpression cflow = null;
            if (interceptors[i] instanceof CFlowInterceptor) {
                cflowFound = true;
                CFlowInterceptor cflowInterceptor = (CFlowInterceptor)interceptors[i];
                cflow = cflowInterceptor.getExpr();
                interceptorEntries = new InterceptorEntry[cflowInterceptor.getChain().length];
                for (int j = 0; j < interceptorEntries.length; ++j) {
                    interceptorEntries[j] = new InterceptorEntry(cflowInterceptor.getChain()[j], cflow);
                    all.add(interceptorEntries[j]);
                }
            } else {
                interceptorEntries = new InterceptorEntry[]{new InterceptorEntry(interceptors[i])};
                all.add(interceptorEntries[0]);
            }
            block2: for (int k = 0; k < interceptorEntries.length; ++k) {
                InterceptorEntry interceptorEntry = interceptorEntries[k];
                for (int j = 0; j < precedenceEntries.length; ++j) {
                    if (!PrecedenceSorter.matches(interceptorEntry, precedenceEntries[j])) continue;
                    interceptorEntry.originalOrder = all.size() - interceptorEntries.length + k;
                    interceptorEntry.precedenceOrder = j;
                    precedence.add(interceptorEntry);
                    continue block2;
                }
            }
        }
        Collections.sort(precedence, interceptorComparator);
        Interceptor[] sortedInterceptors = new Interceptor[all.size()];
        ASTCFlowExpression[] sortedCFlows = new ASTCFlowExpression[all.size()];
        int prec = 0;
        int allSize = all.size();
        int precedenceSize = precedence.size();
        for (int i = 0; i < allSize; ++i) {
            InterceptorEntry entry = (InterceptorEntry)all.get(i);
            if (entry.precedenceOrder >= 0 && prec < precedenceSize) {
                entry = (InterceptorEntry)precedence.get(prec++);
            }
            sortedInterceptors[i] = entry.interceptor;
            sortedCFlows[i] = entry.cflow;
        }
        if (cflowFound) {
            return new Interceptor[]{new SortedCFlowInterceptor(sortedInterceptors, sortedCFlows)};
        }
        return sortedInterceptors;
    }

    public static GeneratedAdvisorInterceptor[] applyPrecedence(GeneratedAdvisorInterceptor[] interceptors, AspectManager manager) {
        ArrayList<InterceptorEntry> all = new ArrayList<InterceptorEntry>(interceptors.length);
        ArrayList<InterceptorEntry> precedence = new ArrayList<InterceptorEntry>(interceptors.length);
        PrecedenceDefEntry[] precedenceEntries = manager.getSortedPrecedenceDefEntries();
        block0: for (int i = 0; i < interceptors.length; ++i) {
            InterceptorEntry interceptorEntry = new InterceptorEntry(interceptors[i]);
            all.add(interceptorEntry);
            for (int j = 0; j < precedenceEntries.length; ++j) {
                if (!PrecedenceSorter.matches(interceptorEntry, precedenceEntries[j])) continue;
                interceptorEntry.originalOrder = i;
                interceptorEntry.precedenceOrder = j;
                precedence.add(interceptorEntry);
                continue block0;
            }
        }
        Collections.sort(precedence, interceptorComparator);
        GeneratedAdvisorInterceptor[] sortedInterceptors = new GeneratedAdvisorInterceptor[interceptors.length];
        int prec = 0;
        int allSize = all.size();
        int precedenceSize = precedence.size();
        for (int i = 0; i < allSize; ++i) {
            InterceptorEntry entry = (InterceptorEntry)all.get(i);
            if (entry.precedenceOrder >= 0 && prec < precedenceSize) {
                entry = (InterceptorEntry)precedence.get(prec++);
            }
            sortedInterceptors[i] = entry.factoryWrapper;
        }
        return sortedInterceptors;
    }

    static class InterceptorEntry {
        Interceptor interceptor;
        ASTCFlowExpression cflow;
        GeneratedAdvisorInterceptor factoryWrapper;
        int originalOrder;
        int precedenceOrder = -1;
        String classname;
        String method;

        InterceptorEntry(GeneratedAdvisorInterceptor factoryWrapper) {
            this.factoryWrapper = factoryWrapper;
            this.classname = factoryWrapper.getName();
            InterceptorFactory ifac = factoryWrapper.getDelegate();
            if (ifac instanceof GenericInterceptorFactory) {
                this.classname = ((GenericInterceptorFactory)ifac).getClassName();
            } else {
                AspectFactory af = factoryWrapper.getAspect().getFactory();
                this.classname = af.getName();
            }
            if (ifac instanceof AdviceFactory) {
                this.method = ((AdviceFactory)ifac).getAdvice();
            }
        }

        InterceptorEntry(Interceptor interceptor) {
            Interceptor icptr;
            this.interceptor = interceptor;
            String interceptorName = null;
            if (interceptor instanceof PerInstanceInterceptor) {
                icptr = (PerInstanceInterceptor)interceptor;
                interceptorName = ((PerInstanceInterceptor)icptr).getName();
            } else if (interceptor instanceof PerJoinpointInterceptor) {
                icptr = (PerJoinpointInterceptor)interceptor;
                interceptorName = ((PerJoinpointInterceptor)icptr).getName();
            } else if (interceptor instanceof CFlowInterceptor) {
                icptr = (CFlowInterceptor)interceptor;
                interceptorName = ((CFlowInterceptor)icptr).getName();
            } else {
                interceptorName = interceptor.getClass().getName();
            }
            try {
                boolean isAdvice = interceptorName.startsWith("org.jboss.aop.advice.");
                if (isAdvice) {
                    String name = interceptor.getName();
                    int index = name.lastIndexOf(".");
                    this.classname = name.substring(0, index);
                    this.method = name.substring(index + 1);
                } else {
                    this.classname = interceptorName;
                }
            }
            catch (RuntimeException e) {
                logger.error((Object)interceptor.getName());
                throw e;
            }
        }

        InterceptorEntry(Interceptor interceptor, ASTCFlowExpression cflow) {
            this(interceptor);
            this.cflow = cflow;
        }

        public String toString() {
            return "Entry: " + this.precedenceOrder + " (" + this.originalOrder + ")interceptorClass=" + this.classname + "; adviceMethod=" + this.method;
        }
    }
}

