/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.container.entries;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.infinispan.container.entries.AbstractInternalCacheEntry;
import org.infinispan.container.entries.InternalCacheValue;
import org.infinispan.container.entries.TransientCacheValue;
import org.infinispan.io.UnsignedNumeric;
import org.infinispan.marshall.Marshallable;

@Marshallable(externalizer=Externalizer.class, id=12)
public class TransientCacheEntry
extends AbstractInternalCacheEntry {
    private TransientCacheValue cacheValue;

    TransientCacheEntry(Object key, Object value, long maxIdle) {
        this(key, value, maxIdle, System.currentTimeMillis());
    }

    TransientCacheEntry(Object key, Object value, long maxIdle, long lastUsed) {
        super(key);
        this.cacheValue = new TransientCacheValue(value, maxIdle, lastUsed);
    }

    @Override
    public Object getValue() {
        return this.cacheValue.value;
    }

    @Override
    public Object setValue(Object value) {
        return this.cacheValue.setValue(value);
    }

    @Override
    public final void touch() {
        this.cacheValue.lastUsed = System.currentTimeMillis();
    }

    @Override
    public final void reincarnate() {
    }

    @Override
    public final boolean canExpire() {
        return true;
    }

    @Override
    public boolean isExpired() {
        return this.cacheValue.isExpired();
    }

    @Override
    public void setMaxIdle(long maxIdle) {
        this.cacheValue.maxIdle = maxIdle;
    }

    @Override
    public long getCreated() {
        return -1L;
    }

    @Override
    public final long getLastUsed() {
        return this.cacheValue.lastUsed;
    }

    @Override
    public long getLifespan() {
        return -1L;
    }

    @Override
    public long getExpiryTime() {
        return this.cacheValue.maxIdle > -1L ? this.cacheValue.lastUsed + this.cacheValue.maxIdle : -1L;
    }

    @Override
    public final long getMaxIdle() {
        return this.cacheValue.maxIdle;
    }

    @Override
    public InternalCacheValue toInternalCacheValue() {
        return this.cacheValue;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransientCacheEntry that = (TransientCacheEntry)o;
        if (this.key != null ? !this.key.equals(that.key) : that.key != null) {
            return false;
        }
        if (this.cacheValue.value != null ? !this.cacheValue.value.equals(that.cacheValue.value) : that.cacheValue.value != null) {
            return false;
        }
        if (this.cacheValue.lastUsed != that.cacheValue.lastUsed) {
            return false;
        }
        return this.cacheValue.maxIdle == that.cacheValue.maxIdle;
    }

    @Override
    public int hashCode() {
        int result = this.key != null ? this.key.hashCode() : 0;
        result = 31 * result + (this.cacheValue.value != null ? this.cacheValue.value.hashCode() : 0);
        result = 31 * result + (int)(this.cacheValue.lastUsed ^ this.cacheValue.lastUsed >>> 32);
        result = 31 * result + (int)(this.cacheValue.maxIdle ^ this.cacheValue.maxIdle >>> 32);
        return result;
    }

    @Override
    public TransientCacheEntry clone() {
        TransientCacheEntry clone = (TransientCacheEntry)super.clone();
        clone.cacheValue = this.cacheValue.clone();
        return clone;
    }

    @Override
    public String toString() {
        return "TransientCacheEntry{cacheValue=" + this.cacheValue + "} " + super.toString();
    }

    public static class Externalizer
    implements org.infinispan.marshall.Externalizer {
        @Override
        public void writeObject(ObjectOutput output, Object subject) throws IOException {
            TransientCacheEntry ice = (TransientCacheEntry)subject;
            output.writeObject(ice.key);
            output.writeObject(((TransientCacheEntry)ice).cacheValue.value);
            UnsignedNumeric.writeUnsignedLong(output, ((TransientCacheEntry)ice).cacheValue.lastUsed);
            output.writeLong(((TransientCacheEntry)ice).cacheValue.maxIdle);
        }

        @Override
        public Object readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            Object k = input.readObject();
            Object v = input.readObject();
            long lastUsed = UnsignedNumeric.readUnsignedLong(input);
            Long maxIdle = input.readLong();
            return new TransientCacheEntry(k, v, maxIdle, lastUsed);
        }
    }
}

