/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors;

import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.infinispan.CacheException;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.control.LockControlCommand;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.interceptors.base.CommandInterceptor;
import org.infinispan.lifecycle.ComponentStatus;

public class InvocationContextInterceptor
extends CommandInterceptor {
    private TransactionManager tm;
    private ComponentRegistry componentRegistry;

    @Inject
    public void init(TransactionManager tm, ComponentRegistry componentRegistry) {
        this.tm = tm;
        this.componentRegistry = componentRegistry;
    }

    @Override
    public Object handleDefault(InvocationContext ctx, VisitableCommand command) throws Throwable {
        return this.handleAll(ctx, command);
    }

    @Override
    public Object visitLockControlCommand(TxInvocationContext ctx, LockControlCommand lcc) throws Throwable {
        Object retval = this.handleAll(ctx, lcc);
        return retval == null ? Boolean.valueOf(false) : retval;
    }

    private Object handleAll(InvocationContext ctx, VisitableCommand command) throws Throwable {
        boolean suppressExceptions = false;
        ComponentStatus status = this.componentRegistry.getStatus();
        if (status.isTerminated()) {
            String cacheName = this.componentRegistry.getCacheName();
            String prefix = "Cache '" + cacheName + "'";
            if (cacheName.equals("___defaultcache")) {
                prefix = "Default cache";
            }
            throw new IllegalStateException(prefix + " is in 'TERMINATED' state and so it does not accept new invocations. Either restart it or recreate the cache container.");
        }
        if (this.trace) {
            this.log.trace("Invoked with command " + command + " and InvocationContext [" + ctx + "]");
        }
        if (ctx == null) {
            throw new IllegalStateException("Null context not allowed!!");
        }
        if (ctx.hasFlag(Flag.FAIL_SILENTLY)) {
            suppressExceptions = true;
        }
        try {
            Object cacheName = this.invokeNextInterceptor(ctx, command);
            return cacheName;
        }
        catch (Throwable th) {
            if (suppressExceptions) {
                this.log.trace((Object)"Exception while executing code, failing silently...", th);
                Object var6_9 = null;
                return var6_9;
            }
            this.log.error((Object)"Execution error: ", th);
            if (ctx.isInTxScope() && ctx.isOriginLocal()) {
                if (this.trace) {
                    this.log.trace("Transaction marked for rollback as exception was received.");
                }
                this.markTxForRollbackAndRethrow(ctx, th);
                throw new IllegalStateException("This should not be reached");
            }
            throw th;
        }
        finally {
            ctx.reset();
        }
    }

    private Object markTxForRollbackAndRethrow(InvocationContext ctx, Throwable te) throws Throwable {
        Transaction transaction;
        if (ctx.isOriginLocal() && ctx.isInTxScope() && (transaction = this.tm.getTransaction()) != null && this.isValidRunningTx(transaction)) {
            transaction.setRollbackOnly();
        }
        throw te;
    }

    public boolean isValidRunningTx(Transaction tx) throws Exception {
        int status;
        try {
            status = tx.getStatus();
        }
        catch (SystemException e) {
            throw new CacheException("Unexpected!", e);
        }
        return status == 0 || status == 7;
    }
}

