/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.remoting.impl.invm;

import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import org.hornetq.api.core.HornetQBuffer;
import org.hornetq.api.core.HornetQBuffers;
import org.hornetq.core.logging.Logger;
import org.hornetq.spi.core.protocol.ProtocolType;
import org.hornetq.spi.core.remoting.BufferHandler;
import org.hornetq.spi.core.remoting.Connection;
import org.hornetq.spi.core.remoting.ConnectionLifeCycleListener;
import org.hornetq.utils.UUIDGenerator;

public class InVMConnection
implements Connection {
    private static final Logger log = Logger.getLogger(InVMConnection.class);
    private final BufferHandler handler;
    private final ConnectionLifeCycleListener listener;
    private final String id;
    private boolean closed;
    private final int serverID;
    private final Executor executor;
    private volatile boolean closing;

    public InVMConnection(int serverID, BufferHandler handler, ConnectionLifeCycleListener listener, Executor executor) {
        this(serverID, UUIDGenerator.getInstance().generateSimpleStringUUID().toString(), handler, listener, executor);
    }

    public InVMConnection(int serverID, String id, BufferHandler handler, ConnectionLifeCycleListener listener, Executor executor) {
        this.serverID = serverID;
        this.handler = handler;
        this.listener = listener;
        this.id = id;
        this.executor = executor;
        listener.connectionCreated(this, ProtocolType.CORE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this.closing) {
            return;
        }
        this.closing = true;
        InVMConnection inVMConnection = this;
        synchronized (inVMConnection) {
            if (!this.closed) {
                this.listener.connectionDestroyed(this.id);
                this.closed = true;
            }
        }
    }

    @Override
    public HornetQBuffer createBuffer(int size) {
        return HornetQBuffers.dynamicBuffer(size);
    }

    @Override
    public Object getID() {
        return this.id;
    }

    @Override
    public void checkFlushBatchBuffer() {
    }

    @Override
    public void write(HornetQBuffer buffer) {
        this.write(buffer, false, false);
    }

    @Override
    public void write(HornetQBuffer buffer, boolean flush, boolean batch) {
        final HornetQBuffer copied = buffer.copy(0, buffer.capacity());
        copied.setIndex(buffer.readerIndex(), buffer.writerIndex());
        try {
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (!InVMConnection.this.closed) {
                            copied.readInt();
                            InVMConnection.this.handler.bufferReceived(InVMConnection.this.id, copied);
                        }
                    }
                    catch (Exception e) {
                        String msg = "Failed to write to handler";
                        log.error("Failed to write to handler", e);
                        throw new IllegalStateException("Failed to write to handler", e);
                    }
                }
            });
        }
        catch (RejectedExecutionException e) {
            // empty catch block
        }
    }

    @Override
    public String getRemoteAddress() {
        return "invm:" + this.serverID;
    }

    public int getBatchingBufferSize() {
        return -1;
    }
}

