/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.filter.etcl;

import antlr.Token;
import org.jacorb.notification.filter.EvaluationContext;
import org.jacorb.notification.filter.EvaluationException;
import org.jacorb.notification.filter.EvaluationResult;
import org.jacorb.notification.filter.etcl.AbstractTCLNode;
import org.jacorb.notification.filter.etcl.AbstractTCLVisitor;
import org.jacorb.notification.filter.etcl.VisitorException;

public class BoolValue
extends AbstractTCLNode {
    private final boolean value_;
    private final EvaluationResult result_;
    private final String asString_;

    public BoolValue(Token token) {
        super(token);
        this.value_ = token.getText().equals("TRUE");
        this.result_ = this.value_ ? EvaluationResult.BOOL_TRUE : EvaluationResult.BOOL_FALSE;
        this.asString_ = Boolean.toString(this.value_);
        this.setName("BoolValue");
    }

    public EvaluationResult evaluate(EvaluationContext evaluationContext) throws EvaluationException {
        return this.result_;
    }

    public boolean isStatic() {
        return true;
    }

    public boolean isBoolean() {
        return true;
    }

    public String toString() {
        return this.asString_;
    }

    public void acceptInOrder(AbstractTCLVisitor abstractTCLVisitor) throws VisitorException {
        abstractTCLVisitor.visitBool(this);
    }

    public void acceptPostOrder(AbstractTCLVisitor abstractTCLVisitor) throws VisitorException {
        abstractTCLVisitor.visitBool(this);
    }

    public void acceptPreOrder(AbstractTCLVisitor abstractTCLVisitor) throws VisitorException {
        abstractTCLVisitor.visitBool(this);
    }
}

