/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.security.ssl.sun_jsse;

import java.security.SecureRandom;
import org.jacorb.config.Configurable;
import org.jacorb.config.Configuration;
import org.jacorb.config.ConfigurationException;
import org.jacorb.security.ssl.sun_jsse.JSRandom;
import org.slf4j.Logger;

public class SSLRandom
implements Configurable {
    private JSRandom randomImpl;
    protected Logger logger;

    protected SecureRandom getSecureRandom() {
        SecureRandom secureRandom = null;
        if (this.randomImpl != null) {
            secureRandom = this.randomImpl.getSecureRandom();
        }
        return secureRandom;
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        Configuration configuration2 = configuration;
        this.logger = configuration2.getLogger("jacorb.security.jsse");
        try {
            this.randomImpl = (JSRandom)configuration2.getAttributeAsObject("jacorb.security.randomClassPlugin");
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Using JSRandom " + configuration2.getAttribute("jacorb.security.randomClassPlugin") + " implemented by " + this.randomImpl);
            }
        }
        catch (ConfigurationException configurationException) {
            // empty catch block
        }
    }
}

