/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.kernel;

import org.jboss.dependency.plugins.tracker.NoopContextTracker;
import org.jboss.dependency.spi.tracker.ContextTracker;
import org.jboss.kernel.Kernel;
import org.jboss.kernel.spi.metadata.KernelMetaDataRepository;
import org.jboss.logging.Logger;
import org.jboss.metadata.plugins.loader.memory.MemoryMetaDataLoader;
import org.jboss.metadata.spi.MutableMetaData;
import org.jboss.metadata.spi.repository.MutableMetaDataRepository;
import org.jboss.metadata.spi.retrieval.MetaDataRetrieval;
import org.jboss.metadata.spi.scope.ScopeKey;

public class KernelInstaller {
    private Logger log = Logger.getLogger(KernelInstaller.class);
    private Kernel kernel;
    private ContextTracker tracker;

    public KernelInstaller(Kernel kernel) {
        if (kernel == null) {
            throw new IllegalArgumentException("Null Kernel");
        }
        this.kernel = kernel;
    }

    public void create() {
        if (this.tracker == null) {
            this.tracker = new NoopContextTracker();
        }
    }

    public void start() {
        KernelMetaDataRepository kmdr = this.kernel.getMetaDataRepository();
        MutableMetaDataRepository repository = kmdr.getMetaDataRepository();
        MetaDataRetrieval retrieval = repository.getMetaDataRetrieval(ScopeKey.DEFAULT_SCOPE);
        if (retrieval == null) {
            retrieval = new MemoryMetaDataLoader(ScopeKey.DEFAULT_SCOPE);
            repository.addMetaDataRetrieval(retrieval);
        }
        if (retrieval instanceof MutableMetaData) {
            MutableMetaData mmd = (MutableMetaData)retrieval;
            mmd.addMetaData((Object)this.tracker, ContextTracker.class);
        } else {
            this.log.info((Object)("Cannot add/modify default scoped metadata: " + retrieval));
        }
    }

    public void stop() {
        KernelMetaDataRepository kmdr = this.kernel.getMetaDataRepository();
        MutableMetaDataRepository repository = kmdr.getMetaDataRepository();
        MetaDataRetrieval retrieval = repository.getMetaDataRetrieval(ScopeKey.DEFAULT_SCOPE);
        if (retrieval != null && retrieval instanceof MutableMetaData) {
            MutableMetaData mmd = (MutableMetaData)retrieval;
            mmd.removeMetaData(ContextTracker.class);
            if (retrieval.isEmpty()) {
                repository.removeMetaDataRetrieval(retrieval.getScope());
            }
        } else {
            this.log.debug((Object)("Ignoring remove/modify default scoped metadata: " + retrieval));
        }
    }

    public void setTracker(ContextTracker tracker) {
        this.tracker = tracker;
    }
}

