/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web;

import org.jboss.system.ServiceMBeanSupport;
import org.jboss.web.RMICodebaseConfigurerMBean;

public class RMICodebaseConfigurer
extends ServiceMBeanSupport
implements RMICodebaseConfigurerMBean {
    private String host;
    private int port = -1;

    public String getCodebaseHost() {
        return this.host;
    }

    public int getCodebasePort() {
        return this.port;
    }

    public void setCodebaseHost(String host) {
        this.host = host;
    }

    public void setCodebasePort(int port) {
        this.port = port;
    }

    protected void startService() throws Exception {
        String codebase = System.getProperty("java.rmi.server.codebase");
        if (codebase == null) {
            if (this.host != null) {
                codebase = "http://" + this.getHostPortion() + this.getPortPortion() + "/";
                System.setProperty("java.rmi.server.codebase", codebase);
            } else {
                this.getLog().warn((Object)"Property codebaseHost has not been set; cannot set java.rmi.server.codebase");
            }
        }
    }

    private String getHostPortion() {
        if (this.host.indexOf(58) > -1 && this.host.indexOf(91) != 0) {
            return "[" + this.host + "]";
        }
        return this.host;
    }

    private String getPortPortion() {
        if (this.port > 0) {
            return ":" + this.port;
        }
        return "";
    }
}

