/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.deployers;

import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.DeploymentStages;
import org.jboss.deployers.spi.deployer.helpers.AbstractDeployer;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.metadata.web.jboss.JBoss60WebMetaData;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.metadata.web.spec.WebMetaData;
import org.jboss.xb.binding.JBossXBException;
import org.jboss.xb.binding.Unmarshaller;
import org.jboss.xb.binding.UnmarshallerFactory;
import org.jboss.xb.binding.resolver.MutableSchemaResolver;
import org.jboss.xb.binding.sunday.unmarshalling.SchemaBindingResolver;
import org.jboss.xb.binding.sunday.unmarshalling.SingletonSchemaResolverFactory;

public class SharedJBossWebMetaDataDeployer
extends AbstractDeployer {
    public static final String SHARED_JBOSSWEB_ATTACHMENT_NAME = "shared." + JBossWebMetaData.class.getName();
    private String webXml = null;
    private String jbossWebXml = null;
    private JBossWebMetaData sharedJBossWebMetaData = null;
    private WebMetaData sharedWebMetaData = null;

    public String getWebXml() {
        return this.webXml;
    }

    public void setWebXml(String webXml) {
        this.webXml = webXml;
    }

    public String getJbossWebXml() {
        return this.jbossWebXml;
    }

    public void setJbossWebXml(String jbossWebXml) {
        this.jbossWebXml = jbossWebXml;
    }

    public SharedJBossWebMetaDataDeployer() {
        this.setStage(DeploymentStages.POST_CLASSLOADER);
        this.addOutput(SHARED_JBOSSWEB_ATTACHMENT_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deploy(DeploymentUnit unit) throws DeploymentException {
        SharedJBossWebMetaDataDeployer sharedJBossWebMetaDataDeployer = this;
        synchronized (sharedJBossWebMetaDataDeployer) {
            if (this.sharedWebMetaData == null && this.webXml != null || this.sharedJBossWebMetaData == null && this.jbossWebXml != null) {
                UnmarshallerFactory factory = UnmarshallerFactory.newInstance();
                Unmarshaller unmarshaller = factory.newUnmarshaller();
                MutableSchemaResolver resolver = SingletonSchemaResolverFactory.getInstance().getSchemaBindingResolver();
                if (this.webXml != null) {
                    try {
                        this.sharedWebMetaData = (WebMetaData)unmarshaller.unmarshal(this.webXml, (SchemaBindingResolver)resolver);
                    }
                    catch (JBossXBException e) {
                        throw new DeploymentException("Error parsing shared web.xml", (Throwable)e);
                    }
                }
                if (this.jbossWebXml != null) {
                    try {
                        this.sharedJBossWebMetaData = (JBossWebMetaData)unmarshaller.unmarshal(this.jbossWebXml, (SchemaBindingResolver)resolver);
                    }
                    catch (JBossXBException e) {
                        throw new DeploymentException("Error parsing shared jboss-web.xml", (Throwable)e);
                    }
                }
            }
        }
        if (this.sharedWebMetaData != null || this.sharedJBossWebMetaData != null) {
            JBoss60WebMetaData clone = new JBoss60WebMetaData();
            clone.merge(this.sharedJBossWebMetaData, this.sharedWebMetaData);
            unit.addAttachment(SHARED_JBOSSWEB_ATTACHMENT_NAME, (Object)clone);
        }
    }
}

