/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.entity.hibernate;

import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.persistence.EntityManager;
import org.hibernate.Session;
import org.hibernate.ejb.HibernateEntityManager;
import org.jboss.ejb3.stateful.StatefulBeanContext;

public class ExtendedSessionInvocationHandler
implements InvocationHandler,
Serializable {
    private static final long serialVersionUID = -2091491765429086936L;
    private String identity;

    public ExtendedSessionInvocationHandler(String identity) {
        this.identity = identity;
    }

    public ExtendedSessionInvocationHandler() {
    }

    public EntityManager getPersistenceContext() {
        StatefulBeanContext beanContext = StatefulBeanContext.currentBean.get();
        EntityManager persistenceContext = beanContext.getExtendedPersistenceContext(this.identity);
        if (persistenceContext == null) {
            throw new RuntimeException("Unable to determine persistenceContext: " + this.identity + " in injected SFSB: " + beanContext.getContainer().getObjectName());
        }
        return persistenceContext;
    }

    public Session getHibernateSession() {
        EntityManager persistenceContext = this.getPersistenceContext();
        if (persistenceContext instanceof HibernateEntityManager) {
            return ((HibernateEntityManager)persistenceContext).getSession();
        }
        throw new RuntimeException("ILLEGAL ACTION:  Not a Hibernate persistence provider");
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String methodName = method.getName();
        if ("getPersistenceContext".equals(methodName)) {
            return this.getPersistenceContext();
        }
        if ("close".equals(methodName)) {
            throw new IllegalStateException("It is illegal to close an injected Hibernate Session");
        }
        if ("toString".equals(methodName)) {
            return this.toString() + "[identity=" + this.identity + "]";
        }
        try {
            return method.invoke((Object)this.getHibernateSession(), args);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof RuntimeException) {
                throw (RuntimeException)e.getTargetException();
            }
            throw e;
        }
    }
}

