/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bootstrap.api.descriptor;

import java.io.InputStream;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.logging.Logger;
import org.jboss.bootstrap.api.descriptor.BootstrapDescriptor;
import org.jboss.bootstrap.api.descriptor.BootstrapDescriptorBase;
import org.jboss.bootstrap.api.descriptor.UrlBootstrapDescriptor;

public class ClassLoaderResourceBootstrapDescriptor
extends BootstrapDescriptorBase
implements BootstrapDescriptor {
    private static final Logger log = Logger.getLogger(ClassLoaderResourceBootstrapDescriptor.class.getName());
    private final BootstrapDescriptor urlDescriptor;

    public ClassLoaderResourceBootstrapDescriptor(String name) throws IllegalArgumentException {
        this(name, AccessController.doPrivileged(GetTcclAction.INSTANCE));
    }

    public ClassLoaderResourceBootstrapDescriptor(String name, ClassLoader cl) throws IllegalArgumentException {
        if (cl == null) {
            throw new IllegalArgumentException("cl must be specified");
        }
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("name must be specified");
        }
        URL url = cl.getResource(name);
        if (url == null) {
            throw new IllegalArgumentException("Could not find requested resource \"" + name + "\" in " + cl);
        }
        UrlBootstrapDescriptor delegate = new UrlBootstrapDescriptor(url);
        this.urlDescriptor = delegate;
    }

    @Override
    public String getName() {
        return this.urlDescriptor.getName();
    }

    @Override
    public InputStream getContent() {
        return this.urlDescriptor.getContent();
    }

    private static enum GetTcclAction implements PrivilegedAction<ClassLoader>
    {
        INSTANCE;


        @Override
        public ClassLoader run() {
            return Thread.currentThread().getContextClassLoader();
        }
    }
}

