/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting3.remote;

import org.jboss.remoting3.remote.RemoteConnectionHandler;
import org.jboss.remoting3.spi.RemoteRequestHandler;
import org.jboss.xnio.Cancellable;
import org.jboss.xnio.Result;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class OutboundClient
implements Cancellable {
    private State state = State.REPLY_WAIT;
    private Result<RemoteRequestHandler> result;
    private final int id;
    private final String serviceType;
    private final String groupName;
    private RemoteConnectionHandler remoteConnectionHandler;
    private RemoteRequestHandler requestHandler;

    OutboundClient(RemoteConnectionHandler remoteConnectionHandler, int id, Result<RemoteRequestHandler> result, String serviceType, String groupName) {
        this.remoteConnectionHandler = remoteConnectionHandler;
        this.id = id;
        this.result = result;
        this.serviceType = serviceType;
        this.groupName = groupName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    State getState() {
        OutboundClient outboundClient = this;
        synchronized (outboundClient) {
            return this.state;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setState(State state) {
        OutboundClient outboundClient = this;
        synchronized (outboundClient) {
            this.state = state;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Cancellable cancel() {
        OutboundClient outboundClient = this;
        synchronized (outboundClient) {
            if (this.state != State.REPLY_WAIT) {
                return this;
            }
            this.state = State.CLOSED;
        }
        this.result.setCancelled();
        return this;
    }

    Result<RemoteRequestHandler> getResult() {
        return this.result;
    }

    String getServiceType() {
        return this.serviceType;
    }

    String getGroupName() {
        return this.groupName;
    }

    RemoteConnectionHandler getRemoteConnectionHandler() {
        return this.remoteConnectionHandler;
    }

    public int getId() {
        return this.id;
    }

    RemoteRequestHandler getRequestHandler() {
        return this.requestHandler;
    }

    void setResult(RemoteRequestHandler requestHandler) {
        this.result.setResult((Object)requestHandler);
        this.requestHandler = requestHandler;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum State {
        REPLY_WAIT,
        ESTABLISHED,
        CLOSE_WAIT,
        CLOSED;

    }
}

