/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting3.remote;

import java.nio.ByteBuffer;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import org.jboss.remoting3.remote.SaslContext;

final class SaslServerContext
implements SaslContext {
    private final SaslServer saslServer;

    SaslServerContext(SaslServer saslServer) {
        this.saslServer = saslServer;
    }

    public String getMechanismName() {
        return this.saslServer.getMechanismName();
    }

    public Object getNegotiatedProperty(String name) {
        return this.saslServer.getNegotiatedProperty(name);
    }

    public ByteBuffer unwrap(ByteBuffer src) throws SaslException {
        byte[] unwrapped;
        if (src.hasArray()) {
            byte[] orig = src.array();
            int start = src.arrayOffset() + src.position();
            int len = src.remaining();
            unwrapped = this.saslServer.unwrap(orig, start, len);
        } else {
            int len = src.remaining();
            byte[] orig = new byte[len];
            src.get(orig);
            unwrapped = this.saslServer.unwrap(orig, 0, len);
        }
        return ByteBuffer.wrap(unwrapped);
    }
}

