/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting3.security;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.AuthenticationException;
import javax.security.sasl.AuthorizeCallback;
import javax.security.sasl.RealmCallback;
import org.jboss.remoting3.security.RemotingPermission;
import org.jboss.remoting3.security.ServerAuthenticationProvider;

public final class SimpleServerAuthenticationProvider
implements ServerAuthenticationProvider {
    private static final RemotingPermission ADD_USER_PERM = new RemotingPermission("addServerUser");
    private final Map<String, Map<String, Entry>> map = new HashMap<String, Map<String, Entry>>();

    public CallbackHandler getCallbackHandler() {
        return new CallbackHandler(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
                String userName = null;
                String realmName = null;
                for (Callback callback : callbacks) {
                    if (callback instanceof NameCallback) {
                        NameCallback nameCallback = (NameCallback)callback;
                        String defaultName = nameCallback.getDefaultName();
                        userName = defaultName.toLowerCase().trim();
                        nameCallback.setName(userName);
                        continue;
                    }
                    if (callback instanceof RealmCallback) {
                        RealmCallback realmCallback = (RealmCallback)callback;
                        String defaultRealm = realmCallback.getDefaultText();
                        if (defaultRealm == null) continue;
                        realmName = defaultRealm.toLowerCase().trim();
                        realmCallback.setText(realmName);
                        continue;
                    }
                    if (callback instanceof PasswordCallback) {
                        Map map;
                        PasswordCallback passwordCallback = (PasswordCallback)callback;
                        Entry entry = null;
                        if (realmName == null) {
                            map = SimpleServerAuthenticationProvider.this.map;
                            synchronized (map) {
                                for (Map realmMap : SimpleServerAuthenticationProvider.this.map.values()) {
                                    if (!realmMap.containsKey(userName)) continue;
                                    entry = (Entry)realmMap.get(userName);
                                    break;
                                }
                            }
                        }
                        map = SimpleServerAuthenticationProvider.this.map;
                        synchronized (map) {
                            Map realmMap = (Map)SimpleServerAuthenticationProvider.this.map.get(realmName);
                            if (realmMap != null) {
                                entry = (Entry)realmMap.get(userName);
                            }
                        }
                        if (entry == null) {
                            throw new AuthenticationException("No matching user found");
                        }
                        passwordCallback.setPassword(entry.getPassword());
                        continue;
                    }
                    if (callback instanceof AuthorizeCallback) {
                        AuthorizeCallback authorizeCallback = (AuthorizeCallback)callback;
                        authorizeCallback.setAuthorized(authorizeCallback.getAuthenticationID().equals(authorizeCallback.getAuthorizationID()));
                        continue;
                    }
                    throw new UnsupportedCallbackException(callback, "Callback not supported: " + callback);
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addUser(String userName, String userRealm, char[] password) {
        if (userName == null) {
            throw new IllegalArgumentException("userName is null");
        }
        if (userRealm == null) {
            throw new IllegalArgumentException("userRealm is null");
        }
        if (password == null) {
            throw new IllegalArgumentException("password is null");
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(ADD_USER_PERM);
        }
        String canonUserRealm = userRealm.toLowerCase().trim();
        String canonUserName = userName.toLowerCase().trim();
        Map<String, Map<String, Entry>> map = this.map;
        synchronized (map) {
            Map<String, Entry> realmMap = this.map.get(canonUserRealm);
            if (realmMap == null) {
                realmMap = new HashMap<String, Entry>();
                this.map.put(canonUserRealm, realmMap);
            }
            realmMap.put(canonUserName, new Entry(canonUserName, canonUserRealm, password));
        }
    }

    private static final class Entry {
        private final String userName;
        private final String userRealm;
        private final char[] password;

        private Entry(String userName, String userRealm, char[] password) {
            this.userName = userName;
            this.userRealm = userRealm;
            this.password = password;
        }

        String getUserName() {
            return this.userName;
        }

        String getUserRealm() {
            return this.userRealm;
        }

        char[] getPassword() {
            return this.password;
        }
    }
}

