/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system.server.profileservice.persistence;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.jboss.logging.Logger;
import org.jboss.system.server.profileservice.repository.AbstractFileAttachmentsSerializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JAXBAttachmentSerializer
extends AbstractFileAttachmentsSerializer {
    private static final Logger log = Logger.getLogger(JAXBAttachmentSerializer.class);
    private static final String ATTACHMENT_SUFFIX = ".attachment.xml";

    public JAXBAttachmentSerializer(File dir) {
        super(dir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected <T> T loadAttachment(File attachmentsStore, Class<T> expected) throws Exception {
        if (log.isTraceEnabled()) {
            log.trace((Object)("loadAttachment, attachmentsStore=" + attachmentsStore));
        }
        JAXBContext ctx = JAXBContext.newInstance((Class[])new Class[]{expected});
        Unmarshaller unmarshaller = ctx.createUnmarshaller();
        FileInputStream is = new FileInputStream(attachmentsStore);
        try {
            Object object = unmarshaller.unmarshal((InputStream)is);
            return (T)object;
        }
        finally {
            ((InputStream)is).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void saveAttachment(File attachmentsStore, Object attachment) throws Exception {
        if (log.isTraceEnabled()) {
            log.trace((Object)("saveAttachment, attachmentsStore=" + attachmentsStore + ", attachment=" + attachment));
        }
        JAXBContext ctx = JAXBContext.newInstance((Class[])new Class[]{attachment.getClass()});
        Marshaller marshaller = ctx.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        FileOutputStream os = new FileOutputStream(attachmentsStore);
        try {
            marshaller.marshal(attachment, (OutputStream)os);
        }
        finally {
            ((OutputStream)os).close();
        }
    }

    @Override
    protected File getAttachmentPath(String baseName) {
        String vfsPath = baseName + ATTACHMENT_SUFFIX;
        return new File(this.getAttachmentsStoreDir(), vfsPath);
    }
}

