/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system.server.profileservice.repository.clustered.local.file;

import java.io.File;
import java.io.IOException;
import org.jboss.logging.Logger;
import org.jboss.system.server.profileservice.repository.clustered.local.file.FileBasedSynchronizationActionContext;
import org.jboss.system.server.profileservice.repository.clustered.local.file.FileUtil;
import org.jboss.system.server.profileservice.repository.clustered.sync.AbstractContentMetadataMutatorAction;
import org.jboss.system.server.profileservice.repository.clustered.sync.ContentModification;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractLocalContentChangeAction
extends AbstractContentMetadataMutatorAction<FileBasedSynchronizationActionContext> {
    private final File targetFile;
    private final boolean targetWasDir;
    private final boolean targetExists;
    private final long targetTimestamp;
    private File tempRollback;

    protected AbstractLocalContentChangeAction(File targetFile, FileBasedSynchronizationActionContext context, ContentModification modification) {
        super(context, modification);
        if (targetFile == null) {
            throw new IllegalArgumentException("Null targetFile");
        }
        this.targetFile = targetFile;
        this.targetWasDir = targetFile.isDirectory();
        this.targetExists = targetFile.exists();
        this.targetTimestamp = targetFile.lastModified();
    }

    protected abstract Logger getLogger();

    protected abstract boolean modifyTarget() throws IOException;

    protected File getTargetFile() {
        return this.targetFile;
    }

    @Override
    protected void doCancel() {
        this.safeCleanup();
    }

    @Override
    protected void doComplete() throws Exception {
        if (this.getLogger().isTraceEnabled()) {
            ContentModification mod = this.getRepositoryContentModification();
            this.getLogger().trace((Object)("doComplete(): " + (Object)((Object)mod.getType()) + " for " + mod.getItem().getRelativePath()));
        }
    }

    @Override
    protected boolean doPrepare() {
        File backup = null;
        try {
            if (this.targetExists) {
                if (!this.targetWasDir) {
                    backup = this.createTempFile();
                    FileUtil.localMove(this.targetFile, backup, this.targetTimestamp);
                    this.tempRollback = backup;
                } else {
                    this.targetFile.delete();
                }
            }
            boolean result = this.modifyTarget();
            if (this.getLogger().isTraceEnabled()) {
                ContentModification mod = this.getRepositoryContentModification();
                this.getLogger().trace((Object)("doPrepare(): modifyTarget result for " + (Object)((Object)mod.getType()) + " for " + mod.getItem().getRelativePath() + " is " + result));
            }
            return result;
        }
        catch (Exception e) {
            this.getLogger().error((Object)"Caught exception in doPrepare() ", (Throwable)e);
            if (backup != null && this.tempRollback == null) {
                backup.delete();
            }
            return false;
        }
    }

    @Override
    protected void doRollbackFromCancelled() {
    }

    @Override
    protected void doRollbackFromComplete() {
        this.safeCleanup();
    }

    @Override
    protected void doRollbackFromOpen() {
        this.safeCleanup();
    }

    @Override
    protected void doRollbackFromPrepared() {
        boolean cleanRollback = true;
        this.rollbackContentMetadata();
        if (this.targetWasDir) {
            this.targetFile.delete();
            this.targetFile.mkdirs();
            this.targetFile.setLastModified(this.targetTimestamp);
        } else if (this.targetExists) {
            try {
                FileUtil.localMove(this.tempRollback, this.targetFile, this.targetTimestamp);
            }
            catch (IOException e) {
                this.getLogger().error((Object)("Failed restoring " + this.targetFile + " during rollback. " + "Backup copy is stored in " + this.tempRollback), (Throwable)e);
                cleanRollback = false;
            }
        } else {
            this.targetFile.delete();
        }
        this.safeCleanup(cleanRollback);
    }

    @Override
    protected void doRollbackFromRollbackOnly() {
        boolean cleanRollback = true;
        if (this.tempRollback != null && this.tempRollback.exists()) {
            try {
                FileUtil.localMove(this.tempRollback, this.targetFile, this.targetTimestamp);
            }
            catch (IOException e) {
                this.getLogger().error((Object)("Failed restoring " + this.targetFile + " during rollback. " + "Backup copy is stored in " + this.tempRollback), (Throwable)e);
                cleanRollback = false;
            }
        } else if (this.targetWasDir) {
            if (this.targetFile.exists()) {
                if (!this.targetFile.isDirectory()) {
                    this.targetFile.delete();
                    this.targetFile.mkdirs();
                    this.targetFile.setLastModified(this.targetTimestamp);
                }
            } else {
                this.targetFile.mkdirs();
                this.targetFile.setLastModified(this.targetTimestamp);
            }
        } else if (!this.targetExists) {
            this.targetFile.delete();
        }
        this.safeCleanup(cleanRollback);
    }

    @Override
    protected void doCommit() {
        this.updateContentMetadata();
        this.safeCleanup();
    }

    protected File createTempFile() throws IOException {
        FileBasedSynchronizationActionContext ctx = (FileBasedSynchronizationActionContext)this.getContext();
        File f = FileUtil.createTempFile(ctx.getTempDir(), ctx.getStoreName());
        f.deleteOnExit();
        return f;
    }

    protected synchronized void safeCleanup(boolean cleanRollback) {
        if (cleanRollback && this.tempRollback != null) {
            this.tempRollback.delete();
        }
    }

    protected void safeCleanup() {
        this.safeCleanup(true);
    }
}

