/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.integration.deployer.env.bda;

import java.net.URL;
import java.util.Collection;
import org.jboss.weld.bootstrap.api.Bootstrap;
import org.jboss.weld.bootstrap.api.ServiceRegistry;
import org.jboss.weld.bootstrap.spi.BeanDeploymentArchive;
import org.jboss.weld.bootstrap.spi.BeansXml;
import org.jboss.weld.ejb.spi.EjbDescriptor;
import org.jboss.weld.integration.deployer.env.bda.Archive;
import org.jboss.weld.xml.BeansXmlParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BeanDeploymentArchiveImpl
implements BeanDeploymentArchive {
    private static final BeansXmlParser parser = new BeansXmlParser();
    private final String id;
    private final Archive archive;
    private final Bootstrap bootstrap;
    private final ServiceRegistry services;

    public BeanDeploymentArchiveImpl(String id, Bootstrap bootstrap, ServiceRegistry services, Archive archive) {
        if (id == null) {
            throw new IllegalArgumentException("Null id");
        }
        if (archive == null) {
            throw new IllegalArgumentException("Null archive");
        }
        if (services == null) {
            throw new IllegalArgumentException("Null services");
        }
        this.id = id;
        this.bootstrap = bootstrap;
        this.services = services;
        this.archive = archive;
    }

    public Collection<BeanDeploymentArchive> getBeanDeploymentArchives() {
        return this.archive.getClasspath().getBDAs(this);
    }

    public Collection<String> getBeanClasses() {
        return this.archive.getClasses();
    }

    public BeansXml getBeansXml() {
        Collection<URL> urls = this.archive.getXmlURLs();
        if (urls == null || urls.isEmpty()) {
            return BeansXml.EMPTY_BEANS_XML;
        }
        if (this.bootstrap != null) {
            return this.bootstrap.parse(urls);
        }
        return parser.parse(urls);
    }

    public Collection<EjbDescriptor<?>> getEjbs() {
        return this.archive.getEjbs();
    }

    public ServiceRegistry getServices() {
        return this.services;
    }

    public String getId() {
        return this.id;
    }

    public Archive getArchive() {
        return this.archive;
    }

    public String toString() {
        return this.archive.toString();
    }
}

