/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.integration.microcontainer.deployers;

import java.net.MalformedURLException;
import java.net.URL;
import org.jboss.deployers.vfs.plugins.classloader.PathUrlIntegrationDeployer;
import org.jboss.seam.integration.microcontainer.deployers.SeamConstants;
import org.jboss.util.StringPropertyReplacer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SeamUrlIntegrationDeployer<T>
extends PathUrlIntegrationDeployer<T> {
    protected SeamUrlIntegrationDeployer(Class<T> input) {
        super(input);
        this.setIntegrationURL(this.getURL());
        this.setFiles(SeamConstants.SEAM_FILES);
    }

    protected URL getURL() {
        try {
            String url = this.getServerHome() + this.getOptionalLib() + this.getIntegrationJar();
            url = StringPropertyReplacer.replaceProperties((String)url);
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Seam integration url: " + url));
            }
            return new URL(url);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Unexpected error: " + e);
        }
    }

    protected String getServerHome() {
        return "${jboss.server.home.url}";
    }

    protected String getOptionalLib() {
        return "deployers/seam.deployer/lib-int/";
    }

    protected String getIntegrationJar() {
        return "jboss-seam-int-jbossas.jar";
    }
}

