/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata.serviceref;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.jws.HandlerChain;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.Referenceable;
import javax.xml.namespace.QName;
import javax.xml.ws.Service;
import javax.xml.ws.WebServiceRef;
import javax.xml.ws.WebServiceRefs;
import javax.xml.ws.soap.MTOM;
import org.jboss.logging.Logger;
import org.jboss.metadata.javaee.jboss.CallPropertyMetaData;
import org.jboss.metadata.javaee.jboss.JBossPortComponentRef;
import org.jboss.metadata.javaee.jboss.JBossServiceReferenceMetaData;
import org.jboss.metadata.javaee.jboss.StubPropertyMetaData;
import org.jboss.metadata.javaee.spec.Addressing;
import org.jboss.metadata.javaee.spec.ParamValueMetaData;
import org.jboss.metadata.javaee.spec.PortComponentRef;
import org.jboss.metadata.javaee.spec.ResourceInjectionTargetMetaData;
import org.jboss.metadata.javaee.spec.RespectBinding;
import org.jboss.metadata.javaee.spec.ServiceReferenceHandlerChainMetaData;
import org.jboss.metadata.javaee.spec.ServiceReferenceHandlerChainsMetaData;
import org.jboss.metadata.javaee.spec.ServiceReferenceHandlerMetaData;
import org.jboss.metadata.javaee.spec.ServiceReferenceHandlersMetaData;
import org.jboss.metadata.javaee.spec.ServiceReferenceMetaData;
import org.jboss.util.naming.Util;
import org.jboss.wsf.spi.SPIProvider;
import org.jboss.wsf.spi.SPIProviderResolver;
import org.jboss.wsf.spi.deployment.UnifiedVirtualFile;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedCallPropertyMetaData;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedHandlerChainMetaData;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedHandlerChainsMetaData;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedHandlerMetaData;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedInitParamMetaData;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedPortComponentRefMetaData;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedServiceRefMetaData;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedStubPropertyMetaData;
import org.jboss.wsf.spi.serviceref.ServiceRefHandler;
import org.jboss.wsf.spi.serviceref.ServiceRefHandlerFactory;

@Deprecated
public final class ServiceReferenceHandler {
    private static final Logger log = Logger.getLogger(ServiceReferenceHandler.class);
    private ServiceRefHandler delegate;

    public ServiceReferenceHandler() {
        if (this.delegate == null) {
            SPIProvider spiProvider = SPIProviderResolver.getInstance().getProvider();
            this.delegate = ((ServiceRefHandlerFactory)spiProvider.getSPI(ServiceRefHandlerFactory.class)).getServiceRefHandler();
        }
    }

    public void bindServiceRef(Context encCtx, String encName, UnifiedVirtualFile vfsRoot, ClassLoader loader, ServiceReferenceMetaData sref) throws NamingException {
        if (!sref.isProcessed()) {
            UnifiedServiceRefMetaData spiRef = this.getUnifiedServiceRefMetaData(vfsRoot, sref, loader);
            this.processType(spiRef);
            Referenceable jndiReferenceable = this.delegate.createReferenceable(spiRef);
            String jndiFullName = encCtx.getNameInNamespace() + "/" + encName;
            log.info((Object)("Binding service reference to [jndi=" + jndiFullName + "]"));
            Util.bind((Context)encCtx, (String)encName, (Object)jndiReferenceable);
            sref.setProcessed(true);
        }
    }

    private void processAnnotatedElement(AnnotatedElement anElement, UnifiedServiceRefMetaData serviceRefMD) {
        this.processAddressingAnnotation(anElement, serviceRefMD);
        this.processMTOMAnnotation(anElement, serviceRefMD);
        this.processRespectBindingAnnotation(anElement, serviceRefMD);
        this.processHandlerChainAnnotation(anElement, serviceRefMD);
        this.processServiceRefType(anElement, serviceRefMD);
    }

    private void processType(UnifiedServiceRefMetaData serviceRefMD) {
        boolean isJAXRPC = serviceRefMD.getMappingFile() != null || "javax.xml.rpc.Service".equals(serviceRefMD.getServiceInterface());
        serviceRefMD.setType(isJAXRPC ? ServiceRefHandler.Type.JAXRPC : ServiceRefHandler.Type.JAXWS);
    }

    private UnifiedServiceRefMetaData getUnifiedServiceRefMetaData(UnifiedVirtualFile vfsRoot, ServiceReferenceMetaData sref, ClassLoader loader) {
        ServiceReferenceHandlerChainsMetaData serviceReferenceHandlerChainsMetaData;
        ServiceReferenceHandlersMetaData srHandlers;
        List<? extends PortComponentRef> pcRefs;
        UnifiedServiceRefMetaData result = new UnifiedServiceRefMetaData(vfsRoot);
        result.setServiceRefName(sref.getName());
        result.setServiceRefType(sref.getServiceRefType());
        result.setServiceInterface(sref.getServiceInterface());
        result.setWsdlFile(sref.getWsdlFile());
        result.setMappingFile(sref.getJaxrpcMappingFile());
        result.setServiceQName(sref.getServiceQname());
        result.setAddressingAnnotationSpecified(sref.isAddressingAnnotationSpecified());
        result.setAddressingEnabled(sref.isAddressingEnabled());
        result.setAddressingRequired(sref.isAddressingRequired());
        result.setAddressingResponses(sref.getAddressingResponses());
        result.setMtomAnnotationSpecified(sref.isMtomAnnotationSpecified());
        result.setMtomEnabled(sref.isMtomEnabled());
        result.setMtomThreshold(sref.getMtomThreshold());
        result.setRespectBindingAnnotationSpecified(sref.isRespectBindingAnnotationSpecified());
        result.setRespectBindingEnabled(sref.isRespectBindingEnabled());
        result.setHandlerChain(sref.getHandlerChain());
        if (sref.getInjectionTargets() != null && sref.getInjectionTargets().size() > 0) {
            if (sref.getInjectionTargets().size() > 1) {
                throw new UnsupportedOperationException("What to do in such case?");
            }
            ResourceInjectionTargetMetaData injectionTarget = sref.getInjectionTargets().iterator().next();
            AccessibleObject anAlement = this.findInjectionTarget(loader, injectionTarget);
            this.processAnnotatedElement(anAlement, result);
        }
        if ((pcRefs = sref.getPortComponentRef()) != null) {
            for (PortComponentRef portComponentRef : pcRefs) {
                UnifiedPortComponentRefMetaData upcRef = this.getUnifiedPortComponentRefMetaData(result, portComponentRef);
                if (upcRef.getServiceEndpointInterface() != null || upcRef.getPortQName() != null) {
                    result.addPortComponentRef(upcRef);
                    continue;
                }
                log.warn((Object)("Ignore <port-component-ref> without <service-endpoint-interface> and <port-qname>: " + upcRef));
            }
        }
        if ((srHandlers = sref.getHandlers()) != null) {
            for (ServiceReferenceHandlerMetaData srHandlerMetaData : srHandlers) {
                UnifiedHandlerMetaData uHandlerMetaData = this.getUnifiedHandlerMetaData(srHandlerMetaData);
                result.addHandler(uHandlerMetaData);
            }
        }
        if ((serviceReferenceHandlerChainsMetaData = sref.getHandlerChains()) != null) {
            UnifiedHandlerChainsMetaData uHandlerChains = new UnifiedHandlerChainsMetaData();
            List<ServiceReferenceHandlerChainMetaData> srHandlerChainList = serviceReferenceHandlerChainsMetaData.getHandlers();
            for (ServiceReferenceHandlerChainMetaData srHandlerChain : srHandlerChainList) {
                UnifiedHandlerChainMetaData uHandlerChain = new UnifiedHandlerChainMetaData();
                uHandlerChain.setServiceNamePattern(srHandlerChain.getServiceNamePattern());
                uHandlerChain.setPortNamePattern(srHandlerChain.getPortNamePattern());
                uHandlerChain.setProtocolBindings(srHandlerChain.getProtocolBindings());
                List<ServiceReferenceHandlerMetaData> srHandlerChainHandlers = srHandlerChain.getHandler();
                for (ServiceReferenceHandlerMetaData srHandlerMetaData : srHandlerChainHandlers) {
                    UnifiedHandlerMetaData uHandlerMetaData = this.getUnifiedHandlerMetaData(srHandlerMetaData);
                    uHandlerChain.addHandler(uHandlerMetaData);
                }
                uHandlerChains.addHandlerChain(uHandlerChain);
            }
            result.setHandlerChains(uHandlerChains);
        }
        if (sref instanceof JBossServiceReferenceMetaData) {
            JBossServiceReferenceMetaData jbRef = (JBossServiceReferenceMetaData)sref;
            if (jbRef.getServiceClass() != null) {
                result.setServiceImplClass(jbRef.getServiceClass());
            }
            result.setConfigName(jbRef.getConfigName());
            result.setConfigFile(jbRef.getConfigFile());
            result.setWsdlOverride(jbRef.getWsdlOverride());
            result.setHandlerChain(jbRef.getHandlerChain());
        }
        return result;
    }

    private UnifiedHandlerMetaData getUnifiedHandlerMetaData(ServiceReferenceHandlerMetaData srhmd) {
        List<String> portNames;
        List<String> soapRoles;
        List<QName> soapHeaders;
        UnifiedHandlerMetaData uhmd = new UnifiedHandlerMetaData();
        uhmd.setHandlerName(srhmd.getHandlerName());
        uhmd.setHandlerClass(srhmd.getHandlerClass());
        List<ParamValueMetaData> initParams = srhmd.getInitParam();
        if (initParams != null) {
            for (ParamValueMetaData initParam : initParams) {
                UnifiedInitParamMetaData param = new UnifiedInitParamMetaData();
                param.setParamName(initParam.getParamName());
                param.setParamValue(initParam.getParamValue());
                uhmd.addInitParam(param);
            }
        }
        if ((soapHeaders = srhmd.getSoapHeader()) != null) {
            for (QName soapHeader : soapHeaders) {
                uhmd.addSoapHeader(soapHeader);
            }
        }
        if ((soapRoles = srhmd.getSoapRole()) != null) {
            for (String soapRole : soapRoles) {
                uhmd.addSoapRole(soapRole);
            }
        }
        if ((portNames = srhmd.getPortName()) != null) {
            for (String portName : portNames) {
                uhmd.addPortName(portName);
            }
        }
        return uhmd;
    }

    private UnifiedPortComponentRefMetaData getUnifiedPortComponentRefMetaData(UnifiedServiceRefMetaData usref, PortComponentRef pcref) {
        RespectBinding respectBinding;
        UnifiedPortComponentRefMetaData result = new UnifiedPortComponentRefMetaData(usref);
        result.setServiceEndpointInterface(pcref.getServiceEndpointInterface());
        result.setMtomEnabled(pcref.isEnableMtom());
        result.setMtomThreshold(pcref.getMtomThreshold());
        Addressing addressing = pcref.getAddressing();
        if (addressing != null) {
            result.setAddressingEnabled(addressing.isEnabled());
            result.setAddressingRequired(addressing.isRequired());
            result.setAddressingResponses(addressing.getResponses());
        }
        if ((respectBinding = pcref.getRespectBinding()) != null) {
            result.setRespectBindingEnabled(respectBinding.isEnabled());
        }
        result.setPortComponentLink(pcref.getPortComponentLink());
        if (pcref instanceof JBossPortComponentRef) {
            List<CallPropertyMetaData> callProps;
            JBossPortComponentRef jbpcref = (JBossPortComponentRef)pcref;
            result.setPortQName(jbpcref.getPortQname());
            result.setConfigName(jbpcref.getConfigName());
            result.setConfigFile(jbpcref.getConfigFile());
            List<StubPropertyMetaData> stubProps = jbpcref.getStubProperties();
            if (stubProps != null) {
                for (StubPropertyMetaData stubProp : stubProps) {
                    UnifiedStubPropertyMetaData prop = new UnifiedStubPropertyMetaData();
                    prop.setPropName(stubProp.getPropName());
                    prop.setPropValue(stubProp.getPropValue());
                    result.addStubProperty(prop);
                }
            }
            if ((callProps = jbpcref.getCallProperties()) != null) {
                for (CallPropertyMetaData callProp : callProps) {
                    UnifiedCallPropertyMetaData prop = new UnifiedCallPropertyMetaData();
                    prop.setPropName(callProp.getPropName());
                    prop.setPropValue(callProp.getPropValue());
                    result.addCallProperty(prop);
                }
            }
        }
        return result;
    }

    private void processAddressingAnnotation(AnnotatedElement anElement, UnifiedServiceRefMetaData serviceRefMD) {
        javax.xml.ws.soap.Addressing addressingAnnotation = this.getAnnotation(anElement, javax.xml.ws.soap.Addressing.class);
        if (addressingAnnotation != null) {
            serviceRefMD.setAddressingAnnotationSpecified(true);
            serviceRefMD.setAddressingEnabled(addressingAnnotation.enabled());
            serviceRefMD.setAddressingRequired(addressingAnnotation.required());
            serviceRefMD.setAddressingResponses(addressingAnnotation.responses().toString());
        }
    }

    private void processMTOMAnnotation(AnnotatedElement anElement, UnifiedServiceRefMetaData serviceRefMD) {
        MTOM mtomAnnotation = this.getAnnotation(anElement, MTOM.class);
        if (mtomAnnotation != null) {
            serviceRefMD.setMtomAnnotationSpecified(true);
            serviceRefMD.setMtomEnabled(mtomAnnotation.enabled());
            serviceRefMD.setMtomThreshold(mtomAnnotation.threshold());
        }
    }

    private void processRespectBindingAnnotation(AnnotatedElement anElement, UnifiedServiceRefMetaData serviceRefMD) {
        javax.xml.ws.RespectBinding respectBindingAnnotation = this.getAnnotation(anElement, javax.xml.ws.RespectBinding.class);
        if (respectBindingAnnotation != null) {
            serviceRefMD.setRespectBindingAnnotationSpecified(true);
            serviceRefMD.setRespectBindingEnabled(respectBindingAnnotation.enabled());
        }
    }

    private void processServiceRefType(AnnotatedElement anElement, UnifiedServiceRefMetaData serviceRefMD) {
        if (anElement instanceof Field) {
            Class<?> targetClass = ((Field)anElement).getType();
            serviceRefMD.setServiceRefType(targetClass.getName());
            if (Service.class.isAssignableFrom(targetClass)) {
                serviceRefMD.setServiceInterface(targetClass.getName());
            }
        } else if (anElement instanceof Method) {
            Class<?> targetClass = ((Method)anElement).getParameterTypes()[0];
            serviceRefMD.setServiceRefType(targetClass.getName());
            if (Service.class.isAssignableFrom(targetClass)) {
                serviceRefMD.setServiceInterface(targetClass.getName());
            }
        } else {
            WebServiceRef serviceRefAnnotation = this.getWebServiceRefAnnotation(anElement, serviceRefMD);
            Class targetClass = null;
            if (serviceRefAnnotation != null && serviceRefAnnotation.type() != Object.class) {
                targetClass = serviceRefAnnotation.type();
                serviceRefMD.setServiceRefType(targetClass.getName());
                if (Service.class.isAssignableFrom(targetClass)) {
                    serviceRefMD.setServiceInterface(targetClass.getName());
                }
            }
        }
    }

    private void processHandlerChainAnnotation(AnnotatedElement anElement, UnifiedServiceRefMetaData serviceRefMD) {
        HandlerChain handlerChainAnnotation = this.getAnnotation(anElement, HandlerChain.class);
        if (handlerChainAnnotation != null) {
            String handlerChain = null;
            if (handlerChainAnnotation.file().length() > 0) {
                handlerChain = handlerChainAnnotation.file();
            }
            if (handlerChain != null) {
                try {
                    new URL(handlerChain);
                }
                catch (MalformedURLException ignored) {
                    Class<?> declaringClass = this.getDeclaringClass(anElement);
                    handlerChain = declaringClass.getPackage().getName().replace('.', '/') + "/" + handlerChain;
                }
                serviceRefMD.setHandlerChain(handlerChain);
            }
        }
    }

    private Class<?> getDeclaringClass(AnnotatedElement annotatedElement) {
        Class declaringClass = null;
        if (annotatedElement instanceof Field) {
            declaringClass = ((Field)annotatedElement).getDeclaringClass();
        } else if (annotatedElement instanceof Method) {
            declaringClass = ((Method)annotatedElement).getDeclaringClass();
        } else if (annotatedElement instanceof Class) {
            declaringClass = (Class)annotatedElement;
        }
        return declaringClass;
    }

    private <T extends Annotation> T getAnnotation(AnnotatedElement anElement, Class<T> annotationClass) {
        return anElement != null ? (T)anElement.getAnnotation(annotationClass) : null;
    }

    private WebServiceRef getWebServiceRefAnnotation(AnnotatedElement anElement, UnifiedServiceRefMetaData serviceRefMD) {
        WebServiceRef webServiceRefAnnotation = this.getAnnotation(anElement, WebServiceRef.class);
        WebServiceRefs webServiceRefsAnnotation = this.getAnnotation(anElement, WebServiceRefs.class);
        if (webServiceRefAnnotation == null && webServiceRefsAnnotation == null) {
            return null;
        }
        ArrayList<WebServiceRef> wsrefList = new ArrayList<WebServiceRef>();
        if (webServiceRefAnnotation != null) {
            wsrefList.add(webServiceRefAnnotation);
        }
        if (webServiceRefsAnnotation != null) {
            for (WebServiceRef webServiceRefAnn : webServiceRefsAnnotation.value()) {
                wsrefList.add(webServiceRefAnn);
            }
        }
        WebServiceRef returnValue = null;
        if (wsrefList.size() == 1) {
            returnValue = (WebServiceRef)wsrefList.get(0);
        } else {
            for (WebServiceRef webServiceRefAnn : wsrefList) {
                if (!serviceRefMD.getServiceRefName().endsWith(webServiceRefAnn.name())) continue;
                returnValue = webServiceRefAnn;
                break;
            }
        }
        return returnValue;
    }

    private AccessibleObject findInjectionTarget(ClassLoader loader, ResourceInjectionTargetMetaData target) {
        Class<?> clazz = null;
        try {
            clazz = loader.loadClass(target.getInjectionTargetClass());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("<injection-target> class: " + target.getInjectionTargetClass() + " was not found in deployment");
        }
        for (Field field : clazz.getDeclaredFields()) {
            if (!target.getInjectionTargetName().equals(field.getName())) continue;
            return field;
        }
        for (AccessibleObject accessibleObject : clazz.getDeclaredMethods()) {
            if (!((Method)accessibleObject).getName().equals(target.getInjectionTargetName())) continue;
            return accessibleObject;
        }
        throw new RuntimeException("<injection-target> could not be found: " + target.getInjectionTargetClass() + "." + target.getInjectionTargetName());
    }
}

