/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.config.parser;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.jboss.security.acl.config.ACLProviderEntry;
import org.jboss.security.config.ControlFlag;
import org.jboss.security.config.parser.ModuleOptionParser;
import org.jboss.security.config.parser.StaxParserUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AclConfigParser {
    public Set<ACLProviderEntry> parse(XMLEventReader xmlEventReader) throws XMLStreamException {
        LinkedHashSet<ACLProviderEntry> entries = new LinkedHashSet<ACLProviderEntry>();
        while (xmlEventReader.hasNext()) {
            XMLEvent xmlEvent = xmlEventReader.peek();
            StartElement peekedStartElement = (StartElement)xmlEvent;
            ACLProviderEntry entry = null;
            if (!"acl-module".equals(StaxParserUtil.getStartElementName(peekedStartElement))) break;
            entry = this.getEntry(xmlEventReader);
            entries.add(entry);
        }
        return entries;
    }

    private ACLProviderEntry getEntry(XMLEventReader xmlEventReader) throws XMLStreamException {
        XMLEvent xmlEvent = xmlEventReader.nextEvent();
        HashMap<String, Object> options = new HashMap<String, Object>();
        String codeName = null;
        ControlFlag controlFlag = ControlFlag.REQUIRED;
        StartElement policyModuleElement = (StartElement)xmlEvent;
        Iterator<Attribute> attrs = policyModuleElement.getAttributes();
        while (attrs.hasNext()) {
            Attribute attribute = attrs.next();
            QName attQName = attribute.getName();
            String attributeValue = StaxParserUtil.getAttributeValue(attribute);
            if ("code".equals(attQName.getLocalPart())) {
                codeName = attributeValue;
                continue;
            }
            if (!"flag".equals(attQName.getLocalPart())) continue;
            controlFlag = ControlFlag.valueOf((String)attributeValue);
        }
        ModuleOptionParser moParser = new ModuleOptionParser();
        options.putAll(moParser.parse(xmlEventReader));
        ACLProviderEntry entry = new ACLProviderEntry(codeName, options);
        entry.setControlFlag(controlFlag);
        return entry;
    }
}

