/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.mock;

import java.io.IOException;
import java.util.Locale;
import javax.faces.FacesException;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import org.jboss.seam.util.Strings;

public class MockViewHandler
extends ViewHandler {
    public Locale calculateLocale(FacesContext ctx) {
        return Locale.getDefault();
    }

    public String calculateRenderKitId(FacesContext ctx) {
        return null;
    }

    public UIViewRoot createView(FacesContext ctx, String viewId) {
        UIViewRoot viewRoot = new UIViewRoot();
        viewRoot.setViewId(viewId);
        return viewRoot;
    }

    public String getActionURL(FacesContext ctx, String viewId) {
        String contextPath = ctx.getExternalContext().getRequestContextPath();
        String pathInfo = ctx.getExternalContext().getRequestPathInfo();
        String servletPath = ctx.getExternalContext().getRequestServletPath();
        if (Strings.isEmpty(pathInfo)) {
            int sploc = servletPath.lastIndexOf(46);
            if (sploc < 0) {
                throw new IllegalArgumentException("no file extension in servlet path: " + servletPath);
            }
            return contextPath + MockViewHandler.getViewIdSansSuffix(viewId) + servletPath.substring(sploc);
        }
        return contextPath + viewId;
    }

    private static String getViewIdSansSuffix(String viewId) {
        int loc = viewId.lastIndexOf(46);
        if (loc < 0) {
            throw new IllegalArgumentException("no file extension in view id: " + viewId);
        }
        return viewId.substring(0, loc);
    }

    public String getResourceURL(FacesContext ctx, String url) {
        return url;
    }

    public void renderView(FacesContext ctx, UIViewRoot viewRoot) throws IOException, FacesException {
    }

    public UIViewRoot restoreView(FacesContext ctx, String id) {
        return null;
    }

    public void writeState(FacesContext ctx) throws IOException {
    }
}

