/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.security.management;

import java.security.MessageDigest;
import org.jboss.seam.Component;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.intercept.BypassInterceptors;
import org.jboss.seam.util.Base64;

@Scope(value=ScopeType.STATELESS)
@Name(value="org.jboss.seam.security.passwordHash")
@Install(precedence=0)
@BypassInterceptors
public class PasswordHash {
    public static final String ALGORITHM_MD5 = "MD5";
    public static final String ALGORITHM_SHA = "SHA";
    private static final String DEFAULT_ALGORITHM = "MD5";

    public String generateHash(String password) {
        return this.generateHash(password, "MD5");
    }

    public String generateHash(String password, String algorithm) {
        return this.generateSaltedHash(password, null, algorithm);
    }

    public String generateSaltedHash(String password, String saltPhrase) {
        return this.generateSaltedHash(password, saltPhrase, "MD5");
    }

    public String generateSaltedHash(String password, String saltPhrase, String algorithm) {
        try {
            MessageDigest md = MessageDigest.getInstance(algorithm);
            if (saltPhrase != null) {
                md.update(saltPhrase.getBytes());
                byte[] salt = md.digest();
                md.reset();
                md.update(password.getBytes());
                md.update(salt);
            } else {
                md.update(password.getBytes());
            }
            byte[] raw = md.digest();
            return Base64.encodeBytes(raw);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static PasswordHash instance() {
        return (PasswordHash)Component.getInstance(PasswordHash.class, ScopeType.STATELESS);
    }
}

