/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.blocks;

import java.io.NotSerializableException;
import org.jgroups.Channel;
import org.jgroups.blocks.RpcDispatcher;
import org.jgroups.tests.ChannelTestBase;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"stack-dependent"}, sequential=true)
public class RpcDispatcherExceptionTest
extends ChannelTestBase {
    RpcDispatcher disp;
    Channel channel;
    private final Target target = new Target();

    @BeforeClass
    public void setUp() throws Exception {
        this.channel = this.createChannel(true);
        this.disp = new RpcDispatcher(this.channel, null, null, this.target);
        this.channel.connect("RpcDispatcherExceptionTest");
    }

    @AfterClass
    public void tearDown() throws Exception {
        this.disp.stop();
        this.channel.close();
    }

    public void testUnserializableValue() {
        try {
            this.disp.callRemoteMethods(null, "foo", new Object[]{new Pojo()}, new Class[]{Pojo.class}, 2, 5000L);
            throw new IllegalStateException("this should have thrown an exception");
        }
        catch (Throwable t) {
            System.out.println("received an exception as expected: " + t);
            assert (t.getCause() instanceof NotSerializableException);
            return;
        }
    }

    @Test(expectedExceptions={NotSerializableException.class})
    public void testUnserializableValue2() throws Throwable {
        this.disp.callRemoteMethod(this.channel.getAddress(), "foo", new Object[]{new Pojo()}, new Class[]{Pojo.class}, 2, 5000L);
    }

    private static class Target {
        private Target() {
        }

        public static void foo(Pojo p) {
            System.out.println(p.toString());
        }
    }

    private static class Pojo {
        int age;
        String name;

        private Pojo() {
        }
    }
}

