/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import org.jgroups.Channel;
import org.jgroups.ChannelException;
import org.jgroups.JChannel;
import org.jgroups.MembershipListener;
import org.jgroups.View;
import org.jgroups.blocks.MembershipListenerAdapter;
import org.jgroups.blocks.RpcDispatcher;
import org.jgroups.util.Util;

public class UnicastStressTestRpc
extends MembershipListenerAdapter {
    JChannel ch;
    RpcDispatcher disp;
    String props = "udp.xml";
    int num_threads = 1;
    int msg_size = 1000;
    boolean async = true;
    double writes = 0.2;
    int num_owners = 2;
    static final String CLUSTER_NAME = "test-cluster";
    private String logical_name = null;

    public UnicastStressTestRpc(String props, int num_threads, int msg_size, boolean async, double writes, int num_owners, String logical_name) {
        this.props = props;
        this.num_threads = num_threads;
        this.msg_size = msg_size;
        this.async = async;
        this.writes = writes;
        this.num_owners = num_owners;
        this.logical_name = logical_name;
    }

    private void start() throws ChannelException {
        this.ch = new JChannel(this.props);
        if (this.logical_name != null) {
            this.ch.setName(this.logical_name);
        }
        this.disp = new RpcDispatcher((Channel)this.ch, null, (MembershipListener)this, (Object)this);
        this.loop();
        this.ch.close();
    }

    @Override
    public void viewAccepted(View new_view) {
        System.out.println("- new view: " + new_view);
    }

    private void loop() {
        while (true) {
            int c = Util.keyPress("[1] start [2] stop [q] quit");
            switch (c) {
                case 49: {
                    break;
                }
                case 50: {
                    break;
                }
                case 113: {
                    return;
                }
            }
        }
    }

    public static void main(String[] args) throws ChannelException {
        String props = "udp.xml";
        int num_threads = 1;
        int msg_size = 1000;
        boolean async = true;
        double writes = 0.2;
        int num_owners = 2;
        String logical_name = null;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-props")) {
                props = args[++i];
                continue;
            }
            if (args[i].equals("-num_threads")) {
                num_threads = Integer.parseInt(args[++i]);
                continue;
            }
            if (args[i].equals("-msg_size")) {
                msg_size = Integer.parseInt(args[++i]);
                continue;
            }
            if (args[i].equals("-async")) {
                async = Boolean.valueOf(args[++i]);
                continue;
            }
            if (args[i].equals("-writes")) {
                writes = Double.parseDouble(args[++i]);
                continue;
            }
            if (args[i].equals("-num_owners")) {
                num_owners = Integer.parseInt(args[++i]);
                continue;
            }
            if (args[i].equals("-name")) {
                logical_name = args[++i];
                continue;
            }
            UnicastStressTestRpc.help();
            return;
        }
        UnicastStressTestRpc test = new UnicastStressTestRpc(props, num_threads, msg_size, async, writes, num_owners, logical_name);
        test.start();
    }

    static void help() {
        System.out.println("UnicastStressTestRpc [-props config] [-num_threads <number of threads>] [-msg_size <bytes>] [-async <true | false>] [-writes <percentage of writes>] [-name <logical name>]");
    }
}

