/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.embedded.core.deployable;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.jboss.embedded.api.Deployable;
import org.jboss.embedded.core.deployable.DeployableUrl;

public final class DeployableFile
implements Deployable {
    private final File file;
    private final Deployable delegate;

    public DeployableFile(File file) throws IllegalArgumentException {
        URL url;
        if (file == null) {
            throw new IllegalArgumentException("file must be specified");
        }
        if (!file.exists()) {
            throw new IllegalArgumentException("file does not exist: " + file.getAbsolutePath());
        }
        try {
            url = file.toURI().toURL();
        }
        catch (MalformedURLException murle) {
            throw new IllegalArgumentException("URL of file is in improper form", murle);
        }
        DeployableUrl delegate = new DeployableUrl(url);
        this.file = file;
        this.delegate = delegate;
    }

    public URL getTarget() {
        return this.delegate.getTarget();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.file == null ? 0 : this.file.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DeployableFile other = (DeployableFile)obj;
        return !(this.file == null ? other.file != null : !this.file.equals(other.file));
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [file=" + this.file + "]";
    }
}

