/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.embedded.core.server;

import java.io.File;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jboss.bootstrap.api.as.config.JBossASServerConfig;
import org.jboss.bootstrap.api.config.InvalidConfigurationException;
import org.jboss.bootstrap.api.lifecycle.LifecycleEventException;
import org.jboss.bootstrap.api.lifecycle.LifecycleState;
import org.jboss.bootstrap.impl.as.config.BasicJBossASServerConfig;
import org.jboss.bootstrap.impl.as.server.AbstractJBossASServerBase;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.deployers.client.spi.Deployment;
import org.jboss.deployers.client.spi.main.MainDeployer;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.vfs.spi.client.VFSDeployment;
import org.jboss.deployers.vfs.spi.client.VFSDeploymentFactory;
import org.jboss.embedded.api.Deployable;
import org.jboss.embedded.api.server.JBossASEmbeddedServer;
import org.jboss.embedded.core.deployable.DeployableArchive;
import org.jboss.embedded.core.deployable.DeployableFile;
import org.jboss.embedded.core.deployable.DeployableUrl;
import org.jboss.embedded.core.lifecycle.IgnoreXbUnorderedSequenceLifecycleEventHandler;
import org.jboss.embedded.core.lifecycle.InitLogManagerLevelsLifecycleEventHandler;
import org.jboss.embedded.core.lifecycle.InitLoggingManagerLifecycleEventHandler;
import org.jboss.embedded.core.lifecycle.NoXbRepeatableParticleHandlersLifecycleEventHandler;
import org.jboss.embedded.core.lifecycle.SetIPv4LifecycleEventHandler;
import org.jboss.embedded.core.lifecycle.SetRmiHostnameLifecycleEventHandler;
import org.jboss.embedded.core.server.SecurityActions;
import org.jboss.kernel.Kernel;
import org.jboss.kernel.spi.dependency.KernelController;
import org.jboss.logging.Logger;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.vfs.VFS;
import org.jboss.vfs.VirtualFile;

public class JBossASEmbeddedServerImpl
extends AbstractJBossASServerBase<JBossASEmbeddedServer, JBossASServerConfig>
implements JBossASEmbeddedServer {
    private static final Logger log = Logger.getLogger(JBossASEmbeddedServerImpl.class);
    public static final String ENV_VAR_JBOSS_HOME = "JBOSS_HOME";
    public static final String SYS_PROP_JBOSS_HOME = "jboss.home";
    private static final String MC_NAME_MAIN_DEPLOYER = "MainDeployer";
    private final Map<Deployable, Deployment> deployed = new HashMap<Deployable, Deployment>();

    public JBossASEmbeddedServerImpl() throws IllegalStateException {
        super(JBossASEmbeddedServer.class);
    }

    public JBossASEmbeddedServerImpl(String jbossHome) throws IllegalArgumentException {
        super(JBossASEmbeddedServer.class);
        if (jbossHome == null || jbossHome.length() == 0) {
            throw new IllegalArgumentException("JBOSS_HOME must be specified");
        }
        SecurityActions.setJBossHomeSystemProperty(jbossHome);
    }

    protected Class<? extends JBossASServerConfig> getDefaultServerConfigClass() {
        return BasicJBossASServerConfig.class;
    }

    public void deploy(URL ... urls) throws org.jboss.embedded.api.DeploymentException, IllegalArgumentException {
        Collection<Deployable> deployables = this.asDeployables(urls);
        this.deploy(deployables);
    }

    public void deploy(File ... files) throws org.jboss.embedded.api.DeploymentException, IllegalArgumentException {
        Collection<Deployable> deployables = this.asDeployables(files);
        this.deploy(deployables);
    }

    public void deploy(Archive<?> ... archives) throws org.jboss.embedded.api.DeploymentException, IllegalArgumentException {
        Collection<Deployable> deployables = this.asDeployables(archives);
        this.deploy(deployables);
    }

    public synchronized void deploy(Deployable ... deployables) throws org.jboss.embedded.api.DeploymentException, IllegalArgumentException {
        if (deployables == null) {
            throw new IllegalArgumentException("deployables must not be null");
        }
        MainDeployer mainDeployer = this.getMainDeployer();
        HashMap<Deployable, VFSDeployment> deploymentsToBeAdded = new HashMap<Deployable, VFSDeployment>();
        for (Deployable deployable : deployables) {
            VirtualFile vf;
            if (this.deployed.containsKey(deployable)) {
                log.warn((Object)("Attempting to re-deploy " + deployable + "; ignoring."));
            }
            URL target = deployable.getTarget();
            try {
                vf = VFS.getChild((URL)target);
            }
            catch (URISyntaxException e) {
                throw new RuntimeException("Could not create new VFS root from " + target, e);
            }
            VFSDeployment deployment = VFSDeploymentFactory.getInstance().createVFSDeployment(vf);
            log.debug((Object)("Adding to " + mainDeployer + ": " + deployment));
            try {
                mainDeployer.addDeployment((Deployment)deployment);
                deploymentsToBeAdded.put(deployable, deployment);
            }
            catch (DeploymentException de) {
                org.jboss.embedded.api.DeploymentException wrappedException = new org.jboss.embedded.api.DeploymentException((Throwable)de);
                for (Map.Entry next : deploymentsToBeAdded.entrySet()) {
                    Deployable thisDeployable = (Deployable)next.getKey();
                    try {
                        mainDeployer.removeDeployment((Deployment)deploymentsToBeAdded.get(thisDeployable));
                    }
                    catch (DeploymentException e) {
                        log.warn((Object)("Atomic deployment of " + Arrays.asList(deployables) + " failed due to " + de.getMessage() + ", and we could not remove " + thisDeployable + " from further processing"));
                    }
                }
                throw wrappedException;
            }
            this.processAndCheckMainDeployer(mainDeployer);
            this.deployed.putAll(deploymentsToBeAdded);
        }
    }

    public void undeploy(Archive<?> ... archives) throws org.jboss.embedded.api.DeploymentException, IllegalArgumentException {
        Collection<Deployable> deployables = this.asDeployables(archives);
        this.undeploy(deployables);
    }

    public void undeploy(URL ... urls) throws org.jboss.embedded.api.DeploymentException, IllegalArgumentException {
        Collection<Deployable> deployables = this.asDeployables(urls);
        this.undeploy(deployables);
    }

    public void undeploy(File ... files) throws org.jboss.embedded.api.DeploymentException, IllegalArgumentException {
        Collection<Deployable> deployables = this.asDeployables(files);
        this.undeploy(deployables);
    }

    public synchronized void undeploy(Deployable ... deployables) throws org.jboss.embedded.api.DeploymentException, IllegalArgumentException {
        if (deployables == null || deployables.length == 0) {
            throw new IllegalArgumentException("At least one deployable must be specified");
        }
        MainDeployer mainDeployer = this.getMainDeployer();
        ArrayList<Deployable> deployablesToRemove = new ArrayList<Deployable>();
        for (Deployable deployable : deployables) {
            Deployment deployment = this.deployed.get(deployable);
            if (deployment == null) {
                log.warn((Object)("Specified deployable " + deployable + " cannot be undeployed because it is not deployed."));
                continue;
            }
            try {
                mainDeployer.removeDeployment(deployment);
            }
            catch (DeploymentException de) {
                throw new org.jboss.embedded.api.DeploymentException((Throwable)de);
            }
            deployablesToRemove.add(deployable);
        }
        this.processAndCheckMainDeployer(mainDeployer);
        for (Deployable deployable : deployablesToRemove) {
            this.deployed.remove(deployable);
        }
    }

    protected void doInitialize() throws IllegalStateException, InvalidConfigurationException, LifecycleEventException {
        super.doInitialize();
        IgnoreXbUnorderedSequenceLifecycleEventHandler ignoreXbOrder = new IgnoreXbUnorderedSequenceLifecycleEventHandler();
        this.registerEventHandler(LifecycleState.INITIALIZED, ignoreXbOrder);
        SetRmiHostnameLifecycleEventHandler setRmiHostname = new SetRmiHostnameLifecycleEventHandler();
        this.registerEventHandler(LifecycleState.INITIALIZED, setRmiHostname);
        InitLoggingManagerLifecycleEventHandler initLoggingManager = new InitLoggingManagerLifecycleEventHandler();
        this.registerEventHandler(LifecycleState.INITIALIZED, initLoggingManager);
        SetIPv4LifecycleEventHandler ipv4Handler = new SetIPv4LifecycleEventHandler();
        this.registerEventHandler(LifecycleState.INITIALIZED, ipv4Handler);
        NoXbRepeatableParticleHandlersLifecycleEventHandler repeatableParticleHandlers = new NoXbRepeatableParticleHandlersLifecycleEventHandler();
        this.registerEventHandler(LifecycleState.INITIALIZED, repeatableParticleHandlers);
        this.registerEventHandler(InitLogManagerLevelsLifecycleEventHandler.INSTANCE, new LifecycleState[]{LifecycleState.INITIALIZED});
    }

    private Collection<Deployable> asDeployables(URL ... urls) throws IllegalArgumentException {
        if (urls == null) {
            throw new IllegalArgumentException("urls must not be null");
        }
        ArrayList<Deployable> deployables = new ArrayList<Deployable>(urls.length);
        for (URL url : urls) {
            DeployableUrl deployable = new DeployableUrl(url);
            deployables.add(deployable);
        }
        return deployables;
    }

    private Collection<Deployable> asDeployables(Archive<?> ... archives) throws IllegalArgumentException {
        if (archives == null) {
            throw new IllegalArgumentException("archives must not be null");
        }
        ArrayList<Deployable> deployables = new ArrayList<Deployable>(archives.length);
        for (Archive<?> archive : archives) {
            DeployableArchive deployable = new DeployableArchive(archive);
            deployables.add(deployable);
        }
        return deployables;
    }

    private Collection<Deployable> asDeployables(File ... files) throws IllegalArgumentException {
        if (files == null) {
            throw new IllegalArgumentException("files must not be null");
        }
        ArrayList<Deployable> deployables = new ArrayList<Deployable>(files.length);
        for (File file : files) {
            DeployableFile deployable = new DeployableFile(file);
            deployables.add(deployable);
        }
        return deployables;
    }

    private void deploy(Collection<Deployable> deployables) throws org.jboss.embedded.api.DeploymentException, IllegalArgumentException {
        Deployable[] deployablesArray = deployables.toArray(new Deployable[0]);
        this.deploy(deployablesArray);
    }

    private void undeploy(Collection<Deployable> deployables) throws org.jboss.embedded.api.DeploymentException, IllegalArgumentException {
        Deployable[] deployablesArray = deployables.toArray(new Deployable[0]);
        this.undeploy(deployablesArray);
    }

    @Deprecated
    protected final MainDeployer getMainDeployer() {
        Kernel kernel = this.getKernel();
        KernelController controller = kernel.getController();
        ControllerContext context = controller.getContext((Object)MC_NAME_MAIN_DEPLOYER, ControllerState.INSTALLED);
        if (context == null) {
            throw new IllegalStateException("Main deployer could not be found");
        }
        Object target = context.getTarget();
        MainDeployer mainDeployer = (MainDeployer)MainDeployer.class.cast(target);
        return mainDeployer;
    }

    @Deprecated
    private void processAndCheckMainDeployer(MainDeployer mainDeployer) throws org.jboss.embedded.api.DeploymentException, IllegalArgumentException {
        if (mainDeployer == null) {
            throw new IllegalArgumentException("mainDeployer must be specified");
        }
        log.debug((Object)("Processing: " + mainDeployer));
        mainDeployer.process();
        try {
            log.debug((Object)("Checking: " + mainDeployer));
            mainDeployer.checkComplete();
        }
        catch (DeploymentException de) {
            throw new org.jboss.embedded.api.DeploymentException((Throwable)de);
        }
    }
}

