/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logging.metadata;

import java.util.concurrent.ConcurrentMap;
import org.jboss.logmanager.LogContext;
import org.jboss.util.collection.ConcurrentReferenceHashMap;

public final class LogContextRegistry {
    private static final LogContextRegistry INSTANCE = new LogContextRegistry();
    private final ConcurrentMap<String, LogContext> map = new ConcurrentReferenceHashMap(ConcurrentReferenceHashMap.ReferenceType.STRONG, ConcurrentReferenceHashMap.ReferenceType.WEAK);

    private LogContextRegistry() {
        this.map.put("system", LogContext.getSystemLogContext());
    }

    public LogContext get(String name) throws IllegalArgumentException {
        LogContext context = (LogContext)this.map.get(name);
        if (context == null) {
            throw new IllegalArgumentException("No such log context '" + name + "'");
        }
        return context;
    }

    public LogContext getOrCreate(String name) {
        LogContext context = (LogContext)this.map.get(name);
        if (context == null) {
            LogContext created = LogContext.create();
            LogContext appearing = this.map.putIfAbsent(name, created);
            return appearing == null ? created : appearing;
        }
        return context;
    }

    public static LogContextRegistry getInstance() {
        return INSTANCE;
    }
}

