/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.negotiation;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.Principal;
import org.apache.catalina.Realm;
import org.apache.catalina.Session;
import org.apache.catalina.authenticator.AuthenticatorBase;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.deploy.LoginConfig;
import org.apache.log4j.Logger;
import org.jboss.security.negotiation.MessageFactory;
import org.jboss.security.negotiation.NegotiationException;
import org.jboss.security.negotiation.NegotiationMessage;
import org.jboss.security.negotiation.common.MessageTrace;
import org.jboss.security.negotiation.common.NegotiationContext;
import org.jboss.util.Base64;

public class NegotiationAuthenticator
extends AuthenticatorBase {
    private static final Logger log = Logger.getLogger(NegotiationAuthenticator.class);
    private static final String NEGOTIATE = "Negotiate";
    private static final String NEGOTIATION_CONTEXT = "NEGOTIATION_CONTEXT";

    protected String getNegotiateScheme() {
        return NEGOTIATE;
    }

    protected boolean authenticate(Request request, Response response, LoginConfig config) throws IOException {
        log.trace((Object)"Authenticating user");
        Principal principal = request.getUserPrincipal();
        if (principal != null) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("Already authenticated '" + principal.getName() + "'"));
            }
            return true;
        }
        String negotiateScheme = this.getNegotiateScheme();
        log.debug((Object)("Header - " + request.getHeader("Authorization")));
        String authHeader = request.getHeader("Authorization");
        if (authHeader == null) {
            log.debug((Object)"No Authorization Header, sending 401");
            response.setHeader("WWW-Authenticate", negotiateScheme);
            response.sendError(401);
            return false;
        }
        if (!authHeader.startsWith(negotiateScheme + " ")) {
            throw new IOException("Invalid 'Authorization' header.");
        }
        String authTokenBase64 = authHeader.substring(negotiateScheme.length() + 1);
        byte[] authToken = Base64.decode((String)authTokenBase64);
        ByteArrayInputStream authTokenIS = new ByteArrayInputStream(authToken);
        MessageTrace.logRequestBase64(authTokenBase64);
        MessageTrace.logRequestHex(authToken);
        Session session = request.getSessionInternal();
        NegotiationContext negotiationContext = (NegotiationContext)session.getNote(NEGOTIATION_CONTEXT);
        if (negotiationContext == null) {
            log.debug((Object)"Creating new NegotiationContext");
            negotiationContext = new NegotiationContext();
            session.setNote(NEGOTIATION_CONTEXT, (Object)negotiationContext);
        }
        String username = session.getId();
        String authenticationMethod = "";
        try {
            NegotiationMessage responseMessage;
            negotiationContext.associate();
            MessageFactory mf = MessageFactory.newInstance();
            if (!mf.accepts(authTokenIS)) {
                throw new IOException("Unsupported negotiation mechanism.");
            }
            NegotiationMessage requestMessage = mf.createMessage(authTokenIS);
            negotiationContext.setRequestMessage(requestMessage);
            Realm realm = this.context.getRealm();
            principal = realm.authenticate(username, (String)null);
            authenticationMethod = negotiationContext.getAuthenticationMethod();
            if (log.isDebugEnabled() && principal != null) {
                log.debug((Object)("authenticated principal = " + principal));
            }
            if ((responseMessage = negotiationContext.getResponseMessage()) != null) {
                ByteArrayOutputStream responseMessageOS = new ByteArrayOutputStream();
                responseMessage.writeTo(responseMessageOS, true);
                String responseHeader = responseMessageOS.toString();
                MessageTrace.logResponseBase64(responseHeader);
                response.setHeader("WWW-Authenticate", negotiateScheme + " " + responseHeader);
            }
        }
        catch (NegotiationException e) {
            IOException ioe = new IOException("Error processing " + negotiateScheme + " header.");
            ioe.initCause(e);
            throw ioe;
        }
        finally {
            negotiationContext.clear();
        }
        if (principal == null) {
            response.sendError(401);
        } else {
            this.register(request, response, principal, authenticationMethod, username, null);
        }
        return principal != null;
    }
}

