/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resource.adapter.jdbc;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jboss.resource.adapter.jdbc.JBossWrapper;
import org.jboss.resource.adapter.jdbc.StatementAccess;
import org.jboss.resource.adapter.jdbc.WrappedConnection;
import org.jboss.resource.adapter.jdbc.WrappedResultSet;

public abstract class WrappedStatement
extends JBossWrapper
implements Statement,
StatementAccess,
org.jboss.ejb.plugins.cmp.jdbc.WrappedStatement {
    private final WrappedConnection lc;
    private final Statement s;
    private HashMap<WrappedResultSet, Throwable> resultSets;
    private AtomicBoolean closed = new AtomicBoolean(false);

    public WrappedStatement(WrappedConnection lc, Statement s) {
        this.lc = lc;
        this.s = s;
        lc.registerStatement(this);
    }

    protected void lock() throws SQLException {
        this.lc.lock();
    }

    protected void unlock() {
        this.lc.unlock();
    }

    @Override
    public void close() throws SQLException {
        if (this.closed.get()) {
            return;
        }
        this.closed.set(true);
        this.lc.unregisterStatement(this);
        this.internalClose();
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        this.lock();
        try {
            this.checkTransaction();
            try {
                this.checkConfiguredQueryTimeout();
                boolean bl = this.s.execute(sql);
                return bl;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        this.lock();
        try {
            this.checkTransaction();
            try {
                this.checkConfiguredQueryTimeout();
                boolean bl = this.s.execute(sql, autoGeneratedKeys);
                return bl;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        this.lock();
        try {
            this.checkTransaction();
            try {
                this.checkConfiguredQueryTimeout();
                boolean bl = this.s.execute(sql, columnIndexes);
                return bl;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        this.lock();
        try {
            this.checkTransaction();
            try {
                this.checkConfiguredQueryTimeout();
                boolean bl = this.s.execute(sql, columnNames);
                return bl;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.lc;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.lock();
        try {
            this.checkState();
            try {
                SQLWarning sQLWarning = this.s.getWarnings();
                return sQLWarning;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearWarnings() throws SQLException {
        this.lock();
        try {
            this.checkState();
            try {
                this.s.clearWarnings();
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        this.lock();
        try {
            this.checkTransaction();
            try {
                this.checkConfiguredQueryTimeout();
                ResultSet result = this.s.executeQuery(sql);
                ResultSet resultSet = this.registerResultSet(result);
                return resultSet;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        this.lock();
        try {
            this.checkTransaction();
            try {
                this.checkConfiguredQueryTimeout();
                int n = this.s.executeUpdate(sql);
                return n;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        this.lock();
        try {
            this.checkTransaction();
            try {
                this.checkConfiguredQueryTimeout();
                int n = this.s.executeUpdate(sql, autoGeneratedKeys);
                return n;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        this.lock();
        try {
            this.checkTransaction();
            try {
                this.checkConfiguredQueryTimeout();
                int n = this.s.executeUpdate(sql, columnIndexes);
                return n;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        this.lock();
        try {
            this.checkTransaction();
            try {
                this.checkConfiguredQueryTimeout();
                int n = this.s.executeUpdate(sql, columnNames);
                return n;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        this.lock();
        try {
            this.checkState();
            try {
                int n = this.s.getMaxFieldSize();
                return n;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        this.lock();
        try {
            this.checkState();
            try {
                this.s.setMaxFieldSize(max);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public int getMaxRows() throws SQLException {
        this.lock();
        try {
            this.checkState();
            try {
                int n = this.s.getMaxRows();
                return n;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMaxRows(int max) throws SQLException {
        this.lock();
        try {
            this.checkState();
            try {
                this.s.setMaxRows(max);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.lock();
        try {
            this.checkState();
            try {
                this.s.setEscapeProcessing(enable);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        this.lock();
        try {
            this.checkState();
            try {
                int n = this.s.getQueryTimeout();
                return n;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setQueryTimeout(int timeout) throws SQLException {
        this.lock();
        try {
            this.checkState();
            try {
                this.s.setQueryTimeout(timeout);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public void cancel() throws SQLException {
        this.checkState();
        try {
            this.s.cancel();
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCursorName(String name) throws SQLException {
        this.lock();
        try {
            this.checkState();
            try {
                this.s.setCursorName(name);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        this.lock();
        try {
            this.checkState();
            try {
                ResultSet result = this.s.getResultSet();
                if (result == null) {
                    ResultSet resultSet = null;
                    return resultSet;
                }
                ResultSet resultSet = this.registerResultSet(result);
                return resultSet;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public int getUpdateCount() throws SQLException {
        this.lock();
        try {
            this.checkState();
            try {
                int n = this.s.getUpdateCount();
                return n;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        this.lock();
        try {
            this.checkState();
            try {
                boolean bl = this.s.getMoreResults();
                return bl;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        this.lock();
        try {
            this.checkState();
            try {
                boolean bl = this.s.getMoreResults(current);
                return bl;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.lock();
        try {
            this.checkState();
            try {
                this.s.setFetchDirection(direction);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public int getFetchDirection() throws SQLException {
        this.lock();
        try {
            this.checkState();
            try {
                int n = this.s.getFetchDirection();
                return n;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.lock();
        try {
            this.checkState();
            try {
                this.s.setFetchSize(rows);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public int getFetchSize() throws SQLException {
        this.lock();
        try {
            this.checkState();
            try {
                int n = this.s.getFetchSize();
                return n;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        this.lock();
        try {
            this.checkState();
            try {
                int n = this.s.getResultSetConcurrency();
                return n;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public int getResultSetType() throws SQLException {
        this.lock();
        try {
            this.checkState();
            try {
                int n = this.s.getResultSetType();
                return n;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addBatch(String sql) throws SQLException {
        this.lock();
        try {
            this.checkState();
            try {
                this.s.addBatch(sql);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearBatch() throws SQLException {
        this.lock();
        try {
            this.checkState();
            try {
                this.s.clearBatch();
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public int[] executeBatch() throws SQLException {
        this.lock();
        try {
            this.checkState();
            try {
                this.checkConfiguredQueryTimeout();
                int[] nArray = this.s.executeBatch();
                return nArray;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        this.lock();
        try {
            this.checkState();
            try {
                ResultSet resultSet = this.s.getGeneratedKeys();
                ResultSet resultSet2 = this.registerResultSet(resultSet);
                return resultSet2;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        this.lock();
        try {
            this.checkState();
            try {
                int n = this.s.getResultSetHoldability();
                return n;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Statement getUnderlyingStatement() throws SQLException {
        this.lock();
        try {
            this.checkState();
            Statement statement = this.s;
            return statement;
        }
        finally {
            this.unlock();
        }
    }

    @Override
    protected Statement getWrappedObject() throws SQLException {
        return this.getUnderlyingStatement();
    }

    protected SQLException checkException(Throwable t) throws SQLException {
        throw this.lc.checkException(t);
    }

    protected void checkTransaction() throws SQLException {
        this.checkState();
        this.lc.checkTransaction();
    }

    protected void checkConfiguredQueryTimeout() throws SQLException {
        this.lc.checkConfiguredQueryTimeout(this);
    }

    protected void checkTransactionActive() throws SQLException {
        this.lc.checkTransactionActive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void internalClose() throws SQLException {
        this.closed.set(true);
        try {
            this.closeResultSets();
        }
        finally {
            this.s.close();
        }
    }

    void checkState() throws SQLException {
        if (this.closed.get()) {
            throw new SQLException("The statement is closed.");
        }
    }

    protected abstract WrappedResultSet wrapResultSet(ResultSet var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ResultSet registerResultSet(ResultSet resultSet) {
        if (resultSet != null) {
            resultSet = this.wrapResultSet(resultSet);
        }
        if (this.lc.getTrackStatements() == 0) {
            return resultSet;
        }
        WrappedResultSet wrapped = (WrappedResultSet)resultSet;
        WrappedStatement wrappedStatement = this;
        synchronized (wrappedStatement) {
            if (this.resultSets == null) {
                this.resultSets = new HashMap();
            }
            if (this.lc.getTrackStatements() == 1) {
                this.resultSets.put(wrapped, new Throwable("STACKTRACE"));
            } else {
                this.resultSets.put(wrapped, null);
            }
        }
        return resultSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unregisterResultSet(WrappedResultSet resultSet) {
        if (this.lc.getTrackStatements() == 0) {
            return;
        }
        WrappedStatement wrappedStatement = this;
        synchronized (wrappedStatement) {
            if (this.resultSets != null) {
                this.resultSets.remove(resultSet);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeResultSets() {
        if (this.lc.getTrackStatements() == 0) {
            return;
        }
        WrappedStatement wrappedStatement = this;
        synchronized (wrappedStatement) {
            if (this.resultSets == null) {
                return;
            }
            for (Map.Entry<WrappedResultSet, Throwable> entry : this.resultSets.entrySet()) {
                WrappedResultSet resultSet = entry.getKey();
                if (this.lc.getTrackStatements() == 1) {
                    Throwable stackTrace = entry.getValue();
                    this.lc.getLogger().warn((Object)"Closing a result set you left open! Please close it yourself.", stackTrace);
                }
                try {
                    resultSet.internalClose();
                }
                catch (Throwable t) {
                    this.lc.getLogger().warn((Object)"Error closing a result set you left open! Please close it yourself.", t);
                }
            }
            this.resultSets.clear();
        }
    }
}

