/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.switchboard.mc;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.jboss.beans.metadata.spi.DependencyMetaData;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.logging.Logger;
import org.jboss.reloaded.naming.spi.JavaEEComponent;
import org.jboss.reloaded.naming.spi.JavaEEModule;
import org.jboss.switchboard.mc.dependency.SwitchBoardDependencyMetaData;
import org.jboss.switchboard.spi.Barrier;
import org.jboss.switchboard.spi.Resource;
import org.jboss.util.naming.Util;

public class SwitchBoardImpl
implements Barrier {
    private static Logger logger = Logger.getLogger(SwitchBoardImpl.class);
    private String id;
    private JavaEEComponent javaEEComponent;
    private DeploymentUnit unit;
    private Map<String, Resource> bindings = new HashMap<String, Resource>();
    private boolean contextPopulated;
    private Context javaGlobalContext;

    public SwitchBoardImpl(String barrierId, Map<String, Resource> bindings, DeploymentUnit unit) {
        this.id = barrierId;
        if (bindings != null) {
            this.bindings = bindings;
        }
        this.unit = unit;
    }

    public void start() throws NamingException {
        logger.debug((Object)("Binding entries in java:comp for switchboard: " + this.id));
        this.contextPopulated = true;
        for (Map.Entry<String, Resource> binding : this.bindings.entrySet()) {
            String jndiName = binding.getKey();
            Object jndiObject = binding.getValue().getTarget();
            this.bindInRelevantContext(jndiName, jndiObject);
        }
    }

    public void stop() throws NamingException {
        logger.debug((Object)("Un-binding entries from java:comp for switchboard: " + this.id));
        this.contextPopulated = false;
        for (Map.Entry<String, Resource> binding : this.bindings.entrySet()) {
            String jndiName = binding.getKey();
            this.unbindFromRelevantContext(jndiName);
        }
    }

    public JavaEEComponent getJavaEEComponent() {
        return this.javaEEComponent;
    }

    public void setJavaEEComponent(JavaEEComponent javaComp) {
        this.javaEEComponent = javaComp;
    }

    public void setJavaEEModule(final JavaEEModule javaeeModule) {
        JavaEEComponent javaComp = new JavaEEComponent(){

            public String getName() {
                return javaeeModule.getName();
            }

            public JavaEEModule getModule() {
                return javaeeModule;
            }

            public Context getContext() {
                return javaeeModule.getContext();
            }
        };
        this.setJavaEEComponent(javaComp);
    }

    public void setJavaGlobalContext(Context ctx) {
        if (ctx == null) {
            throw new IllegalArgumentException("java:global context cannot be set to null");
        }
        this.javaGlobalContext = ctx;
    }

    public Context getContext() {
        return this.javaEEComponent == null ? null : this.javaEEComponent.getContext();
    }

    public String getId() {
        return this.id;
    }

    public void addENCBinding(Map<String, Resource> resources) {
        if (resources == null) {
            throw new IllegalArgumentException("Resources cannot be null while adding ENC bindings to switchboard barrier: " + this.id);
        }
        if (this.contextPopulated) {
            throw new IllegalStateException("ENC context for switchboard barrier: " + this.id + " is already populated, cannot add more ENC bindings");
        }
        this.bindings.putAll(resources);
    }

    public Collection<DependencyMetaData> getBindDependencies() {
        ArrayList<DependencyMetaData> dependencies = new ArrayList<DependencyMetaData>();
        for (Resource encBinding : this.bindings.values()) {
            Object dependency = encBinding.getDependency();
            if (dependency == null) continue;
            SwitchBoardDependencyMetaData mcDependency = new SwitchBoardDependencyMetaData(this, dependency, ControllerState.START, ControllerState.INSTALLED);
            dependencies.add((DependencyMetaData)mcDependency);
        }
        return dependencies;
    }

    public Collection<DependencyMetaData> getInvocationDependencies() {
        ArrayList<DependencyMetaData> invocationDependencies = new ArrayList<DependencyMetaData>();
        for (Resource encBinding : this.bindings.values()) {
            Collection deps = encBinding.getInvocationDependencies();
            if (deps == null) continue;
            for (Object dependency : deps) {
                if (dependency == null) continue;
                SwitchBoardDependencyMetaData mcDependency = new SwitchBoardDependencyMetaData(this, dependency, ControllerState.INSTALLED, ControllerState.INSTALLED);
                invocationDependencies.add((DependencyMetaData)mcDependency);
            }
        }
        return invocationDependencies;
    }

    public ClassLoader getClassLoader() {
        return this.unit.getClassLoader();
    }

    public Map<String, Resource> getBindings() {
        return Collections.unmodifiableMap(this.bindings);
    }

    private void bindInRelevantContext(String jndiName, Object jndiObject) throws NamingException {
        String relativeJndiName = jndiName;
        Context ctx = this.javaEEComponent.getContext();
        if (jndiName.trim().startsWith("java:comp/")) {
            relativeJndiName = jndiName.trim().substring("java:comp/".length());
            ctx = this.javaEEComponent.getContext();
        } else if (jndiName.trim().startsWith("java:module/")) {
            relativeJndiName = jndiName.trim().substring("java:module/".length());
            ctx = this.javaEEComponent.getModule().getContext();
        } else if (jndiName.trim().startsWith("java:app/")) {
            relativeJndiName = jndiName.trim().substring("java:app/".length());
            ctx = this.javaEEComponent.getModule().getApplication().getContext();
        } else if (jndiName.trim().startsWith("java:global/")) {
            relativeJndiName = jndiName.trim().substring("java:global/".length());
            if (this.javaGlobalContext == null) {
                logger.debug((Object)("java:global context not set on Switchboard: " + this.id + " will do a manual lookup of java:global context"));
                ctx = (Context)new InitialContext().lookup("java:global/");
            } else {
                ctx = this.javaGlobalContext;
            }
        }
        logger.debug((Object)("Switchboard " + this.id + " binding ENC resource at jndi name: " + jndiName));
        Util.rebind((Context)ctx, (String)relativeJndiName, (Object)jndiObject);
    }

    private void unbindFromRelevantContext(String jndiName) throws NamingException {
        String relativeJndiName = jndiName;
        Context ctx = this.javaEEComponent.getContext();
        if (jndiName.trim().startsWith("java:comp/")) {
            relativeJndiName = jndiName.trim().substring("java:comp/".length());
            ctx = this.javaEEComponent.getContext();
        } else if (jndiName.trim().startsWith("java:module/")) {
            relativeJndiName = jndiName.trim().substring("java:module/".length());
            ctx = this.javaEEComponent.getModule().getContext();
        } else if (jndiName.trim().startsWith("java:app/")) {
            relativeJndiName = jndiName.trim().substring("java:app/".length());
            ctx = this.javaEEComponent.getModule().getApplication().getContext();
        } else if (jndiName.trim().startsWith("java:global/")) {
            relativeJndiName = jndiName.trim().substring("java:global/".length());
            if (this.javaGlobalContext == null) {
                logger.debug((Object)("java:global context not set on Switchboard: " + this.id + " will do a manual lookup of java:global context"));
                ctx = (Context)new InitialContext().lookup("java:global/");
            } else {
                ctx = this.javaGlobalContext;
            }
        }
        logger.debug((Object)("Switchboard " + this.id + " unbinding ENC resource from jndi name: " + jndiName));
        Util.unbind((Context)ctx, (String)relativeJndiName);
    }
}

