/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata.serviceref;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import org.jboss.vfs.VFS;
import org.jboss.vfs.VFSUtils;
import org.jboss.vfs.VirtualFile;
import org.jboss.wsf.spi.deployment.UnifiedVirtualFile;
import org.jboss.wsf.spi.deployment.WritableUnifiedVirtualFile;

public class VirtualFileAdaptor
implements WritableUnifiedVirtualFile {
    private static final long serialVersionUID = -4509594124653184348L;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("rootUrl", URL.class), new ObjectStreamField("path", String.class), new ObjectStreamField("requiresMount", Boolean.TYPE)};
    private URL rootUrl;
    private String path;
    private boolean requiresMount;
    private transient VirtualFile file;

    public VirtualFileAdaptor(VirtualFile file) {
        this.file = file;
    }

    public VirtualFileAdaptor(URL rootUrl, String path) {
        this(rootUrl, path, false);
    }

    protected VirtualFileAdaptor(URL rootUrl, String path, boolean requiresMount) {
        if (rootUrl == null) {
            throw new IllegalArgumentException("Null root url");
        }
        if (path == null) {
            throw new IllegalArgumentException("Null path");
        }
        this.rootUrl = rootUrl;
        this.path = path;
        this.requiresMount = requiresMount;
    }

    protected VirtualFile getFile() throws IOException {
        if (this.file == null) {
            VirtualFile root;
            try {
                root = VFS.getChild((URL)this.rootUrl);
            }
            catch (URISyntaxException e) {
                throw new IOException("Unable to get Virtualfile from URL: " + this.rootUrl, e);
            }
            this.file = root.getChild(this.path);
            if (!this.file.exists()) {
                throw new IOException("VirtualFile " + this.file + " does not exist");
            }
            if (this.requiresMount && !VirtualFileAdaptor.isMounted(root, this.file)) {
                throw new IOException("VirtualFile " + this.file + " is not mounted");
            }
        }
        return this.file;
    }

    private static boolean isMounted(VirtualFile root, VirtualFile child) throws IOException {
        return !root.getPathName().equals(root.getPhysicalFile().getAbsolutePath()) || !child.getPathName().equals(child.getPhysicalFile().getAbsolutePath());
    }

    public UnifiedVirtualFile findChild(String child) throws IOException {
        VirtualFile virtualFile = this.getFile();
        VirtualFile childFile = this.file.getChild(child);
        if (!childFile.exists()) {
            throw new IOException("Child '" + child + "' not found for VirtualFile " + virtualFile);
        }
        return new VirtualFileAdaptor(childFile);
    }

    public URL toURL() {
        try {
            return this.getFile().toURL();
        }
        catch (Exception e) {
            return null;
        }
    }

    public void writeContent(OutputStream bos) throws IOException {
        this.writeContent(bos, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeContent(OutputStream bos, WritableUnifiedVirtualFile.NameFilter filter) throws IOException {
        InputStream is = null;
        try {
            is = this.getFile().openStream();
            if (is instanceof JarInputStream) {
                JarInputStream jis = (JarInputStream)is;
                JarOutputStream os = new JarOutputStream(bos);
                JarEntry je = null;
                while ((je = jis.getNextJarEntry()) != null) {
                    if (filter == null || !filter.accept(je.getName())) continue;
                    os.putNextEntry(je);
                    VFSUtils.copyStream((InputStream)jis, (OutputStream)os);
                }
                VFSUtils.safeClose((Closeable)os);
            } else {
                VFSUtils.copyStream((InputStream)is, (OutputStream)bos);
            }
        }
        finally {
            VFSUtils.safeClose((Closeable)is);
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException, URISyntaxException {
        String pathName;
        VirtualFile file = this.getFile();
        URL url = this.rootUrl;
        if (url == null) {
            VirtualFile parentFile = file.getParent();
            URL uRL = url = parentFile != null ? parentFile.toURL() : null;
        }
        if ((pathName = this.path) == null) {
            pathName = file.getName();
        }
        ObjectOutputStream.PutField fields = out.putFields();
        fields.put("rootUrl", url);
        fields.put("path", pathName);
        VirtualFile newRoot = VFS.getChild((URL)url);
        VirtualFile newChild = newRoot.getChild(pathName);
        fields.put("requiresMount", VirtualFileAdaptor.isMounted(newRoot, newChild));
        out.writeFields();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField fields = in.readFields();
        this.rootUrl = (URL)fields.get("rootUrl", null);
        this.path = (String)fields.get("path", null);
        this.requiresMount = fields.get("requiresMount", false);
    }

    public List<UnifiedVirtualFile> getChildren() throws IOException {
        List vfList = this.getFile().getChildren();
        if (vfList == null) {
            return null;
        }
        LinkedList<UnifiedVirtualFile> uvfList = new LinkedList<UnifiedVirtualFile>();
        for (VirtualFile vf : vfList) {
            uvfList.add((UnifiedVirtualFile)new VirtualFileAdaptor(vf));
        }
        return uvfList;
    }

    public String getName() {
        try {
            return this.getFile().getName();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

