/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.jaxrpc;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.soap.SOAPFaultException;
import javax.xml.soap.Detail;
import javax.xml.soap.DetailEntry;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPConstants;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;
import javax.xml.transform.Result;
import javax.xml.transform.dom.DOMSource;
import org.jboss.logging.Logger;
import org.jboss.ws.Constants;
import org.jboss.ws.WSException;
import org.jboss.ws.core.CommonMessageContext;
import org.jboss.ws.core.CommonSOAPFaultException;
import org.jboss.ws.core.binding.AbstractDeserializerFactory;
import org.jboss.ws.core.binding.AbstractSerializerFactory;
import org.jboss.ws.core.binding.BindingException;
import org.jboss.ws.core.binding.DeserializerSupport;
import org.jboss.ws.core.binding.SerializationContext;
import org.jboss.ws.core.binding.SerializerSupport;
import org.jboss.ws.core.binding.TypeMappingImpl;
import org.jboss.ws.core.jaxrpc.SerializationContextJAXRPC;
import org.jboss.ws.core.soap.MessageContextAssociation;
import org.jboss.ws.core.soap.MessageFactoryImpl;
import org.jboss.ws.core.soap.NameImpl;
import org.jboss.ws.core.soap.SOAPEnvelopeImpl;
import org.jboss.ws.core.soap.SOAPFactoryImpl;
import org.jboss.ws.core.soap.SOAPMessageImpl;
import org.jboss.ws.core.soap.XMLFragment;
import org.jboss.ws.metadata.umdm.EndpointMetaData;
import org.jboss.ws.metadata.umdm.FaultMetaData;
import org.jboss.ws.metadata.umdm.OperationMetaData;
import org.jboss.xb.binding.NamespaceRegistry;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SOAPFaultHelperJAXRPC {
    private static Logger log = Logger.getLogger(SOAPFaultHelperJAXRPC.class);
    private static List<QName> allowedFaultCodes = new ArrayList<QName>();

    private SOAPFaultHelperJAXRPC() {
    }

    public static SOAPFaultException getSOAPFaultException(SOAPFault soapFault) {
        QName faultCode = ((NameImpl)soapFault.getFaultCodeAsName()).toQName();
        String faultString = soapFault.getFaultString();
        String faultActor = soapFault.getFaultActor();
        Detail detail = soapFault.getDetail();
        SOAPFaultException faultEx = new SOAPFaultException(faultCode, faultString, faultActor, detail);
        CommonMessageContext msgContext = MessageContextAssociation.peekMessageContext();
        if (detail != null && msgContext != null) {
            SerializationContext serContext = msgContext.getSerializationContext();
            TypeMappingImpl typeMapping = serContext.getTypeMapping();
            Iterator it = detail.getDetailEntries();
            while (it.hasNext()) {
                DetailEntry deElement = (DetailEntry)it.next();
                Name deName = deElement.getElementName();
                QName xmlName = new QName(deName.getURI(), deName.getLocalName());
                OperationMetaData opMetaData = msgContext.getOperationMetaData();
                FaultMetaData faultMetaData = opMetaData.getFault(xmlName);
                if (faultMetaData != null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Deserialize fault: " + faultMetaData));
                    }
                    QName xmlType = faultMetaData.getXmlType();
                    Class javaType = faultMetaData.getJavaType();
                    AbstractDeserializerFactory desFactory = (AbstractDeserializerFactory)typeMapping.getDeserializer(javaType, xmlType);
                    if (desFactory == null) {
                        throw new JAXRPCException("Cannot obtain deserializer factory for: " + xmlType);
                    }
                    try {
                        String prefix = deName.getPrefix();
                        if (prefix.length() > 0) {
                            String nsURI = deName.getURI();
                            String attrValue = deElement.getAttribute("xmlns:" + prefix);
                            if (nsURI.length() > 0 && attrValue.length() == 0) {
                                deElement.addNamespaceDeclaration(prefix, nsURI);
                            }
                        }
                        DOMSource xmlFragment = new DOMSource((Node)deElement);
                        DeserializerSupport des = desFactory.getDeserializer();
                        Object userEx = des.deserialize(xmlName, xmlType, xmlFragment, serContext);
                        if (userEx == null || !(userEx instanceof Exception)) {
                            throw new WSException("Invalid deserialization result: " + userEx);
                        }
                        faultEx.initCause((Throwable)((Exception)userEx));
                        continue;
                    }
                    catch (RuntimeException rte) {
                        throw rte;
                    }
                    catch (Exception ex) {
                        log.error((Object)"Cannot deserialize fault detail", (Throwable)ex);
                        continue;
                    }
                }
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Cannot find fault meta data for: " + xmlName));
            }
        }
        return faultEx;
    }

    public static SOAPMessageImpl exceptionToFaultMessage(Exception reqEx) {
        SOAPFaultException faultEx;
        if (reqEx instanceof SOAPFaultException) {
            faultEx = (SOAPFaultException)reqEx;
        } else if (reqEx instanceof CommonSOAPFaultException) {
            CommonSOAPFaultException soapEx = (CommonSOAPFaultException)reqEx;
            QName faultCode = soapEx.getFaultCode();
            String faultString = soapEx.getFaultString();
            Throwable cause = soapEx.getCause();
            faultEx = new SOAPFaultException(faultCode, faultString, null, null);
            faultEx.initCause(cause);
        } else {
            QName faultCode = !SOAPFaultHelperJAXRPC.isSOAP12() ? Constants.SOAP11_FAULT_CODE_SERVER : SOAPConstants.SOAP_RECEIVER_FAULT;
            String faultString = reqEx.getMessage() != null ? reqEx.getMessage() : reqEx.toString();
            faultEx = new SOAPFaultException(faultCode, faultString, null, null);
            faultEx.initCause((Throwable)reqEx);
        }
        Throwable faultCause = faultEx.getCause();
        log.error((Object)"SOAP request exception", faultCause != null ? faultCause : faultEx);
        try {
            SOAPMessageImpl faultMessage = SOAPFaultHelperJAXRPC.toSOAPMessage(faultEx);
            return faultMessage;
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (Exception ex) {
            log.error((Object)"Error creating SOAPFault message", (Throwable)ex);
            throw new JAXRPCException("Cannot create SOAPFault message for: " + faultEx);
        }
    }

    private static SOAPMessageImpl toSOAPMessage(SOAPFaultException faultEx) throws SOAPException {
        SOAPFaultHelperJAXRPC.assertFaultCode(faultEx.getFaultCode());
        CommonMessageContext msgContext = MessageContextAssociation.peekMessageContext();
        SerializationContext serContext = msgContext != null ? msgContext.getSerializationContext() : new SerializationContextJAXRPC();
        NamespaceRegistry nsRegistry = serContext.getNamespaceRegistry();
        SOAPMessageImpl soapMessage = SOAPFaultHelperJAXRPC.createSOAPMessage();
        SOAPEnvelopeImpl soapEnvelope = (SOAPEnvelopeImpl)soapMessage.getSOAPPart().getEnvelope();
        SOAPBody soapBody = soapEnvelope.getBody();
        QName faultCode = faultEx.getFaultCode();
        if (faultCode.getNamespaceURI().length() > 0) {
            faultCode = nsRegistry.registerQName(faultCode);
        }
        String faultString = SOAPFaultHelperJAXRPC.getValidFaultString(faultEx);
        SOAPFault soapFault = soapBody.addFault((Name)new NameImpl(faultCode), faultString);
        String faultActor = faultEx.getFaultActor();
        if (faultActor != null) {
            SOAPElement soapElement = soapFault.addChildElement("faultactor");
            soapElement.addTextNode(faultActor);
        }
        Exception faultCause = (Exception)faultEx.getCause();
        Detail detail = faultEx.getDetail();
        if (detail != null) {
            soapFault.addChildElement((SOAPElement)detail);
        } else if (faultCause != null && !(faultCause instanceof RuntimeException)) {
            Class<?> javaType = faultCause.getClass();
            TypeMappingImpl typeMapping = serContext.getTypeMapping();
            OperationMetaData opMetaData = msgContext.getOperationMetaData();
            if (opMetaData != null && opMetaData.getFaultMetaData(javaType) != null) {
                FaultMetaData faultMetaData = opMetaData.getFaultMetaData(javaType);
                QName xmlName = faultMetaData.getXmlName();
                QName xmlType = faultMetaData.getXmlType();
                xmlName = nsRegistry.registerQName(xmlName);
                AbstractSerializerFactory serFactory = (AbstractSerializerFactory)typeMapping.getSerializer(javaType, xmlType);
                if (serFactory == null) {
                    throw new JAXRPCException("Cannot obtain serializer factory for: " + xmlType);
                }
                try {
                    SerializerSupport ser = serFactory.getSerializer();
                    Result result = ser.serialize(xmlName, xmlType, faultCause, serContext, null);
                    XMLFragment xmlFragment = new XMLFragment(result);
                    Element domElement = xmlFragment.toElement();
                    SOAPFactoryImpl soapFactory = new SOAPFactoryImpl();
                    SOAPElement soapElement = soapFactory.createElement(domElement);
                    detail = soapFault.addDetail();
                    detail.addChildElement(soapElement);
                }
                catch (BindingException e) {
                    throw new JAXRPCException((Throwable)e);
                }
            } else if (log.isDebugEnabled()) {
                log.debug((Object)("Cannot obtain fault meta data for: " + javaType));
            }
        }
        return soapMessage;
    }

    private static SOAPMessageImpl createSOAPMessage() throws SOAPException {
        MessageFactoryImpl factory = new MessageFactoryImpl();
        if (SOAPFaultHelperJAXRPC.isSOAP12()) {
            factory.setEnvNamespace("http://www.w3.org/2003/05/soap-envelope");
        }
        return (SOAPMessageImpl)factory.createMessage();
    }

    private static boolean isSOAP12() {
        EndpointMetaData emd;
        String bindingId;
        CommonMessageContext msgContext = MessageContextAssociation.peekMessageContext();
        return msgContext != null && ("http://www.w3.org/2003/05/soap/bindings/HTTP/".equals(bindingId = (emd = msgContext.getEndpointMetaData()).getBindingId()) || "http://www.w3.org/2003/05/soap/bindings/HTTP/?mtom=true".equals(bindingId));
    }

    private static String getValidFaultString(SOAPFaultException faultEx) {
        String faultString = faultEx.getFaultString();
        if (faultString == null || faultString.length() == 0) {
            faultString = "Unqualified " + faultEx.getFaultCode() + " fault";
        }
        return faultString;
    }

    private static void assertFaultCode(QName faultCode) {
        if (faultCode == null) {
            throw new IllegalArgumentException("faultcode cannot be null");
        }
        String nsURI = faultCode.getNamespaceURI();
        if ("".equals(nsURI)) {
            log.warn((Object)("Empty namespace URI with fault code '" + faultCode + "', assuming: " + "http://schemas.xmlsoap.org/soap/envelope/"));
            faultCode = new QName("http://schemas.xmlsoap.org/soap/envelope/", faultCode.getLocalPart());
        }
        if ("http://schemas.xmlsoap.org/soap/envelope/".equals(nsURI) && !allowedFaultCodes.contains(faultCode)) {
            throw new IllegalArgumentException("Illegal faultcode '" + faultCode + "', allowed values are: " + allowedFaultCodes);
        }
    }

    static {
        allowedFaultCodes.add(Constants.SOAP11_FAULT_CODE_CLIENT);
        allowedFaultCodes.add(Constants.SOAP11_FAULT_CODE_SERVER);
        allowedFaultCodes.add(Constants.SOAP11_FAULT_CODE_VERSION_MISMATCH);
        allowedFaultCodes.add(Constants.SOAP11_FAULT_CODE_MUST_UNDERSTAND);
    }
}

