/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.profileservice.config;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.SecureRandom;
import java.util.Random;
import org.jboss.vfs.VFS;
import org.jboss.vfs.VirtualFile;
import org.jboss.vfs.VirtualFileFilter;
import org.jboss.vfs.util.ExtensibleFilter;

public class ArtifactRepositoriesConfig {
    private static final ArtifactRepositoriesConfig INSTANCE = new ArtifactRepositoriesConfig();
    private static final Random RANDOM_NUM_GEN = new SecureRandom();
    private static final String JBOSS_TMP_DIR_PROPERTY = "jboss.server.temp.dir";
    private static final String JVM_TMP_DIR_PROPERTY = "java.io.tmpdir";
    private static final String BACKUP_ROOT_NAME = "original-backup";
    private static final URI tmpDirURI;
    private VirtualFileFilter excludeFilter = new ExtensibleFilter();

    public static ArtifactRepositoriesConfig getInstance() {
        return INSTANCE;
    }

    public URI createBackupURI() throws URISyntaxException {
        VirtualFile tmpDir = VFS.getChild((URI)tmpDirURI).getChild(BACKUP_ROOT_NAME);
        return tmpDir.getChild(Long.toHexString(RANDOM_NUM_GEN.nextLong())).asDirectoryURI();
    }

    public VirtualFileFilter getExcludeFilter() {
        return this.excludeFilter;
    }

    public void setExcludeFilter(VirtualFileFilter excludeFilter) {
        if (excludeFilter == null) {
            throw new IllegalArgumentException("null exclude filter");
        }
        this.excludeFilter = excludeFilter;
    }

    static {
        String configTmpDir = System.getProperty(JBOSS_TMP_DIR_PROPERTY);
        if (configTmpDir == null) {
            configTmpDir = System.getProperty(JVM_TMP_DIR_PROPERTY);
        }
        File tempDirFile = new File(configTmpDir);
        tmpDirURI = tempDirFile.toURI();
    }
}

