/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.profileservice.dependency;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jboss.dependency.spi.Controller;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.dependency.spi.ControllerStateModel;
import org.jboss.dependency.spi.DependencyInfo;
import org.jboss.dependency.spi.DependencyItem;
import org.jboss.profileservice.dependency.ProfileControllerContext;
import org.jboss.profileservice.spi.ProfileKey;
import org.jboss.util.JBossStringBuilder;

public class ProfileValidationUtil {
    protected static void validate(ProfileControllerContext context) throws Exception {
        HashSet<String> errors = new HashSet<String>();
        HashMap<Object, String> map = new HashMap<Object, String>();
        ProfileValidationUtil.validateContext(context, errors, map);
        ProfileValidationUtil.logErrors(errors, map.values());
    }

    protected static void validateContext(ProfileControllerContext context, Set<String> errors, Map<Object, String> incomplete) {
        ProfileKey name = context.getProfileKey();
        ControllerState currentState = context.getState();
        if (ControllerState.ERROR.equals((Object)currentState)) {
            JBossStringBuilder builder = new JBossStringBuilder();
            builder.append("Profile: ").append((Object)name);
            builder.append(" in error due to ").append((Object)context.getError());
            errors.add(builder.toString());
        } else {
            if (incomplete.containsKey(name)) {
                return;
            }
            Controller controller = context.getController();
            DependencyInfo dependencyInfo = context.getDependencyInfo();
            Set dependencies = dependencyInfo.getIDependOn(null);
            ControllerStateModel states = controller.getStates();
            for (DependencyItem dependencyItem : dependencies) {
                if (dependencyItem.isResolved()) continue;
                ControllerState dependentState = dependencyItem.getDependentState();
                if (dependentState == null) {
                    dependentState = ControllerState.INSTALLED;
                }
                ControllerState otherState = null;
                ControllerContext other = null;
                Object iDependOn = dependencyItem.getIDependOn();
                if (context.getName().equals(iDependOn)) continue;
                if (iDependOn != null && (other = controller.getContext(iDependOn, null)) != null) {
                    otherState = other.getState();
                }
                Object otherName = iDependOn;
                if (other instanceof ProfileControllerContext) {
                    otherName = ((ProfileControllerContext)((Object)ProfileControllerContext.class.cast(other))).getProfileKey();
                }
                boolean print = true;
                if (otherState != null && !otherState.equals((Object)ControllerState.ERROR) && !states.isBeforeState(otherState, dependentState)) {
                    print = false;
                }
                if (!print) continue;
                JBossStringBuilder buffer = new JBossStringBuilder();
                buffer.append((Object)name).append(" is missing following dependencies: ");
                buffer.append(otherName).append('{').append(dependentState.getStateString());
                buffer.append(':');
                if (otherName == null) {
                    buffer.append("** UNRESOLVED " + dependencyItem.toHumanReadableString() + " **");
                } else if (other == null) {
                    buffer.append("** NOT FOUND **");
                } else {
                    buffer.append(otherState.getStateString());
                }
                buffer.append('}');
                incomplete.put(name, buffer.toString());
            }
        }
    }

    protected static void logErrors(Set<String> errors, Collection<String> incomplete) throws Exception {
        if (errors.isEmpty() && incomplete.isEmpty()) {
            return;
        }
        JBossStringBuilder buffer = new JBossStringBuilder();
        buffer.append("Incompletely deployed:\n");
        if (errors.size() != 0) {
            buffer.append("\n*** PROFILES IN ERROR: Name -> Error\n");
            for (String error : errors) {
                buffer.append(error).append('\n');
            }
        }
        if (incomplete.size() != 0) {
            buffer.append("\n*** PROFILES MISSING DEPENDENCIES: Name -> Dependency{Required State:Actual State}\n");
            for (String missing : incomplete) {
                buffer.append(missing).append('\n');
            }
        }
        throw new IllegalStateException(buffer.toString());
    }
}

