/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.profileservice.repository.virtual;

import java.io.IOException;
import java.util.Collection;
import org.jboss.profileservice.config.ProfileServiceConfig;
import org.jboss.profileservice.profile.metadata.FileRepositorySourceConfiguration;
import org.jboss.profileservice.repository.artifact.AbstractRepositoryId;
import org.jboss.profileservice.repository.artifact.ArtifactRepositoryManager;
import org.jboss.profileservice.repository.artifact.file.FileArtifactId;
import org.jboss.profileservice.repository.artifact.file.FileRepositoryConfiguration;
import org.jboss.profileservice.repository.artifact.maven.LocalMavenArtifactRepository;
import org.jboss.profileservice.repository.virtual.DelegatingDeploymentRepository;
import org.jboss.profileservice.spi.VirtualDeploymentRepository;
import org.jboss.profileservice.spi.repository.artifact.ArtifactId;
import org.jboss.profileservice.spi.repository.artifact.ArtifactRepository;
import org.jboss.profileservice.spi.repository.artifact.ArtifactRepositoryConfiguration;
import org.jboss.profileservice.spi.repository.artifact.ArtifactRepositoryId;

public class AbstractVirtualProfileFactory {
    protected static final ArtifactRepositoryId MVN_ID = LocalMavenArtifactRepository.REPOSITORY_ID;
    private final ProfileServiceConfig config;
    private ArtifactRepositoryManager repositoryManager;

    public AbstractVirtualProfileFactory(ProfileServiceConfig config) {
        if (config == null) {
            throw new IllegalArgumentException("null configuration");
        }
        this.config = config;
    }

    public ArtifactRepositoryManager getRepositoryManager() {
        return this.repositoryManager;
    }

    public void setRepositoryManager(ArtifactRepositoryManager repositoryManager) {
        this.repositoryManager = repositoryManager;
    }

    public void start() {
        if (this.getRepositoryManager() == null) {
            throw new IllegalStateException("repository manager not injected");
        }
    }

    protected VirtualDeploymentRepository createRepository(FileRepositorySourceConfiguration source) throws IOException {
        if (source != null && source.getGroup() != null) {
            if (source.getRoot() != null && source.getGroup() != null) {
                FileRepositoryConfiguration configuration = new FileRepositoryConfiguration();
                configuration.setOverrideURI(source.getRoot());
                ArtifactRepository<ArtifactId> fileRepository = this.repositoryManager.createArtifactRepository(this.createFileRepositoryId(source.getGroup()), (ArtifactRepositoryConfiguration<ArtifactId>)((ArtifactRepositoryConfiguration)ArtifactRepositoryConfiguration.class.cast(configuration)));
                return new DelegatingDeploymentRepository(this.getRepositoryManager(), this.config.getAssemblyConfiguration(), (ArtifactRepositoryId)fileRepository.getIdentifier());
            }
            if (source.getGroup() != null) {
                ArtifactRepository<ArtifactId> fileRepository = this.repositoryManager.createArtifactRepository(this.createFileRepositoryId(source.getGroup()), null);
                return new DelegatingDeploymentRepository(this.getRepositoryManager(), this.config.getAssemblyConfiguration(), (ArtifactRepositoryId)fileRepository.getIdentifier(), MVN_ID);
            }
        }
        return new DelegatingDeploymentRepository(this.getRepositoryManager(), this.config.getAssemblyConfiguration(), MVN_ID);
    }

    protected void cleanupRepository(VirtualDeploymentRepository repository) {
        Collection repositories = repository.getRepositoryIDs();
        if (repositories != null && !repositories.isEmpty()) {
            for (ArtifactRepositoryId artifactRepository : repositories) {
                this.repositoryManager.removeRepository(artifactRepository);
            }
        }
    }

    protected AbstractRepositoryId createFileRepositoryId(String group) {
        return new AbstractRepositoryId(group, FileArtifactId.TYPE);
    }
}

